/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.misc;

import java.util.List;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;

public class CollectionExecutionExample {
    public static void main(String[] args) throws Exception {
        CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
        Object[] usersArray = new User[]{new User(1, "Peter"), new User(2, "John"), new User(3, "Bill")};
        Object[] emailsArray = new EMail[]{new EMail(1, "Re: Meeting", "How about 1pm?"), new EMail(1, "Re: Meeting", "Sorry, I'm not availble"), new EMail(3, "Re: Re: Project proposal", "Give me a few more days to think about it.")};
        DataSource users = env.fromElements(usersArray);
        DataSource emails = env.fromElements(emailsArray);
        JoinOperator.DefaultJoin joined = users.join((DataSet)emails).where(new String[]{"userIdentifier"}).equalTo(new String[]{"userId"});
        List result = joined.collect();
        for (Tuple2 t : result) {
            System.err.println("Result = " + t);
        }
    }

    public static class EMail {
        public int userId;
        public String subject;
        public String body;

        public EMail() {
        }

        public EMail(int userId, String subject, String body) {
            this.userId = userId;
            this.subject = subject;
            this.body = body;
        }

        public String toString() {
            return "eMail{userId=" + this.userId + " subject=" + this.subject + " body=" + this.body + "}";
        }
    }

    public static class User {
        public int userIdentifier;
        public String name;

        public User() {
        }

        public User(int userIdentifier, String name) {
            this.userIdentifier = userIdentifier;
            this.name = name;
        }

        public String toString() {
            return "User{userIdentifier=" + this.userIdentifier + " name=" + this.name + "}";
        }
    }
}

