/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;

public class EmptyFieldsCountAccumulator {
    private static final String EMPTY_FIELD_ACCUMULATOR = "empty-fields";

    public static void main(String[] args) throws Exception {
        JobExecutionResult result;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataSet<StringTriple> file = EmptyFieldsCountAccumulator.getDataSet(env, params);
        FilterOperator filteredLines = file.filter((FilterFunction)new EmptyFieldFilter());
        if (params.has("output")) {
            filteredLines.writeAsCsv(params.get("output"));
            result = env.execute("Accumulator example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            filteredLines.print();
            result = env.getLastJobExecutionResult();
        }
        List emptyFields = (List)result.getAccumulatorResult(EMPTY_FIELD_ACCUMULATOR);
        System.out.format("Number of detected empty fields per column: %s\n", emptyFields);
    }

    private static DataSet<StringTriple> getDataSet(ExecutionEnvironment env, ParameterTool params) {
        if (params.has("input")) {
            return env.readCsvFile(params.get("input")).fieldDelimiter(";").pojoType(StringTriple.class, new String[0]);
        }
        System.out.println("Executing EmptyFieldsCountAccumulator example with default input data set.");
        System.out.println("Use --input to specify file input.");
        return env.fromCollection(EmptyFieldsCountAccumulator.getExampleInputTuples());
    }

    private static Collection<StringTriple> getExampleInputTuples() {
        ArrayList<StringTriple> inputTuples = new ArrayList<StringTriple>();
        inputTuples.add(new StringTriple("John", "Doe", "Foo Str."));
        inputTuples.add(new StringTriple("Joe", "Johnson", ""));
        inputTuples.add(new StringTriple(null, "Kate Morn", "Bar Blvd."));
        inputTuples.add(new StringTriple("Tim", "Rinny", ""));
        inputTuples.add(new StringTriple("Alicia", "Jackson", "  "));
        return inputTuples;
    }

    public static class StringTriple
    extends Tuple3<String, String, String> {
        public StringTriple() {
        }

        public StringTriple(String f0, String f1, String f2) {
            super((Object)f0, (Object)f1, (Object)f2);
        }
    }

    public static class VectorAccumulator
    implements Accumulator<Integer, ArrayList<Integer>> {
        private final ArrayList<Integer> resultVector;

        public VectorAccumulator() {
            this(new ArrayList<Integer>());
        }

        public VectorAccumulator(ArrayList<Integer> resultVector) {
            this.resultVector = resultVector;
        }

        public void add(Integer position) {
            this.updateResultVector(position, 1);
        }

        private void updateResultVector(int position, int delta) {
            while (this.resultVector.size() <= position) {
                this.resultVector.add(0);
            }
            int component = this.resultVector.get(position);
            this.resultVector.set(position, component + delta);
        }

        public ArrayList<Integer> getLocalValue() {
            return this.resultVector;
        }

        public void resetLocal() {
            this.resultVector.clear();
        }

        public void merge(Accumulator<Integer, ArrayList<Integer>> other) {
            List otherVector = (List)((Object)other.getLocalValue());
            for (int index = 0; index < otherVector.size(); ++index) {
                this.updateResultVector(index, (Integer)otherVector.get(index));
            }
        }

        public Accumulator<Integer, ArrayList<Integer>> clone() {
            return new VectorAccumulator(new ArrayList<Integer>(this.resultVector));
        }

        public String toString() {
            return StringUtils.join(this.resultVector, (char)',');
        }
    }

    public static final class EmptyFieldFilter
    extends RichFilterFunction<StringTriple> {
        private final VectorAccumulator emptyFieldCounter = new VectorAccumulator();

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.getRuntimeContext().addAccumulator(EmptyFieldsCountAccumulator.EMPTY_FIELD_ACCUMULATOR, (Accumulator)this.emptyFieldCounter);
        }

        public boolean filter(StringTriple t) {
            boolean containsEmptyFields = false;
            for (int pos = 0; pos < t.getArity(); ++pos) {
                String field = (String)t.getField(pos);
                if (field != null && !field.trim().isEmpty()) continue;
                containsEmptyFields = true;
                this.emptyFieldCounter.add(pos);
            }
            return !containsEmptyFields;
        }
    }
}

