/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.storage;

import com.google.cloud.storage.BlobId;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class GSBlobIdentifier {
    public final String bucketName;
    public final String objectName;

    public GSBlobIdentifier(String bucketName, String objectName) {
        this.bucketName = (String)Preconditions.checkNotNull((Object)bucketName);
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName);
    }

    public BlobId getBlobId() {
        return BlobId.of(this.bucketName, this.objectName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GSBlobIdentifier that = (GSBlobIdentifier)o;
        return this.bucketName.equals(that.bucketName) && this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.objectName);
    }

    public String toString() {
        return "GSBlobIdentifier{bucketName='" + this.bucketName + '\'' + ", objectName='" + this.objectName + '\'' + '}';
    }

    public static GSBlobIdentifier fromBlobId(BlobId blobId) {
        return new GSBlobIdentifier(blobId.getBucket(), blobId.getName());
    }
}

