/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.BaseService;
import com.google.cloud.Policy;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessions;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.GapicCopyWriter;
import com.google.cloud.storage.GrpcBlobReadChannel;
import com.google.cloud.storage.GrpcBlobWriteChannel;
import com.google.cloud.storage.GrpcConversions;
import com.google.cloud.storage.GrpcResumableSession;
import com.google.cloud.storage.GrpcRetryAlgorithmManager;
import com.google.cloud.storage.GrpcStorageOptions;
import com.google.cloud.storage.GrpcToHttpStatusCodeTranslation;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableSession;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.storage.v2.BucketAccessControl;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.CreateHmacKeyRequest;
import com.google.storage.v2.CreateNotificationConfigRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.storage.v2.DeleteNotificationConfigRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetHmacKeyRequest;
import com.google.storage.v2.GetNotificationConfigRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.GetServiceAccountRequest;
import com.google.storage.v2.HmacKeyMetadata;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListHmacKeysRequest;
import com.google.storage.v2.ListNotificationConfigsRequest;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.ListObjectsResponse;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.NotificationConfig;
import com.google.storage.v2.NotificationConfigName;
import com.google.storage.v2.Object;
import com.google.storage.v2.ObjectAccessControl;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.WriteObjectSpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.threeten.bp.Duration;

@BetaApi
final class GrpcStorageImpl
extends BaseService<StorageOptions>
implements Storage,
StorageInternal {
    private static final byte[] ZERO_BYTES = new byte[0];
    private static final Set<OpenOption> READ_OPS = ImmutableSet.of(StandardOpenOption.READ);
    private static final Set<OpenOption> WRITE_OPS = ImmutableSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private static final Storage.BucketSourceOption[] EMPTY_BUCKET_SOURCE_OPTIONS = new Storage.BucketSourceOption[0];
    private static final UnifiedOpts.Opts<UnifiedOpts.Fields> ALL_BLOB_FIELDS = UnifiedOpts.Opts.from(UnifiedOpts.fields(ImmutableSet.copyOf(Storage.BlobField.values())));
    private static final UnifiedOpts.Opts<UnifiedOpts.Fields> ALL_BUCKET_FIELDS = UnifiedOpts.Opts.from(UnifiedOpts.fields(ImmutableSet.copyOf(Storage.BucketField.values())));
    final StorageClient storageClient;
    final BlobWriteSessionConfig.WriterFactory writerFactory;
    final GrpcConversions codecs;
    final GrpcRetryAlgorithmManager retryAlgorithmManager;
    final SyntaxDecoders syntaxDecoders;
    private final Conversions.Decoder<WriteObjectResponse, BlobInfo> writeObjectResponseBlobInfoDecoder;
    private final UnifiedOpts.Opts<UnifiedOpts.UserProject> defaultOpts;
    @Deprecated
    private final UnifiedOpts.ProjectId defaultProjectId;

    GrpcStorageImpl(GrpcStorageOptions options, StorageClient storageClient, BlobWriteSessionConfig.WriterFactory writerFactory, UnifiedOpts.Opts<UnifiedOpts.UserProject> defaultOpts) {
        super(options);
        this.storageClient = storageClient;
        this.writerFactory = writerFactory;
        this.defaultOpts = defaultOpts;
        this.codecs = Conversions.grpc();
        this.retryAlgorithmManager = options.getRetryAlgorithmManager();
        this.syntaxDecoders = new SyntaxDecoders();
        this.writeObjectResponseBlobInfoDecoder = this.codecs.blobInfo().compose(WriteObjectResponse::getResource);
        this.defaultProjectId = UnifiedOpts.projectId(options.getProjectId());
    }

    @Override
    public void close() throws Exception {
        try (StorageClient s2 = this.storageClient;){
            s2.shutdownNow();
            Duration terminationAwaitDuration = this.getOptions().getTerminationAwaitDuration();
            s2.awaitTermination(terminationAwaitDuration.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        if (bucketInfo.getProject() == null || bucketInfo.getProject().trim().isEmpty()) {
            bucketInfo = bucketInfo.toBuilder().setProject(this.getOptions().getProjectId()).build();
        }
        com.google.storage.v2.Bucket bucket = (com.google.storage.v2.Bucket)this.codecs.bucketInfo().encode(bucketInfo);
        CreateBucketRequest.Builder builder = CreateBucketRequest.newBuilder().setBucket(bucket).setBucketId(bucketInfo.getName()).setParent("projects/_");
        CreateBucketRequest req = opts.createBucketsRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.createBucketCallable().call(req, merge), this.syntaxDecoders.bucket);
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        return this.create(blobInfo, (byte[])null, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = MoreObjects.firstNonNull(content, ZERO_BYTES);
        return this.create(blobInfo, content, 0, content.length, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        return this.internalDirectUpload(blobInfo, opts, ByteBuffer.wrap(content, offset, length)).asBlob(this);
    }

    @Override
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        try {
            return this.createFrom(blobInfo, content, options);
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, path, 0x1000000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo).prepend(this.defaultOpts);
        return this.internalCreateFrom(path, blobInfo, opts);
    }

    @Override
    public Blob internalCreateFrom(Path path, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) throws IOException {
        Objects.requireNonNull(path, "path must be non null");
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new StorageException(0, path + " is a directory");
        }
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        WriteObjectRequest req = this.getWriteObjectRequest(info, opts);
        ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write = this.storageClient.writeObjectCallable().withDefaultCallContext(grpcCallContext);
        ApiFuture<ResumableWrite> start = this.startResumableWrite(grpcCallContext, req);
        ApiFuture<GrpcResumableSession> session2 = ApiFutures.transform(start, rw -> ResumableSession.grpc(this.getOptions(), this.retryAlgorithmManager.idempotent(), write, this.storageClient.queryWriteStatusCallable(), rw, Hasher.noop()), MoreExecutors.directExecutor());
        try {
            GrpcResumableSession got = (GrpcResumableSession)session2.get();
            ResumableOperationResult<@Nullable com.google.storage.v2.Object> put = got.put(RewindableContent.of(path));
            com.google.storage.v2.Object object = put.getObject();
            if (object == null) {
                ResumableOperationResult<@Nullable com.google.storage.v2.Object> query = got.query();
                object = query.getObject();
            }
            return ((BlobInfo)this.codecs.blobInfo().decode(object)).asBlob(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, content, 0x1000000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream in, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        Objects.requireNonNull(blobInfo, "blobInfo must be non null");
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        WriteObjectRequest req = this.getWriteObjectRequest(blobInfo, opts);
        ApiFuture<ResumableWrite> start = this.startResumableWrite(grpcCallContext, req);
        BufferedWritableByteChannelSession<WriteObjectResponse> session = ResumableMedia.gapic().write().byteChannel(this.storageClient.writeObjectCallable().withDefaultCallContext(grpcCallContext)).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.noCopy()).resumable().withRetryConfig(this.getOptions(), this.retryAlgorithmManager.idempotent()).buffered(Buffers.allocateAligned(bufferSize, 262144)).setStartAsync(start).build();
        ReadableByteChannel src = Channels.newChannel(MoreObjects.firstNonNull(in, new ByteArrayInputStream(ZERO_BYTES)));
        try (BufferedWritableByteChannelSession.BufferedWritableByteChannel dst = (BufferedWritableByteChannelSession.BufferedWritableByteChannel)session.open();){
            ByteStreams.copy(src, dst);
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
        return this.getBlob(session.getResult());
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        return this.internalBucketGet(bucket, unwrap);
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucket, Storage.BucketTargetOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucket).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        LockBucketRetentionPolicyRequest.Builder builder = LockBucketRetentionPolicyRequest.newBuilder().setBucket((String)Utils.bucketNameCodec.encode(bucket.getName()));
        LockBucketRetentionPolicyRequest req = opts.lockBucketRetentionPolicyRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.lockBucketRetentionPolicyCallable().call(req, merge), this.syntaxDecoders.bucket);
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        return this.internalBlobGet(blob, unwrap);
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.Fields> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts).prepend(ALL_BUCKET_FIELDS);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        ListBucketsRequest request = this.defaultProjectId.listBuckets().andThen(opts.listBucketsRequest()).apply(ListBucketsRequest.newBuilder()).build();
        try {
            GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
            return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(request), () -> this.storageClient.listBucketsPagedCallable().call(request, merge), resp -> new TransformingPageDecorator((StorageClient.ListBucketsPage)resp.getPage(), this.syntaxDecoders.bucket.andThen(opts.clearBucketFields()), this.getOptions(), this.retryAlgorithmManager.getFor(request)));
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.Fields> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts).prepend(ALL_BLOB_FIELDS);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        ListObjectsRequest.Builder builder = ListObjectsRequest.newBuilder().setParent((String)Utils.bucketNameCodec.encode(bucket));
        ListObjectsRequest req = opts.listObjectsRequest().apply(builder).build();
        try {
            GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
            return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.listObjectsCallable().call(req, merge), resp -> new ListObjectsWithSyntheticDirectoriesPage(grpcCallContext, req, (ListObjectsResponse)resp));
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        if (bucketInfo.getModifiedFields().isEmpty()) {
            return this.internalBucketGet(bucketInfo.getName(), unwrap.constrainTo(UnifiedOpts.BucketSourceOpt.class));
        }
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = unwrap.resolveFrom(bucketInfo).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        com.google.storage.v2.Bucket bucket = (com.google.storage.v2.Bucket)this.codecs.bucketInfo().encode(bucketInfo);
        UpdateBucketRequest.Builder builder = opts.updateBucketsRequest().apply(UpdateBucketRequest.newBuilder().setBucket(bucket));
        builder.getUpdateMaskBuilder().addAllPaths(bucketInfo.getModifiedFields().stream().map(UnifiedOpts.NamedField::getGrpcName).collect(ImmutableList.toImmutableList()));
        UpdateBucketRequest req = builder.build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.updateBucketCallable().call(req, merge), this.syntaxDecoders.bucket);
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        if (blobInfo.getModifiedFields().isEmpty()) {
            return this.internalBlobGet(blobInfo.getBlobId(), unwrap.constrainTo(UnifiedOpts.ObjectSourceOpt.class));
        }
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = unwrap.resolveFrom(blobInfo).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        com.google.storage.v2.Object object = (com.google.storage.v2.Object)this.codecs.blobInfo().encode(blobInfo);
        UpdateObjectRequest.Builder builder = opts.updateObjectsRequest().apply(UpdateObjectRequest.newBuilder().setObject(object));
        builder.getUpdateMaskBuilder().addAllPaths(blobInfo.getModifiedFields().stream().map(UnifiedOpts.NamedField::getGrpcName).collect(ImmutableList.toImmutableList()));
        UpdateObjectRequest req = builder.build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.updateObjectCallable().call(req, merge), this.syntaxDecoders.blob);
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        DeleteBucketRequest.Builder builder = DeleteBucketRequest.newBuilder().setName((String)Utils.bucketNameCodec.encode(bucket));
        DeleteBucketRequest req = opts.deleteBucketsRequest().apply(builder).build();
        try {
            GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
            Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.deleteBucketCallable().call(req, merge), Conversions.Decoder.identity());
            return true;
        }
        catch (StorageException e) {
            return false;
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        try {
            this.internalObjectDelete(blob, opts);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (StorageException e) {
            if (e.getCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Void internalObjectDelete(BlobId id, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> finalOpts = opts.resolveFrom(id).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = finalOpts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        DeleteObjectRequest.Builder builder = DeleteObjectRequest.newBuilder().setBucket((String)Utils.bucketNameCodec.encode(id.getBucket())).setObject(id.getName());
        Utils.ifNonNull(id.getGeneration(), builder::setGeneration);
        DeleteObjectRequest req = finalOpts.deleteObjectsRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (Void)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> {
            this.storageClient.deleteObjectCallable().call(req, merge);
            return null;
        }, Conversions.Decoder.identity());
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = composeRequest.getTargetOpts().prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        ComposeObjectRequest.Builder builder = ComposeObjectRequest.newBuilder();
        composeRequest.getSourceBlobs().stream().map(src -> this.sourceObjectEncode((Storage.ComposeRequest.SourceBlob)src)).forEach(builder::addSourceObjects);
        com.google.storage.v2.Object target = (com.google.storage.v2.Object)this.codecs.blobInfo().encode(composeRequest.getTarget());
        builder.setDestination(target);
        ComposeObjectRequest req = opts.composeObjectsRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.composeObjectCallable().call(req, merge), this.syntaxDecoders.blob);
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        BlobId src = copyRequest.getSource();
        BlobInfo dst = copyRequest.getTarget();
        UnifiedOpts.Opts<UnifiedOpts.UserProject> srcOpts = UnifiedOpts.Opts.unwrap(copyRequest.getSourceOptions()).projectAsSource().resolveFrom(src).prepend(this.defaultOpts);
        UnifiedOpts.Opts<UnifiedOpts.UserProject> dstOpts = UnifiedOpts.Opts.unwrap(copyRequest.getTargetOptions()).resolveFrom(dst).prepend(this.defaultOpts);
        UnifiedOpts.Mapper<RewriteObjectRequest.Builder> mapper = srcOpts.rewriteObjectsRequest().andThen(dstOpts.rewriteObjectsRequest());
        com.google.storage.v2.Object srcProto = (com.google.storage.v2.Object)this.codecs.blobId().encode(src);
        com.google.storage.v2.Object dstProto = (com.google.storage.v2.Object)this.codecs.blobInfo().encode(dst);
        RewriteObjectRequest.Builder b = RewriteObjectRequest.newBuilder().setDestinationName(dstProto.getName()).setDestinationBucket(dstProto.getBucket()).setDestination(dstProto.toBuilder().clearName().clearBucket().clearKmsKey().build()).setSourceBucket(srcProto.getBucket()).setSourceObject(srcProto.getName());
        if (src.getGeneration() != null) {
            b.setSourceGeneration(src.getGeneration());
        }
        if (copyRequest.getMegabytesCopiedPerChunk() != null) {
            b.setMaxBytesRewrittenPerCall(copyRequest.getMegabytesCopiedPerChunk() * 0x100000L);
        }
        RewriteObjectRequest req = mapper.apply(b).build();
        GrpcCallContext grpcCallContext = srcOpts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        UnaryCallable<RewriteObjectRequest, RewriteResponse> callable = this.storageClient.rewriteObjectCallable().withDefaultCallContext(grpcCallContext);
        GrpcCallContext retryContext = Retrying.newCallContext();
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> (RewriteResponse)callable.call(req, retryContext), resp -> new GapicCopyWriter(this, callable, this.retryAlgorithmManager.idempotent(), (RewriteResponse)resp));
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        UnbufferedReadableByteChannelSession<com.google.storage.v2.Object> session = this.unbufferedReadSession(blob, options);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel r = (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)session.open();
             WritableByteChannel w = Channels.newChannel(baos);){
            ByteStreams.copy(r, w);
        }
        catch (ApiException | IOException e) {
            throw StorageException.coalesce(e);
        }
        return baos.toByteArray();
    }

    @Override
    public StorageBatch batch() {
        return (StorageBatch)CrossTransportUtils.throwHttpJsonOnly("batch()");
    }

    @Override
    public GrpcBlobReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.reader(BlobId.of(bucket, blob), options);
    }

    @Override
    public GrpcBlobReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).prepend(this.defaultOpts);
        ReadObjectRequest request = this.getReadObjectRequest(blob, opts);
        Set<StatusCode.Code> codes = GrpcToHttpStatusCodeTranslation.resultRetryAlgorithmToCodes(this.retryAlgorithmManager.getFor(request));
        ApiCallContext grpcCallContext = Retrying.newCallContext().withRetryableCodes((Set)codes);
        return new GrpcBlobReadChannel(this.storageClient.readObjectCallable().withDefaultCallContext(grpcCallContext), request, !opts.autoGzipDecompression());
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        UnbufferedReadableByteChannelSession<com.google.storage.v2.Object> session = this.unbufferedReadSession(blob, options);
        try (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel r = (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)session.open();
             SeekableByteChannel w = Files.newByteChannel(path, WRITE_OPS, new FileAttribute[0]);){
            ByteStreams.copy(r, w);
        }
        catch (ApiException | IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        UnbufferedReadableByteChannelSession<com.google.storage.v2.Object> session = this.unbufferedReadSession(blob, options);
        try (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel r = (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)session.open();
             WritableByteChannel w = Channels.newChannel(outputStream);){
            ByteStreams.copy(r, w);
        }
        catch (ApiException | IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public GrpcBlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo).prepend(this.defaultOpts);
        return this.internalWriter(blobInfo, opts);
    }

    @Override
    public GrpcBlobWriteChannel internalWriter(BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        WriteObjectRequest req = this.getWriteObjectRequest(info, opts);
        Hasher hasher = Hasher.noop();
        return new GrpcBlobWriteChannel(this.storageClient.writeObjectCallable(), this.getOptions(), this.retryAlgorithmManager.idempotent(), () -> this.startResumableWrite(grpcCallContext, req), hasher);
    }

    @Override
    public BlobInfo internalDirectUpload(BlobInfo blobInfo, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, ByteBuffer buf) {
        Objects.requireNonNull(blobInfo, "blobInfo must be non null");
        Objects.requireNonNull(buf, "content must be non null");
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> optsWithDefaults = opts.prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = optsWithDefaults.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        WriteObjectRequest req = this.getWriteObjectRequest(blobInfo, optsWithDefaults);
        Hasher hasher = Hasher.enabled();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        RewindableContent content = RewindableContent.of(buf);
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> {
            content.rewindTo(0L);
            UnbufferedWritableByteChannelSession<WriteObjectResponse> session = ResumableMedia.gapic().write().byteChannel(this.storageClient.writeObjectCallable().withDefaultCallContext(merge)).setByteStringStrategy(ByteStringStrategy.noCopy()).setHasher(hasher).direct().unbuffered().setRequest(req).build();
            try (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel c = (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)session.open();){
                content.writeTo(c);
            }
            return session.getResult();
        }, this::getBlob);
    }

    @Override
    public WriteChannel writer(URL signedURL) {
        return (WriteChannel)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("writer", URL.class));
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return (URL)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("signUrl", BlobInfo.class, Long.TYPE, TimeUnit.class, Storage.SignUrlOption.class));
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return (PostPolicyV4)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("generateSignedPostPolicyV4", BlobInfo.class, Long.TYPE, TimeUnit.class, PostPolicyV4.PostFieldsV4.class, PostPolicyV4.PostConditionsV4.class, Storage.PostPolicyV4Option.class));
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return (PostPolicyV4)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("generateSignedPostPolicyV4", BlobInfo.class, Long.TYPE, TimeUnit.class, PostPolicyV4.PostFieldsV4.class, Storage.PostPolicyV4Option.class));
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return (PostPolicyV4)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("generateSignedPostPolicyV4", BlobInfo.class, Long.TYPE, TimeUnit.class, PostPolicyV4.PostConditionsV4.class, Storage.PostPolicyV4Option.class));
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return (PostPolicyV4)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("generateSignedPostPolicyV4", BlobInfo.class, Long.TYPE, TimeUnit.class, Storage.PostPolicyV4Option.class));
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("get", BlobId[].class));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("get", Iterable.class));
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("update", BlobInfo[].class));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("update", Iterable.class));
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("delete", BlobId[].class));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        return (List)CrossTransportUtils.throwHttpJsonOnly(CrossTransportUtils.fmtMethodName("delete", Iterable.class));
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        try {
            UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
            com.google.storage.v2.Bucket resp = this.getBucketWithAcls(bucket, opts);
            Predicate<BucketAccessControl> entityPredicate = StorageV2ProtoUtils.bucketAclEntityOrAltEq((String)this.codecs.entity().encode(entity));
            Optional<BucketAccessControl> first = resp.getAclList().stream().filter(entityPredicate).findFirst();
            return first.map(this.codecs.bucketAcl()::decode).orElse(null);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return null;
            }
            throw se;
        }
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.getAcl(bucket, entity, EMPTY_BUCKET_SOURCE_OPTIONS);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        try {
            UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
            com.google.storage.v2.Bucket resp = this.getBucketWithAcls(bucket, opts);
            String encode = (String)this.codecs.entity().encode(entity);
            Predicate<BucketAccessControl> entityPredicate = StorageV2ProtoUtils.bucketAclEntityOrAltEq(encode);
            List<BucketAccessControl> currentAcls = resp.getAclList();
            ImmutableList<BucketAccessControl> newAcls = currentAcls.stream().filter(entityPredicate.negate()).collect(ImmutableList.toImmutableList());
            if (newAcls.equals(currentAcls)) {
                return false;
            }
            long metageneration = resp.getMetageneration();
            UpdateBucketRequest req = GrpcStorageImpl.createUpdateBucketAclRequest(bucket, newAcls, metageneration);
            com.google.storage.v2.Bucket updateResult = this.updateBucket(req);
            Optional<BucketAccessControl> first = updateResult.getAclList().stream().filter(entityPredicate).findFirst();
            return !first.isPresent();
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return false;
            }
            throw se;
        }
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.deleteAcl(bucket, entity, EMPTY_BUCKET_SOURCE_OPTIONS);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        return this.updateAcl(bucket, acl, options);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        return this.createAcl(bucket, acl, EMPTY_BUCKET_SOURCE_OPTIONS);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        try {
            UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
            com.google.storage.v2.Bucket resp = this.getBucketWithAcls(bucket, opts);
            BucketAccessControl encode = (BucketAccessControl)this.codecs.bucketAcl().encode(acl);
            String entity = encode.getEntity();
            Predicate<BucketAccessControl> entityPredicate = StorageV2ProtoUtils.bucketAclEntityOrAltEq(entity);
            ImmutableList<BucketAccessControl> newDefaultAcls = Streams.concat(resp.getAclList().stream().filter(entityPredicate.negate()), Stream.of(encode)).collect(ImmutableList.toImmutableList());
            UpdateBucketRequest req = GrpcStorageImpl.createUpdateBucketAclRequest(bucket, newDefaultAcls, resp.getMetageneration());
            com.google.storage.v2.Bucket updateResult = this.updateBucket(req);
            Optional<Acl> first = updateResult.getAclList().stream().filter(entityPredicate).findFirst().map(this.codecs.bucketAcl()::decode);
            return first.orElseThrow(() -> new StorageException(0, "Acl update call success, but not in response"));
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        return this.updateAcl(bucket, acl, EMPTY_BUCKET_SOURCE_OPTIONS);
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        try {
            UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
            com.google.storage.v2.Bucket resp = this.getBucketWithAcls(bucket, opts);
            return resp.getAclList().stream().map(this.codecs.bucketAcl()::decode).collect(ImmutableList.toImmutableList());
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        return this.listAcls(bucket, EMPTY_BUCKET_SOURCE_OPTIONS);
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        try {
            com.google.storage.v2.Bucket resp = this.getBucketWithDefaultAcls(bucket);
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq((String)this.codecs.entity().encode(entity));
            Optional<ObjectAccessControl> first = resp.getDefaultObjectAclList().stream().filter(entityPredicate).findFirst();
            return first.map(this.codecs.objectAcl()::decode).orElse(null);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return null;
            }
            throw se;
        }
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        try {
            com.google.storage.v2.Bucket resp = this.getBucketWithDefaultAcls(bucket);
            String encode = (String)this.codecs.entity().encode(entity);
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq(encode);
            List<ObjectAccessControl> currentDefaultAcls = resp.getDefaultObjectAclList();
            ImmutableList<ObjectAccessControl> newDefaultAcls = currentDefaultAcls.stream().filter(entityPredicate.negate()).collect(ImmutableList.toImmutableList());
            if (newDefaultAcls.equals(currentDefaultAcls)) {
                return false;
            }
            long metageneration = resp.getMetageneration();
            UpdateBucketRequest req = GrpcStorageImpl.createUpdateDefaultAclRequest(bucket, newDefaultAcls, metageneration);
            com.google.storage.v2.Bucket updateResult = this.updateBucket(req);
            Optional<ObjectAccessControl> first = updateResult.getDefaultObjectAclList().stream().filter(entityPredicate).findFirst();
            return !first.isPresent();
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return false;
            }
            throw se;
        }
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        return this.updateDefaultAcl(bucket, acl);
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        try {
            com.google.storage.v2.Bucket resp = this.getBucketWithDefaultAcls(bucket);
            ObjectAccessControl encode = (ObjectAccessControl)this.codecs.objectAcl().encode(acl);
            String entity = encode.getEntity();
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq(entity);
            ImmutableList<ObjectAccessControl> newDefaultAcls = Streams.concat(resp.getDefaultObjectAclList().stream().filter(entityPredicate.negate()), Stream.of(encode)).collect(ImmutableList.toImmutableList());
            UpdateBucketRequest req = GrpcStorageImpl.createUpdateDefaultAclRequest(bucket, newDefaultAcls, resp.getMetageneration());
            com.google.storage.v2.Bucket updateResult = this.updateBucket(req);
            Optional<Acl> first = updateResult.getDefaultObjectAclList().stream().filter(entityPredicate).findFirst().map(this.codecs.objectAcl()::decode);
            return first.orElseThrow(() -> new StorageException(0, "Acl update call success, but not in response"));
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        try {
            com.google.storage.v2.Bucket resp = this.getBucketWithDefaultAcls(bucket);
            return resp.getDefaultObjectAclList().stream().map(this.codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList());
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        try {
            com.google.storage.v2.Object req = (com.google.storage.v2.Object)this.codecs.blobId().encode(blob);
            com.google.storage.v2.Object resp = this.getObjectWithAcls(req);
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq((String)this.codecs.entity().encode(entity));
            Optional<ObjectAccessControl> first = resp.getAclList().stream().filter(entityPredicate).findFirst();
            return first.map(this.codecs.objectAcl()::decode).orElse(null);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return null;
            }
            throw se;
        }
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        try {
            com.google.storage.v2.Object obj = (com.google.storage.v2.Object)this.codecs.blobId().encode(blob);
            com.google.storage.v2.Object resp = this.getObjectWithAcls(obj);
            String encode = (String)this.codecs.entity().encode(entity);
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq(encode);
            List<ObjectAccessControl> currentDefaultAcls = resp.getAclList();
            ImmutableList<ObjectAccessControl> newDefaultAcls = currentDefaultAcls.stream().filter(entityPredicate.negate()).collect(ImmutableList.toImmutableList());
            if (newDefaultAcls.equals(currentDefaultAcls)) {
                return false;
            }
            long metageneration = resp.getMetageneration();
            UpdateObjectRequest req = GrpcStorageImpl.createUpdateObjectAclRequest(obj, newDefaultAcls, metageneration);
            com.google.storage.v2.Object updateResult = this.updateObject(req);
            Optional<ObjectAccessControl> first = updateResult.getAclList().stream().filter(entityPredicate).findFirst();
            return !first.isPresent();
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (StorageException se) {
            if (se.getCode() == 404) {
                return false;
            }
            throw se;
        }
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        return this.updateAcl(blob, acl);
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        try {
            com.google.storage.v2.Object obj = (com.google.storage.v2.Object)this.codecs.blobId().encode(blob);
            com.google.storage.v2.Object resp = this.getObjectWithAcls(obj);
            ObjectAccessControl encode = (ObjectAccessControl)this.codecs.objectAcl().encode(acl);
            String entity = encode.getEntity();
            Predicate<ObjectAccessControl> entityPredicate = StorageV2ProtoUtils.objectAclEntityOrAltEq(entity);
            ImmutableList<ObjectAccessControl> newDefaultAcls = Streams.concat(resp.getAclList().stream().filter(entityPredicate.negate()), Stream.of(encode)).collect(ImmutableList.toImmutableList());
            UpdateObjectRequest req = GrpcStorageImpl.createUpdateObjectAclRequest(obj, newDefaultAcls, resp.getMetageneration());
            com.google.storage.v2.Object updateResult = this.updateObject(req);
            Optional<Acl> first = updateResult.getAclList().stream().filter(entityPredicate).findFirst().map(this.codecs.objectAcl()::decode);
            return first.orElseThrow(() -> new StorageException(0, "Acl update call success, but not in response"));
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        try {
            com.google.storage.v2.Object req = (com.google.storage.v2.Object)this.codecs.blobId().encode(blob);
            com.google.storage.v2.Object resp = this.getObjectWithAcls(req);
            return resp.getAclList().stream().map(this.codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList());
        }
        catch (NotFoundException e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        CreateHmacKeyRequest request = this.defaultProjectId.createHmacKey().andThen(opts.createHmacKeysRequest()).apply(CreateHmacKeyRequest.newBuilder()).setServiceAccountEmail(serviceAccount.getEmail()).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(request), () -> this.storageClient.createHmacKeyCallable().call(request, merge), resp -> {
            ByteString secretKeyBytes = resp.getSecretKeyBytes();
            String b64SecretKey = BaseEncoding.base64().encode(secretKeyBytes.toByteArray());
            return HmacKey.newBuilder(b64SecretKey).setMetadata((HmacKey.HmacKeyMetadata)this.codecs.hmacKeyMetadata().decode(resp.getMetadata())).build();
        });
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        ListHmacKeysRequest request = this.defaultProjectId.listHmacKeys().andThen(opts.listHmacKeysRequest()).apply(ListHmacKeysRequest.newBuilder()).build();
        try {
            GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
            return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(request), () -> this.storageClient.listHmacKeysPagedCallable().call(request, merge), resp -> new TransformingPageDecorator((StorageClient.ListHmacKeysPage)resp.getPage(), this.codecs.hmacKeyMetadata(), this.getOptions(), this.retryAlgorithmManager.getFor(request)));
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        GetHmacKeyRequest request = this.defaultProjectId.getHmacKey().andThen(opts.getHmacKeysRequest()).apply(GetHmacKeyRequest.newBuilder()).setAccessId(accessId).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (HmacKey.HmacKeyMetadata)((Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(request), () -> this.storageClient.getHmacKeyCallable().call(request, merge), this.codecs.hmacKeyMetadata()));
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.DeleteHmacKeyOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        DeleteHmacKeyRequest req = DeleteHmacKeyRequest.newBuilder().setAccessId(hmacKeyMetadata.getAccessId()).setProject((String)Utils.projectNameCodec.encode(hmacKeyMetadata.getProjectId())).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> {
            this.storageClient.deleteHmacKeyCallable().call(req, merge);
            return null;
        }, Conversions.Decoder.identity());
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        HmacKeyMetadata encode = ((HmacKeyMetadata)this.codecs.hmacKeyMetadata().encode(hmacKeyMetadata)).toBuilder().setState(state.name()).build();
        UpdateHmacKeyRequest.Builder builder = opts.updateHmacKeysRequest().apply(UpdateHmacKeyRequest.newBuilder()).setHmacKey(encode);
        UpdateHmacKeyRequest request = builder.setUpdateMask(FieldMask.newBuilder().addPaths("state").build()).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (HmacKey.HmacKeyMetadata)((Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(request), () -> this.storageClient.updateHmacKeyCallable().call(request, merge), this.codecs.hmacKeyMetadata()));
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        GetIamPolicyRequest.Builder builder = GetIamPolicyRequest.newBuilder().setResource((String)Utils.bucketNameCodec.encode(bucket));
        GetIamPolicyRequest req = opts.getIamPolicyRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (Policy)((Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getIamPolicyCallable().call(req, merge), this.codecs.policyCodec()));
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        SetIamPolicyRequest req = SetIamPolicyRequest.newBuilder().setResource((String)Utils.bucketNameCodec.encode(bucket)).setPolicy((com.google.iam.v1.Policy)this.codecs.policyCodec().encode(policy)).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (Policy)((Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.setIamPolicyCallable().call(req, merge), this.codecs.policyCodec()));
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.UserProject> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).prepend(this.defaultOpts);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        TestIamPermissionsRequest req = TestIamPermissionsRequest.newBuilder().setResource((String)Utils.bucketNameCodec.encode(bucket)).addAllPermissions(permissions).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.testIamPermissionsCallable().call(req, merge), resp -> {
            ImmutableSet<String> heldPermissions = ImmutableSet.copyOf(resp.getPermissionsList());
            return permissions.stream().map(heldPermissions::contains).collect(ImmutableList.toImmutableList());
        });
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        GetServiceAccountRequest req = GetServiceAccountRequest.newBuilder().setProject((String)Utils.projectNameCodec.encode(projectId)).build();
        GrpcCallContext retryContext = Retrying.newCallContext();
        return (ServiceAccount)((Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getServiceAccountCallable().call(req, retryContext), this.codecs.serviceAccount()));
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        NotificationConfig encode = (NotificationConfig)this.codecs.notificationInfo().encode(notificationInfo);
        CreateNotificationConfigRequest req = CreateNotificationConfigRequest.newBuilder().setParent((String)Utils.bucketNameCodec.encode(bucket)).setNotificationConfig(encode).build();
        GrpcCallContext retryContext = Retrying.newCallContext();
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.createNotificationConfigCallable().call(req, retryContext), this.syntaxDecoders.notificationConfig);
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        String name;
        if (NotificationConfigName.isParsableFrom(notificationId)) {
            name = notificationId;
        } else {
            NotificationConfigName configName = NotificationConfigName.of("_", bucket, notificationId);
            name = configName.toString();
        }
        GetNotificationConfigRequest req = GetNotificationConfigRequest.newBuilder().setName(name).build();
        GrpcCallContext retryContext = Retrying.newCallContext();
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> {
            try {
                return this.storageClient.getNotificationConfigCallable().call(req, retryContext);
            }
            catch (NotFoundException e) {
                return null;
            }
        }, this.syntaxDecoders.notificationConfig);
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        ListNotificationConfigsRequest req = ListNotificationConfigsRequest.newBuilder().setParent((String)Utils.bucketNameCodec.encode(bucket)).build();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getFor(req);
        GrpcCallContext retryContext = Retrying.newCallContext();
        return Retrying.run(this.getOptions(), algorithm, () -> this.storageClient.listNotificationConfigsPagedCallable().call(req, retryContext), resp -> {
            TransformingPageDecorator page = new TransformingPageDecorator((StorageClient.ListNotificationConfigsPage)resp.getPage(), this.syntaxDecoders.notificationConfig, this.getOptions(), algorithm);
            return ImmutableList.copyOf(page.iterateAll());
        });
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        String name;
        if (NotificationConfigName.isParsableFrom(notificationId)) {
            name = notificationId;
        } else {
            NotificationConfigName configName = NotificationConfigName.of("_", bucket, notificationId);
            name = configName.toString();
        }
        DeleteNotificationConfigRequest req = DeleteNotificationConfigRequest.newBuilder().setName(name).build();
        GrpcCallContext retryContext = Retrying.newCallContext();
        return Boolean.TRUE.equals(Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> {
            try {
                this.storageClient.deleteNotificationConfigCallable().call(req, retryContext);
                return true;
            }
            catch (NotFoundException e) {
                return false;
            }
        }, Conversions.Decoder.identity()));
    }

    @Override
    @BetaApi
    public BlobWriteSession blobWriteSession(BlobInfo info, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(info);
        WritableByteChannelSession<?, BlobInfo> writableByteChannelSession = this.writerFactory.writeSession(this, info, opts, this.writeObjectResponseBlobInfoDecoder);
        return BlobWriteSessions.of(writableByteChannelSession);
    }

    @Override
    public GrpcStorageOptions getOptions() {
        return (GrpcStorageOptions)super.getOptions();
    }

    boolean isClosed() {
        return this.storageClient.isShutdown();
    }

    private Blob getBlob(ApiFuture<WriteObjectResponse> result) {
        try {
            WriteObjectResponse response = ApiExceptions.callAndTranslateApiException(result);
            return this.syntaxDecoders.blob.decode(response.getResource());
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    private static <T> Stream<T> streamIterate(final T seed, final Predicate<? super T> shouldComputeNext, final UnaryOperator<T> computeNext) {
        Objects.requireNonNull(seed, "seed must be non null");
        Objects.requireNonNull(shouldComputeNext, "shouldComputeNext must be non null");
        Objects.requireNonNull(computeNext, "computeNext must be non null");
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            T prev;
            boolean started;
            boolean done;
            {
                super(arg0, arg1);
                this.started = false;
                this.done = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object next;
                if (!this.started) {
                    this.started = true;
                    action.accept(seed);
                    this.prev = seed;
                    return true;
                }
                if (this.done) {
                    return false;
                }
                if (shouldComputeNext.test(this.prev) && (next = computeNext.apply(this.prev)) != null) {
                    action.accept(next);
                    this.prev = next;
                    return true;
                }
                this.done = true;
                return false;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    ReadObjectRequest getReadObjectRequest(BlobId blob, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts) {
        com.google.storage.v2.Object object = (com.google.storage.v2.Object)this.codecs.blobId().encode(blob);
        ReadObjectRequest.Builder builder = ReadObjectRequest.newBuilder().setBucket(object.getBucket()).setObject(object.getName());
        long generation = object.getGeneration();
        if (generation > 0L) {
            builder.setGeneration(generation);
        }
        return opts.readObjectRequest().apply(builder).build();
    }

    WriteObjectRequest getWriteObjectRequest(BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        com.google.storage.v2.Object object = (com.google.storage.v2.Object)this.codecs.blobInfo().encode(info);
        Object.Builder objectBuilder = object.toBuilder().clearChecksums().clearGeneration().clearMetageneration().clearSize().clearCreateTime().clearUpdateTime();
        WriteObjectSpec.Builder specBuilder = WriteObjectSpec.newBuilder().setResource(objectBuilder);
        WriteObjectRequest.Builder requestBuilder = WriteObjectRequest.newBuilder().setWriteObjectSpec(specBuilder);
        return opts.writeObjectRequest().apply(requestBuilder).build();
    }

    private UnbufferedReadableByteChannelSession<com.google.storage.v2.Object> unbufferedReadSession(BlobId blob, Storage.BlobSourceOption[] options) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).prepend(this.defaultOpts);
        ReadObjectRequest readObjectRequest = this.getReadObjectRequest(blob, opts);
        Set<StatusCode.Code> codes = GrpcToHttpStatusCodeTranslation.resultRetryAlgorithmToCodes(this.retryAlgorithmManager.getFor(readObjectRequest));
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply((GrpcCallContext)Retrying.newCallContext().withRetryableCodes((Set)codes));
        return ResumableMedia.gapic().read().byteChannel(this.storageClient.readObjectCallable().withDefaultCallContext(grpcCallContext)).setAutoGzipDecompression(!opts.autoGzipDecompression()).unbuffered().setReadObjectRequest(readObjectRequest).build();
    }

    @VisibleForTesting
    ApiFuture<ResumableWrite> startResumableWrite(GrpcCallContext grpcCallContext, WriteObjectRequest req) {
        Set<StatusCode.Code> codes = GrpcToHttpStatusCodeTranslation.resultRetryAlgorithmToCodes(this.retryAlgorithmManager.getFor(req));
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return ResumableMedia.gapic().write().resumableWrite(this.storageClient.startResumableWriteCallable().withDefaultCallContext(merge.withRetryableCodes((Set)codes)), req);
    }

    private ComposeObjectRequest.SourceObject sourceObjectEncode(Storage.ComposeRequest.SourceBlob from) {
        ComposeObjectRequest.SourceObject.Builder to = ComposeObjectRequest.SourceObject.newBuilder();
        to.setName(from.getName());
        Utils.ifNonNull(from.getGeneration(), to::setGeneration);
        return to.build();
    }

    private com.google.storage.v2.Bucket getBucketWithDefaultAcls(String bucketName) {
        UnifiedOpts.Fields fields = UnifiedOpts.fields(ImmutableSet.of(Storage.BucketField.ACL, Storage.BucketField.DEFAULT_OBJECT_ACL, Storage.BucketField.METAGENERATION));
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault();
        GetBucketRequest req = fields.getBucket().apply(GetBucketRequest.newBuilder()).setName((String)Utils.bucketNameCodec.encode(bucketName)).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (com.google.storage.v2.Bucket)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getBucketCallable().call(req, merge), Conversions.Decoder.identity());
    }

    private com.google.storage.v2.Bucket getBucketWithAcls(String bucketName, UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> opts) {
        UnifiedOpts.Fields fields = UnifiedOpts.fields(ImmutableSet.of(Storage.BucketField.ACL, Storage.BucketField.METAGENERATION));
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault();
        UnifiedOpts.Mapper<GetBucketRequest.Builder> mapper = opts.getBucketsRequest().andThen(fields.getBucket());
        GetBucketRequest req = mapper.apply(GetBucketRequest.newBuilder()).setName((String)Utils.bucketNameCodec.encode(bucketName)).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (com.google.storage.v2.Bucket)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getBucketCallable().call(req, merge), Conversions.Decoder.identity());
    }

    private com.google.storage.v2.Bucket updateBucket(UpdateBucketRequest req) {
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (com.google.storage.v2.Bucket)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.updateBucketCallable().call(req, merge), Conversions.Decoder.identity());
    }

    private static UpdateBucketRequest createUpdateDefaultAclRequest(String bucket, ImmutableList<ObjectAccessControl> newDefaultAcls, long metageneration) {
        com.google.storage.v2.Bucket update2 = com.google.storage.v2.Bucket.newBuilder().setName((String)Utils.bucketNameCodec.encode(bucket)).addAllDefaultObjectAcl(newDefaultAcls).build();
        UnifiedOpts.Opts<UnifiedOpts.BucketTargetOpt[]> opts = UnifiedOpts.Opts.from(new UnifiedOpts.BucketTargetOpt[]{UnifiedOpts.fields(ImmutableSet.of(Storage.BucketField.DEFAULT_OBJECT_ACL)), UnifiedOpts.metagenerationMatch(metageneration)});
        return opts.updateBucketsRequest().apply(UpdateBucketRequest.newBuilder()).setBucket(update2).build();
    }

    private static UpdateBucketRequest createUpdateBucketAclRequest(String bucket, ImmutableList<BucketAccessControl> newDefaultAcls, long metageneration) {
        com.google.storage.v2.Bucket update2 = com.google.storage.v2.Bucket.newBuilder().setName((String)Utils.bucketNameCodec.encode(bucket)).addAllAcl(newDefaultAcls).build();
        UnifiedOpts.Opts<UnifiedOpts.BucketTargetOpt[]> opts = UnifiedOpts.Opts.from(new UnifiedOpts.BucketTargetOpt[]{UnifiedOpts.fields(ImmutableSet.of(Storage.BucketField.ACL)), UnifiedOpts.metagenerationMatch(metageneration)});
        return opts.updateBucketsRequest().apply(UpdateBucketRequest.newBuilder()).setBucket(update2).build();
    }

    private com.google.storage.v2.Object getObjectWithAcls(com.google.storage.v2.Object obj) {
        UnifiedOpts.Fields fields = UnifiedOpts.fields(ImmutableSet.of(Storage.BucketField.ACL, Storage.BucketField.METAGENERATION));
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault();
        GetObjectRequest req = fields.getObject().apply(GetObjectRequest.newBuilder()).setBucket(obj.getBucket()).setObject(obj.getName()).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (com.google.storage.v2.Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getObjectCallable().call(req, merge), Conversions.Decoder.identity());
    }

    private static UpdateObjectRequest createUpdateObjectAclRequest(com.google.storage.v2.Object obj, ImmutableList<ObjectAccessControl> newAcls, long metageneration) {
        com.google.storage.v2.Object update2 = com.google.storage.v2.Object.newBuilder().setBucket(obj.getBucket()).setName(obj.getName()).addAllAcl(newAcls).build();
        UnifiedOpts.Opts<UnifiedOpts.BucketTargetOpt[]> opts = UnifiedOpts.Opts.from(new UnifiedOpts.BucketTargetOpt[]{UnifiedOpts.fields(ImmutableSet.of(Storage.BlobField.ACL)), UnifiedOpts.metagenerationMatch(metageneration)});
        return opts.updateObjectsRequest().apply(UpdateObjectRequest.newBuilder()).setObject(update2).build();
    }

    private com.google.storage.v2.Object updateObject(UpdateObjectRequest req) {
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return (com.google.storage.v2.Object)Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.updateObjectCallable().call(req, merge), Conversions.Decoder.identity());
    }

    @Override
    public @NonNull BlobInfo internalObjectGet(BlobId blobId, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts) {
        UnifiedOpts.Opts<UnifiedOpts.Fields> finalOpts = opts.prepend(this.defaultOpts).prepend(ALL_BLOB_FIELDS);
        GrpcCallContext grpcCallContext = finalOpts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        GetObjectRequest.Builder builder = GetObjectRequest.newBuilder().setBucket((String)Utils.bucketNameCodec.encode(blobId.getBucket())).setObject(blobId.getName());
        Utils.ifNonNull(blobId.getGeneration(), builder::setGeneration);
        GetObjectRequest req = finalOpts.getObjectsRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getObjectCallable().call(req, merge), resp -> {
            BlobInfo tmp = (BlobInfo)this.codecs.blobInfo().decode(resp);
            return finalOpts.clearBlobFields().decode(tmp);
        });
    }

    private @Nullable Blob internalBlobGet(BlobId blob, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> unwrap) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts = unwrap.resolveFrom(blob);
        try {
            return this.internalObjectGet(blob, opts).asBlob(this);
        }
        catch (StorageException e) {
            if (e.getCause() instanceof NotFoundException) {
                return null;
            }
            throw e;
        }
        catch (NotFoundException nfe) {
            return null;
        }
    }

    private @Nullable Bucket internalBucketGet(String bucket, UnifiedOpts.Opts<UnifiedOpts.BucketSourceOpt> unwrap) {
        UnifiedOpts.Opts<UnifiedOpts.Fields> opts = unwrap.prepend(this.defaultOpts).prepend(ALL_BUCKET_FIELDS);
        GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
        GetBucketRequest.Builder builder = GetBucketRequest.newBuilder().setName((String)Utils.bucketNameCodec.encode(bucket));
        GetBucketRequest req = opts.getBucketsRequest().apply(builder).build();
        GrpcCallContext merge = Utils.merge(grpcCallContext, Retrying.newCallContext());
        return Retrying.run(this.getOptions(), this.retryAlgorithmManager.getFor(req), () -> this.storageClient.getBucketCallable().call(req, merge), this.syntaxDecoders.bucket.andThen(opts.clearBucketFields()));
    }

    private final class SyntaxDecoders {
        final Conversions.Decoder<com.google.storage.v2.Object, Blob> blob = o -> ((BlobInfo)GrpcStorageImpl.this.codecs.blobInfo().decode(o)).asBlob(GrpcStorageImpl.this);
        final Conversions.Decoder<com.google.storage.v2.Bucket, Bucket> bucket = b -> ((BucketInfo)GrpcStorageImpl.this.codecs.bucketInfo().decode(b)).asBucket(GrpcStorageImpl.this);
        final Conversions.Decoder<NotificationConfig, Notification> notificationConfig = n -> ((NotificationInfo)GrpcStorageImpl.this.codecs.notificationInfo().decode(n)).asNotification(GrpcStorageImpl.this);

        private SyntaxDecoders() {
        }
    }

    static final class TransformingPageDecorator<RequestT, ResponseT, ResourceT, PageT extends AbstractPage<RequestT, ResponseT, ResourceT, PageT>, ModelT>
    implements Page<ModelT> {
        private final PageT page;
        private final Conversions.Decoder<ResourceT, ModelT> translator;
        private final Retrying.RetryingDependencies deps;
        private final ResultRetryAlgorithm<?> resultRetryAlgorithm;

        TransformingPageDecorator(PageT page, Conversions.Decoder<ResourceT, ModelT> translator, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> resultRetryAlgorithm) {
            this.page = page;
            this.translator = translator;
            this.deps = deps;
            this.resultRetryAlgorithm = resultRetryAlgorithm;
        }

        @Override
        public boolean hasNextPage() {
            return ((AbstractPage)this.page).hasNextPage();
        }

        @Override
        public String getNextPageToken() {
            return ((AbstractPage)this.page).getNextPageToken();
        }

        @Override
        public Page<ModelT> getNextPage() {
            return new TransformingPageDecorator<RequestT, ResponseT, ResourceT, Page, ModelT>(((AbstractPage)this.page).getNextPage(), this.translator, this.deps, this.resultRetryAlgorithm);
        }

        @Override
        public Iterable<ModelT> iterateAll() {
            return () -> GrpcStorageImpl.streamIterate(this.page, p -> p != null && p.hasNextPage(), prev -> {
                Callable<AbstractPage> c = () -> prev.getNextPage();
                return (AbstractPage)Retrying.run(this.deps, this.resultRetryAlgorithm, c, Conversions.Decoder.identity());
            }).filter(Objects::nonNull).flatMap(p -> StreamSupport.stream(p.getValues().spliterator(), false)).map(this.translator::decode).iterator();
        }

        @Override
        public Iterable<ModelT> getValues() {
            return () -> StreamSupport.stream(((AbstractPage)this.page).getValues().spliterator(), false).map(this.translator::decode).iterator();
        }
    }

    private final class ListObjectsWithSyntheticDirectoriesPage
    implements Page<Blob> {
        private final GrpcCallContext ctx;
        private final ListObjectsRequest req;
        private final ListObjectsResponse resp;

        private ListObjectsWithSyntheticDirectoriesPage(GrpcCallContext ctx, ListObjectsRequest req, ListObjectsResponse resp) {
            this.ctx = ctx;
            this.req = req;
            this.resp = resp;
        }

        @Override
        public boolean hasNextPage() {
            return !this.resp.getNextPageToken().isEmpty();
        }

        @Override
        public String getNextPageToken() {
            return this.resp.getNextPageToken();
        }

        @Override
        public Page<Blob> getNextPage() {
            ListObjectsRequest nextPageReq = this.req.toBuilder().setPageToken(this.resp.getNextPageToken()).build();
            try {
                GrpcCallContext merge = Utils.merge(this.ctx, Retrying.newCallContext());
                ListObjectsResponse nextPageResp = (ListObjectsResponse)Retrying.run(GrpcStorageImpl.this.getOptions(), GrpcStorageImpl.this.retryAlgorithmManager.getFor(nextPageReq), () -> GrpcStorageImpl.this.storageClient.listObjectsCallable().call(nextPageReq, merge), Conversions.Decoder.identity());
                return new ListObjectsWithSyntheticDirectoriesPage(this.ctx, nextPageReq, nextPageResp);
            }
            catch (Exception e) {
                throw StorageException.coalesce(e);
            }
        }

        @Override
        public Iterable<Blob> iterateAll() {
            ListObjectsWithSyntheticDirectoriesPage curr = this;
            Predicate<Page> exhausted = p -> p != null && p.hasNextPage();
            return () -> GrpcStorageImpl.streamIterate(curr, exhausted, Page::getNextPage).filter(Objects::nonNull).flatMap(p -> StreamSupport.stream(p.getValues().spliterator(), false)).iterator();
        }

        @Override
        public Iterable<Blob> getValues() {
            return () -> {
                String bucketName = (String)Utils.bucketNameCodec.decode(this.req.getParent());
                Stream[] streamArray = new Stream[2];
                streamArray[0] = this.resp.getObjectsList().stream().map(GrpcStorageImpl.this.syntaxDecoders.blob::decode);
                streamArray[1] = this.resp.getPrefixesList().stream().map(prefix -> BlobInfo.newBuilder(bucketName, prefix).setSize(0L).setIsDirectory(true).build()).map(info -> info.asBlob(GrpcStorageImpl.this));
                return Streams.concat(streamArray).iterator();
            };
        }
    }
}

