/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java8.wordcount;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.examples.java.wordcount.util.WordCountData;

public class WordCount {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!WordCount.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> text = WordCount.getTextDataSet(env);
        AggregateOperator counts = text.map((MapFunction & Serializable)line -> line.toLowerCase().split("\\W+")).flatMap((FlatMapFunction & Serializable)(tokens, out) -> Arrays.stream(tokens).filter(t -> t.length() > 0).forEach(t -> out.collect((Object)new Tuple2(t, (Object)1)))).groupBy(new int[]{0}).sum(1);
        if (fileOutput) {
            counts.writeAsCsv(outputPath, "\n", " ");
        } else {
            counts.print();
        }
        env.execute("WordCount Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WordCount example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: WordCount <text path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            textPath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: WordCount <text path> <result path>");
        return false;
    }

    private static DataSet<String> getTextDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return WordCountData.getDefaultTextLineDataSet(env);
    }
}

