/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.CheckpointBoundKeyedStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public interface IncrementalKeyedStateHandle
extends KeyedStateHandle,
CheckpointBoundKeyedStateHandle {
    @Nonnull
    public UUID getBackendIdentifier();

    @Nonnull
    public List<HandleAndLocalPath> getSharedStateHandles();

    public static final class HandleAndLocalPath
    implements Serializable {
        private static final long serialVersionUID = 7711754687567545052L;
        StreamStateHandle handle;
        final String localPath;

        public static HandleAndLocalPath of(StreamStateHandle handle, String localPath) {
            Preconditions.checkNotNull((Object)handle, (String)"streamStateHandle cannot be null");
            Preconditions.checkNotNull((Object)localPath, (String)"localPath cannot be null");
            return new HandleAndLocalPath(handle, localPath);
        }

        private HandleAndLocalPath(StreamStateHandle handle, String localPath) {
            this.handle = handle;
            this.localPath = localPath;
        }

        public StreamStateHandle getHandle() {
            return this.handle;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public long getStateSize() {
            return this.handle.getStateSize();
        }

        public void replaceHandle(StreamStateHandle registryReturned) {
            Preconditions.checkNotNull((Object)registryReturned);
            this.handle = registryReturned;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HandleAndLocalPath)) {
                return false;
            }
            HandleAndLocalPath that = (HandleAndLocalPath)o;
            return this.handle.equals(that.handle) && this.localPath.equals(that.localPath);
        }

        public int hashCode() {
            return Objects.hash(this.handle, this.localPath);
        }
    }
}

