/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManagerTestBase;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceDeclaration;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotAllocationException;
import org.apache.flink.runtime.testutils.SystemExitTrackingSecurityManager;
import org.apache.flink.util.function.FunctionUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class AbstractFineGrainedSlotManagerITCase
extends FineGrainedSlotManagerTestBase {
    AbstractFineGrainedSlotManagerITCase() {
    }

    @Test
    void testRequirementDeclarationWithoutFreeSlotsTriggersWorkerAllocation() throws Exception {
        final ResourceRequirements resourceRequirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        final CompletableFuture allocateResourceFuture = new CompletableFuture();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(resourceDeclarations -> {
                    Assertions.assertThat((Collection)resourceDeclarations).hasSize(1);
                    ResourceDeclaration resourceDeclaration = (ResourceDeclaration)resourceDeclarations.iterator().next();
                    allocateResourceFuture.complete(resourceDeclaration.getSpec());
                });
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(resourceRequirements));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocateResourceFuture);
                });
            }
        };
    }

    @Test
    void testRequirementDeclarationWithFreeResource() throws Exception {
        this.testRequirementDeclaration(RequirementDeclarationScenario.TASK_EXECUTOR_REGISTRATION_BEFORE_REQUIREMENT_DECLARATION);
    }

    @Test
    void testRequirementDeclarationWithPendingResource() throws Exception {
        this.testRequirementDeclaration(RequirementDeclarationScenario.TASK_EXECUTOR_REGISTRATION_AFTER_REQUIREMENT_DECLARATION);
    }

    private void testRequirementDeclaration(final RequirementDeclarationScenario scenario) throws Exception {
        ResourceID resourceID = ResourceID.generate();
        final JobID jobId = new JobID();
        final SlotID slotId = SlotID.getDynamicSlotID((ResourceID)resourceID);
        String targetAddress = "localhost";
        final ResourceRequirements requirements = ResourceRequirements.create((JobID)jobId, (String)"localhost", Collections.singleton(ResourceRequirement.create((ResourceProfile)DEFAULT_SLOT_RESOURCE_PROFILE, (int)1)));
        final CompletableFuture requestFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            requestFuture.complete(tuple6);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        final TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.runTest(() -> {
                    if (scenario == RequirementDeclarationScenario.TASK_EXECUTOR_REGISTRATION_BEFORE_REQUIREMENT_DECLARATION) {
                        this.runInMainThread(() -> this.getSlotManager().registerTaskManager(taskExecutorConnection, new SlotReport(), FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE));
                    }
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(requirements));
                    if (scenario == RequirementDeclarationScenario.TASK_EXECUTOR_REGISTRATION_AFTER_REQUIREMENT_DECLARATION) {
                        this.runInMainThread(() -> this.getSlotManager().registerTaskManager(taskExecutorConnection, new SlotReport(), FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE));
                    }
                    Assertions.assertThat(FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(requestFuture)).isEqualTo((Object)Tuple6.of((Object)slotId, (Object)jobId, (Object)((Tuple6)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(requestFuture2)).f2, (Object)FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE, (Object)"localhost", (Object)this.getResourceManagerId()));
                    TaskManagerSlotInformation slot = (TaskManagerSlotInformation)this.getTaskManagerTracker().getAllocatedOrPendingSlot((AllocationID)((Tuple6)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(requestFuture2)).f2).get();
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Comparable)((Tuple6)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(requestFuture2)).f2)).as("The slot has not been allocated to the expected allocation id.", new Object[0])).isEqualTo((Object)slot.getAllocationId());
                });
            }
        };
    }

    @Test
    void testRequirementDeclarationWithBlockedSlotsTriggersWorkerAllocation() throws Exception {
        final ResourceRequirements resourceRequirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        final CompletableFuture allocateResourceFuture = new CompletableFuture();
        final ResourceID blockedTaskManager = ResourceID.generate();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(blockedTaskManager, (TaskExecutorGateway)taskExecutorGateway);
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.setBlockedTaskManagerChecker(arg_0 -> ((ResourceID)blockedTaskManager).equals(arg_0));
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(resourceDeclarations -> {
                    Assertions.assertThat((Collection)resourceDeclarations).hasSize(1);
                    ResourceDeclaration resourceDeclaration = (ResourceDeclaration)resourceDeclarations.iterator().next();
                    allocateResourceFuture.complete(resourceDeclaration.getSpec());
                });
                this.runTest(() -> {
                    this.runInMainThread(() -> {
                        this.getSlotManager().registerTaskManager(taskManagerConnection, new SlotReport(), FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                        this.getSlotManager().processResourceRequirements(resourceRequirements);
                    });
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocateResourceFuture);
                });
            }
        };
    }

    @Test
    void testDuplicateResourceRequirementDeclarationAfterSuccessfulAllocation() throws Exception {
        final AtomicInteger requestCount = new AtomicInteger(0);
        final ArrayList allocateResourceFutures = new ArrayList();
        allocateResourceFutures.add(new CompletableFuture());
        allocateResourceFutures.add(new CompletableFuture());
        final ResourceRequirements requirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(resourceDeclarations -> {
                    if (!resourceDeclarations.isEmpty()) {
                        Assertions.assertThat((int)requestCount.get()).isLessThan(2);
                        ((CompletableFuture)allocateResourceFutures.get(requestCount.getAndIncrement())).complete(null);
                    }
                });
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(requirements));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn((CompletableFuture)allocateResourceFutures.get(0));
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(requirements));
                    FineGrainedSlotManagerTestBase.assertFutureNotComplete((CompletableFuture)allocateResourceFutures.get(1));
                });
            }
        };
    }

    @Test
    void testResourceCanBeAllocatedForDifferentJobWithDeclarationBeforeSlotFree() throws Exception {
        this.testResourceCanBeAllocatedForDifferentJobAfterFree(SecondRequirementDeclarationTime.BEFORE_FREE);
    }

    @Test
    void testResourceCanBeAllocatedForDifferentJobWithDeclarationAfterSlotFree() throws Exception {
        this.testResourceCanBeAllocatedForDifferentJobAfterFree(SecondRequirementDeclarationTime.AFTER_FREE);
    }

    private void testResourceCanBeAllocatedForDifferentJobAfterFree(final SecondRequirementDeclarationTime secondRequirementDeclarationTime) throws Exception {
        final CompletableFuture allocationIdFuture1 = new CompletableFuture();
        final CompletableFuture allocationIdFuture2 = new CompletableFuture();
        final ResourceRequirements resourceRequirements1 = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        final ResourceRequirements resourceRequirements2 = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            if (!allocationIdFuture1.isDone()) {
                allocationIdFuture1.complete(tuple6.f2);
            } else {
                allocationIdFuture2.complete(tuple6.f2);
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        final ResourceID resourceID = ResourceID.generate();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.runTest(() -> {
                    this.runInMainThread(() -> {
                        this.getSlotManager().registerTaskManager(taskManagerConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                        this.getSlotManager().processResourceRequirements(resourceRequirements1);
                    });
                    AllocationID allocationId1 = (AllocationID)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocationIdFuture1);
                    TaskManagerSlotInformation slot = (TaskManagerSlotInformation)this.getTaskManagerTracker().getAllocatedOrPendingSlot(allocationId1).get();
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)resourceRequirements1.getJobId()).as("The slot has not been allocated to the expected job id.", new Object[0])).isEqualTo((Object)slot.getJobId());
                    if (secondRequirementDeclarationTime == SecondRequirementDeclarationTime.BEFORE_FREE) {
                        this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(resourceRequirements2));
                    }
                    this.runInMainThread(() -> {
                        this.getSlotManager().processResourceRequirements(ResourceRequirements.create((JobID)resourceRequirements1.getJobId(), (String)resourceRequirements1.getTargetAddress(), Collections.emptyList()));
                        this.getSlotManager().freeSlot(SlotID.getDynamicSlotID((ResourceID)resourceID), allocationId1);
                    });
                    if (secondRequirementDeclarationTime == SecondRequirementDeclarationTime.AFTER_FREE) {
                        this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(resourceRequirements2));
                    }
                    slot = (TaskManagerSlotInformation)this.getTaskManagerTracker().getAllocatedOrPendingSlot((AllocationID)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocationIdFuture2)).get();
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)resourceRequirements2.getJobId()).as("The slot has not been allocated to the expected job id.", new Object[0])).isEqualTo((Object)slot.getJobId());
                });
            }
        };
    }

    @Test
    void testRegisterPendingResourceAfterClearingRequirement() throws Exception {
        final CompletableFuture allocationIdFuture = new CompletableFuture();
        final CompletableFuture allocateResourceFutures = new CompletableFuture();
        final CompletableFuture registerFuture = new CompletableFuture();
        final ResourceRequirements resourceRequirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            allocationIdFuture.complete(tuple6.f2);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        ResourceID resourceID = ResourceID.generate();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(ignored -> allocateResourceFutures.complete(null));
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(resourceRequirements));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocateResourceFutures);
                    this.runInMainThread(() -> {
                        this.getSlotManager().clearResourceRequirements(resourceRequirements.getJobId());
                        this.getSlotManager().registerTaskManager(taskManagerConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                        registerFuture.complete(null);
                    });
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(registerFuture);
                    FineGrainedSlotManagerTestBase.assertFutureNotComplete(allocationIdFuture);
                    Assertions.assertThat((Collection)this.getTaskManagerTracker().getPendingTaskManagers()).isEmpty();
                });
            }
        };
    }

    @Test
    void testRegisterPendingResourceAfterEmptyResourceRequirement() throws Exception {
        final CompletableFuture allocationIdFuture = new CompletableFuture();
        final CompletableFuture allocateResourceFutures = new CompletableFuture();
        final CompletableFuture registerFuture = new CompletableFuture();
        final ResourceRequirements resourceRequirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            allocationIdFuture.complete(tuple6.f2);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        ResourceID resourceID = ResourceID.generate();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(ignored -> allocateResourceFutures.complete(null));
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(resourceRequirements));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocateResourceFutures);
                    this.runInMainThread(() -> {
                        this.getSlotManager().processResourceRequirements(ResourceRequirements.empty((JobID)resourceRequirements.getJobId(), (String)resourceRequirements.getTargetAddress()));
                        this.getSlotManager().registerTaskManager(taskManagerConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                        registerFuture.complete(null);
                    });
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(registerFuture);
                    FineGrainedSlotManagerTestBase.assertFutureNotComplete(allocationIdFuture);
                    Assertions.assertThat((Collection)this.getTaskManagerTracker().getPendingTaskManagers()).isEmpty();
                });
            }
        };
    }

    @Test
    void testRequestNewResources() throws Exception {
        final JobID jobId = new JobID();
        final AtomicInteger requestCount = new AtomicInteger(0);
        final ArrayList allocateResourceFutures = new ArrayList();
        allocateResourceFutures.add(new CompletableFuture());
        allocateResourceFutures.add(new CompletableFuture());
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(resourceDeclarations -> {
                    if (!resourceDeclarations.isEmpty()) {
                        Assertions.assertThat((int)requestCount.get()).isLessThan(2);
                        ((CompletableFuture)allocateResourceFutures.get(requestCount.getAndIncrement())).complete(null);
                    }
                });
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(jobId, 2)));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn((CompletableFuture)allocateResourceFutures.get(0));
                    FineGrainedSlotManagerTestBase.assertFutureNotComplete((CompletableFuture)allocateResourceFutures.get(1));
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(jobId, 3)));
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn((CompletableFuture)allocateResourceFutures.get(1));
                });
            }
        };
    }

    @Test
    void testSlotRequestFailure() throws Exception {
        final JobID jobId = new JobID();
        final ResourceRequirements resourceRequirements = AbstractFineGrainedSlotManagerITCase.createResourceRequirementsForSingleSlot(jobId);
        final CompletableFuture slotRequestFuture1 = new CompletableFuture();
        CompletableFuture<Acknowledge> slotRequestFuture2 = CompletableFuture.completedFuture(Acknowledge.get());
        Iterator<CompletableFuture> slotRequestFutureIterator = Arrays.asList(slotRequestFuture1, slotRequestFuture2).iterator();
        final ArrayBlockingQueue allocationIds = new ArrayBlockingQueue(2);
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(FunctionUtils.uncheckedFunction(requestSlotParameters -> {
            allocationIds.put(requestSlotParameters.f2);
            return (CompletableFuture)slotRequestFutureIterator.next();
        })).createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.runTest(() -> {
                    this.runInMainThread(() -> {
                        this.getSlotManager().registerTaskManager(taskManagerConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                        this.getSlotManager().processResourceRequirements(resourceRequirements);
                    });
                    AllocationID firstAllocationId = (AllocationID)allocationIds.take();
                    Assertions.assertThat((Collection)allocationIds).isEmpty();
                    this.runInMainThread(() -> slotRequestFuture1.completeExceptionally((Throwable)new SlotAllocationException("Test exception.")));
                    AllocationID secondAllocationId = (AllocationID)allocationIds.take();
                    Assertions.assertThat((Collection)allocationIds).isEmpty();
                    TaskManagerSlotInformation slot = (TaskManagerSlotInformation)this.getTaskManagerTracker().getAllocatedOrPendingSlot(secondAllocationId).get();
                    Assertions.assertThat((Comparable)slot.getJobId()).isEqualTo((Object)jobId);
                    Assertions.assertThat((Optional)this.getTaskManagerTracker().getAllocatedOrPendingSlot(firstAllocationId)).isNotPresent();
                });
            }
        };
    }

    @Test
    void testAllocationUpdatesIgnoredIfTaskExecutorUnregistered() throws Exception {
        final CompletableFuture slotRequestFuture = new CompletableFuture();
        final CompletableFuture slotRequestCallFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(ignored -> {
            slotRequestCallFuture.complete(null);
            return slotRequestFuture;
        }).createTestingTaskExecutorGateway();
        final SystemExitTrackingSecurityManager trackingSecurityManager = new SystemExitTrackingSecurityManager();
        System.setSecurityManager(trackingSecurityManager);
        final JobID jobId = new JobID();
        ResourceID taskExecutorResourceId = ResourceID.generate();
        final TaskExecutorConnection taskExecutionConnection = new TaskExecutorConnection(taskExecutorResourceId, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.runTest(() -> {
                    this.runInMainThread(() -> {
                        this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(jobId, 1));
                        this.getSlotManager().registerTaskManager(taskExecutionConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                    });
                    FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(slotRequestCallFuture);
                    this.runInMainThread(() -> {
                        this.getSlotManager().unregisterTaskManager(taskExecutionConnection.getInstanceID(), (Exception)FineGrainedSlotManagerTestBase.TEST_EXCEPTION);
                        slotRequestFuture.complete(Acknowledge.get());
                    });
                    Assertions.assertThat(trackingSecurityManager.getSystemExitFuture()).isNotDone();
                });
            }
        };
        System.setSecurityManager(null);
    }

    @Test
    void testAllocationUpdatesIgnoredIfSlotMarkedAsAllocatedAfterSlotReport() throws Exception {
        final CompletableFuture allocationIdFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            allocationIdFuture.complete(tuple6.f2);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        final SystemExitTrackingSecurityManager trackingSecurityManager = new SystemExitTrackingSecurityManager();
        System.setSecurityManager(trackingSecurityManager);
        final TaskExecutorConnection taskExecutionConnection = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                this.runTest(() -> {
                    this.runInMainThread(() -> {
                        this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(new JobID(), 1));
                        this.getSlotManager().registerTaskManager(taskExecutionConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                    });
                    AllocationID allocationId = (AllocationID)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(allocationIdFuture);
                    this.runInMainThread(() -> this.getSlotManager().reportSlotStatus(taskExecutionConnection.getInstanceID(), new SlotReport(FineGrainedSlotManagerTestBase.createAllocatedSlotStatus(allocationId, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE))));
                    Assertions.assertThat(trackingSecurityManager.getSystemExitFuture()).isNotDone();
                });
            }
        };
        System.setSecurityManager(null);
    }

    private static enum SecondRequirementDeclarationTime {
        BEFORE_FREE,
        AFTER_FREE;

    }

    private static enum RequirementDeclarationScenario {
        TASK_EXECUTOR_REGISTRATION_BEFORE_REQUIREMENT_DECLARATION,
        TASK_EXECUTOR_REGISTRATION_AFTER_REQUIREMENT_DECLARATION;

    }
}

