/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;

public class TestingBufferAccumulator
implements BufferAccumulator {
    private BiConsumer<TieredStorageSubpartitionId, List<Buffer>> bufferFlusher;

    public void setup(BiConsumer<TieredStorageSubpartitionId, List<Buffer>> bufferFlusher) {
        this.bufferFlusher = bufferFlusher;
    }

    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        MemorySegment recordData = MemorySegmentFactory.wrap((byte[])record.array());
        this.bufferFlusher.accept(subpartitionId, Collections.singletonList(new NetworkBuffer(recordData, FreeingBufferRecycler.INSTANCE, dataType, recordData.size())));
    }

    public void close() {
    }
}

