/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class BloomFilterTest {
    private static BloomFilter bloomFilter;
    private static BloomFilter bloomFilter2;
    private static final int INPUT_SIZE = 1024;
    private static final double FALSE_POSITIVE_PROBABILITY = 0.05;

    @BeforeAll
    public static void init() {
        int bitsSize = BloomFilter.optimalNumOfBits((long)1024L, (double)0.05);
        bitsSize += 64 - bitsSize % 64;
        int byteSize = bitsSize >>> 3;
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)byteSize);
        bloomFilter = new BloomFilter(1024, byteSize);
        bloomFilter.setBitsLocation(memorySegment, 0);
        MemorySegment memorySegment2 = MemorySegmentFactory.allocateUnpooledSegment((int)byteSize);
        bloomFilter2 = new BloomFilter(1024, byteSize);
        bloomFilter2.setBitsLocation(memorySegment2, 0);
    }

    @Test
    public void testBloomFilterArguments1() {
        Assertions.assertThatThrownBy(() -> new BloomFilter(-1, 128)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBloomFilterArguments2() {
        Assertions.assertThatThrownBy(() -> new BloomFilter(0, 128)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBloomFilterArguments3() {
        Assertions.assertThatThrownBy(() -> new BloomFilter(1024, -1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBloomFilterArguments4() {
        Assertions.assertThatThrownBy(() -> new BloomFilter(1024, 0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBloomNumBits() {
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)0L, (double)0.0)).isEqualTo(0);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)0L, (double)0.0)).isEqualTo(0);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)0L, (double)1.0)).isEqualTo(0);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1L, (double)1.0)).isEqualTo(0);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1L, (double)0.03)).isEqualTo(7);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)10L, (double)0.03)).isEqualTo(72);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)100L, (double)0.03)).isEqualTo(729);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000L, (double)0.03)).isEqualTo(7298);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)10000L, (double)0.03)).isEqualTo(72984);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)100000L, (double)0.03)).isEqualTo(729844);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.03)).isEqualTo(7298440);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.05)).isEqualTo(6235224);
    }

    @Test
    public void testBloomFilterNumHashFunctions() {
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)-1L, (long)-1L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)0L, (long)0L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)0L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)10L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)100L)).isEqualTo(7);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)100L, (long)100L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)1000L, (long)100L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)10000L, (long)100L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)100000L, (long)100L)).isEqualTo(1);
        Assertions.assertThat((int)BloomFilter.optimalNumOfHashFunctions((long)1000000L, (long)100L)).isEqualTo(1);
    }

    @Test
    public void testBloomFilterFalsePositiveProbability() {
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.03)).isEqualTo(7298440);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.05)).isEqualTo(6235224);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.1)).isEqualTo(4792529);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.2)).isEqualTo(3349834);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.3)).isEqualTo(2505911);
        Assertions.assertThat((int)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.4)).isEqualTo(1907139);
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)7298440) - 0.03) < 0.01 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)6235224) - 0.05) < 0.01 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)4792529) - 0.1) < 0.01 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)3349834) - 0.2) < 0.01 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)2505911) - 0.3) < 0.01 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)1907139) - 0.4) < 0.01 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testHashcodeInput() {
        bloomFilter.reset();
        int val1 = "val1".hashCode();
        int val2 = "val2".hashCode();
        int val3 = "val3".hashCode();
        int val4 = "val4".hashCode();
        int val5 = "val5".hashCode();
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val1);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val2);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val3);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val4);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val5);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isTrue();
    }

    @Test
    public void testBloomFilterSerDe() {
        bloomFilter.reset();
        int val1 = "val1".hashCode();
        int val2 = "val2".hashCode();
        int val3 = "val3".hashCode();
        int val4 = "val4".hashCode();
        int val5 = "val5".hashCode();
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        bloomFilter.addHash(val1);
        bloomFilter.addHash(val2);
        bloomFilter.addHash(val3);
        bloomFilter.addHash(val4);
        bloomFilter.addHash(val5);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isTrue();
        byte[] serBytes = BloomFilter.toBytes((BloomFilter)bloomFilter);
        BloomFilter deBloomFilter = BloomFilter.fromBytes((byte[])serBytes);
        Assertions.assertThat((boolean)deBloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)deBloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)deBloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)deBloomFilter.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)deBloomFilter.testHash(val5)).isTrue();
    }

    @Test
    public void testSerializedBloomFilterMerge() {
        bloomFilter.reset();
        bloomFilter2.reset();
        int val1 = "val1".hashCode();
        int val2 = "val2".hashCode();
        int val3 = "val3".hashCode();
        int val4 = "val4".hashCode();
        int val5 = "val5".hashCode();
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val1)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val5)).isFalse();
        bloomFilter.addHash(val1);
        bloomFilter.addHash(val2);
        bloomFilter2.addHash(val3);
        bloomFilter2.addHash(val4);
        bloomFilter2.addHash(val5);
        Assertions.assertThat((boolean)bloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)bloomFilter.testHash(val3)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val4)).isFalse();
        Assertions.assertThat((boolean)bloomFilter.testHash(val5)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val1)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val2)).isFalse();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)bloomFilter2.testHash(val5)).isTrue();
        byte[] bytes = BloomFilter.toBytes((BloomFilter)bloomFilter);
        byte[] bytes2 = BloomFilter.toBytes((BloomFilter)bloomFilter2);
        byte[] mergedBytes = BloomFilter.mergeSerializedBloomFilters((byte[])bytes, (byte[])bytes2);
        BloomFilter mergedBloomFilter = BloomFilter.fromBytes((byte[])mergedBytes);
        Assertions.assertThat((boolean)mergedBloomFilter.testHash(val1)).isTrue();
        Assertions.assertThat((boolean)mergedBloomFilter.testHash(val2)).isTrue();
        Assertions.assertThat((boolean)mergedBloomFilter.testHash(val3)).isTrue();
        Assertions.assertThat((boolean)mergedBloomFilter.testHash(val4)).isTrue();
        Assertions.assertThat((boolean)mergedBloomFilter.testHash(val5)).isTrue();
    }
}

