/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.scheduler.exceptionhistory.ArchivedTaskManagerLocationMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ExceptionHistoryEntryMatcher
extends TypeSafeDiagnosingMatcher<ExceptionHistoryEntry> {
    private final Throwable expectedException;
    private final long expectedTimestamp;
    private final Map<String, String> expectedFailureLabels;
    private final String expectedTaskName;
    private final ArchivedTaskManagerLocationMatcher taskManagerLocationMatcher;

    public static Matcher<ExceptionHistoryEntry> matchesGlobalFailure(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels) {
        return ExceptionHistoryEntryMatcher.matchesFailure(expectedException, expectedTimestamp, expectedFailureLabels, null, null);
    }

    public static Matcher<ExceptionHistoryEntry> matchesFailure(Throwable expectedException, long expectedTimestamp, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        return new ExceptionHistoryEntryMatcher(expectedException, expectedTimestamp, Collections.emptyMap(), expectedTaskName, expectedTaskManagerLocation);
    }

    public static Matcher<ExceptionHistoryEntry> matchesFailure(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        return new ExceptionHistoryEntryMatcher(expectedException, expectedTimestamp, expectedFailureLabels, expectedTaskName, expectedTaskManagerLocation);
    }

    public ExceptionHistoryEntryMatcher(Throwable expectedException, long expectedTimestamp, Map<String, String> expectedFailureLabels, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        this.expectedException = expectedException;
        this.expectedTimestamp = expectedTimestamp;
        this.expectedFailureLabels = expectedFailureLabels;
        this.expectedTaskName = expectedTaskName;
        this.taskManagerLocationMatcher = new ArchivedTaskManagerLocationMatcher(expectedTaskManagerLocation);
    }

    protected boolean matchesSafely(ExceptionHistoryEntry exceptionHistoryEntry, Description description) {
        boolean match = true;
        if (!exceptionHistoryEntry.getException().deserializeError(ClassLoader.getSystemClassLoader()).equals(this.expectedException)) {
            description.appendText(" actualException=").appendText(ExceptionUtils.stringifyException((Throwable)exceptionHistoryEntry.getException().deserializeError(ClassLoader.getSystemClassLoader())));
            match = false;
        }
        if (exceptionHistoryEntry.getTimestamp() != this.expectedTimestamp) {
            description.appendText(" actualTimestamp=").appendText(String.valueOf(exceptionHistoryEntry.getTimestamp()));
            match = false;
        }
        if (!exceptionHistoryEntry.getFailureLabelsFuture().equals(this.expectedFailureLabels)) {
            description.appendText(" actualFailureLabels=").appendText(String.valueOf(exceptionHistoryEntry.getFailureLabelsFuture()));
            match = false;
        }
        if (exceptionHistoryEntry.getFailingTaskName() == null) {
            if (this.expectedTaskName != null) {
                description.appendText(" actualTaskName=null");
                match = false;
            }
        } else if (exceptionHistoryEntry.getFailingTaskName().equals(this.expectedTaskName)) {
            description.appendText(" actualTaskName=").appendText(exceptionHistoryEntry.getFailingTaskName());
            match = false;
        }
        return match |= this.taskManagerLocationMatcher.matchesSafely(exceptionHistoryEntry.getTaskManagerLocation(), description);
    }

    public void describeTo(Description description) {
        description.appendText("expectedException=").appendText(ExceptionUtils.stringifyException((Throwable)this.expectedException)).appendText(" expectedTimestamp=").appendText(String.valueOf(this.expectedTimestamp)).appendText(" expectedFailureLabels=").appendText(String.valueOf(this.expectedFailureLabels)).appendText(" expectedTaskName=").appendText(this.expectedTaskName).appendText(" expectedTaskManagerLocation=");
        this.taskManagerLocationMatcher.describeTo(description);
    }
}

