/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ResourceCounterTest
extends TestLogger {
    private ResourceProfile resourceProfile1 = ResourceProfile.newBuilder().setManagedMemoryMB(42).build();
    private ResourceProfile resourceProfile2 = ResourceProfile.newBuilder().setCpuCores(1.7).build();

    @Test
    public void testIsEmpty() {
        ResourceCounter empty = ResourceCounter.empty();
        Assert.assertTrue((boolean)empty.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithResourceRejectsNegativeCount() {
        ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)-1);
    }

    @Test
    public void testWithResourceCreatesEmptyCounterIfCountIsZero() {
        ResourceCounter empty = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)0);
        Assert.assertTrue((boolean)empty.isEmpty());
    }

    @Test
    public void testIsNonEmpty() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)1);
        Assert.assertFalse((boolean)resourceCounter.isEmpty());
        Assert.assertTrue((boolean)resourceCounter.containsResource(ResourceProfile.UNKNOWN));
    }

    @Test
    public void testGetResourceCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        for (Map.Entry<ResourceProfile, Integer> resource : resources.entrySet()) {
            Assert.assertThat((Object)resourceCounter.getResourceCount(resource.getKey()), (Matcher)CoreMatchers.is((Object)resource.getValue()));
        }
    }

    @Test
    public void testGetResourceCountReturnsZeroForUnknownResourceProfile() {
        ResourceCounter resourceCounter = ResourceCounter.withResources(this.createResources());
        Assert.assertThat((Object)resourceCounter.getResourceCount(ResourceProfile.newBuilder().build()), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testGetTotalResourceCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assert.assertThat((Object)resourceCounter.getTotalResourceCount(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testGetResources() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assert.assertThat((Object)resourceCounter.getResources(), (Matcher)Matchers.containsInAnyOrder((Object[])resources.keySet().toArray()));
    }

    @Test
    public void testGetResourceWithCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assert.assertThat((Object)resourceCounter.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])resources.entrySet().toArray()));
    }

    @Test
    public void testAddSameResourceProfile() {
        boolean value1 = true;
        int value2 = 42;
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)42);
        ResourceCounter result = resourceCounter1.add(resourceCounter2);
        Assert.assertThat((Object)resourceCounter1.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 1).entrySet().toArray()));
        Assert.assertThat((Object)resourceCounter2.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 42).entrySet().toArray()));
        Assert.assertThat((Object)result.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 43).entrySet().toArray()));
    }

    @Test
    public void testAddDifferentResourceProfile() {
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile2, (int)1);
        ResourceCounter result = resourceCounter1.add(resourceCounter2);
        ArrayList expectedResult = new ArrayList(resourceCounter1.getResourcesWithCount());
        expectedResult.addAll(resourceCounter2.getResourcesWithCount());
        Assert.assertThat((Object)result.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedResult.toArray()));
    }

    @Test
    public void testCountEqualToZeroRemovesResource() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)2);
        ResourceCounter result = resourceCounter.subtract(this.resourceProfile1, 2);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCountBelowZeroRemovesResources() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter result = resourceCounter.subtract(this.resourceProfile1, 2);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testSubtractSameResourceProfile() {
        int value1 = 5;
        int value2 = 3;
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)5);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)3);
        ResourceCounter result = resourceCounter1.subtract(resourceCounter2);
        Assert.assertThat((Object)resourceCounter1.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 5).entrySet().toArray()));
        Assert.assertThat((Object)resourceCounter2.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 3).entrySet().toArray()));
        Assert.assertThat((Object)result.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])Collections.singletonMap(ResourceProfile.UNKNOWN, 2).entrySet().toArray()));
    }

    @Test
    public void testSubtractDifferentResourceProfile() {
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile2, (int)1);
        ResourceCounter result = resourceCounter1.subtract(resourceCounter2);
        Assert.assertThat((Object)result.getResourcesWithCount(), (Matcher)Matchers.containsInAnyOrder((Object[])resourceCounter1.getResourcesWithCount().toArray()));
    }

    private Map<ResourceProfile, Integer> createResources() {
        return ImmutableMap.of((Object)this.resourceProfile1, (Object)2, (Object)this.resourceProfile2, (Object)3);
    }
}

