/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobCacheRetriesTest {
    @TempDir
    private Path tempDir;

    BlobCacheRetriesTest() {
    }

    @Test
    void testBlobFetchRetries() throws IOException {
        this.testBlobFetchRetries((BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobForJobFetchRetries() throws IOException {
        this.testBlobFetchRetries((BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobFetchRetriesHa() throws IOException {
        Configuration config = new Configuration();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            this.testBlobFetchRetries((BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.cleanupAllData();
                blobStoreService.close();
            }
        }
    }

    private void testBlobFetchRetries(BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createFailingServerAndCache(this.tempDir, blobStore, 1, 2);
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data);
        }
    }

    @Test
    void testBlobNoJobFetchWithTooManyFailures() throws IOException {
        this.testBlobFetchWithTooManyFailures((BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobForJobFetchWithTooManyFailures() throws IOException {
        this.testBlobFetchWithTooManyFailures((BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testBlobForJobFetchWithTooManyFailuresHa() throws IOException {
        Configuration config = new Configuration();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)this.tempDir.toString());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            this.testBlobFetchWithTooManyFailures((BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.cleanupAllData();
                blobStoreService.close();
            }
        }
    }

    private void testBlobFetchWithTooManyFailures(BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createFailingServerAndCache(this.tempDir, blobStore, 0, 10);
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            Assertions.assertThatThrownBy(() -> BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data)).isInstanceOf(IOException.class);
        }
    }
}

