/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubtaskStateStatsTest {
    SubtaskStateStatsTest() {
    }

    @Test
    void testSimpleAccess() throws Exception {
        this.test(false);
    }

    @Test
    void testIsJavaSerializable() throws Exception {
        this.test(true);
    }

    public void test(boolean serialize) throws Exception {
        SubtaskStateStats stats = new SubtaskStateStats(0, 0x80000000L, 0x80000001L, 0x80000001L, 0x80000002L, 0x80000003L, 0x80000007L, 0x80000008L, 0x80000005L, 0x80000006L, false, true);
        stats = serialize ? (SubtaskStateStats)CommonTestUtils.createCopySerializable((Serializable)stats) : stats;
        Assertions.assertThat((int)stats.getSubtaskIndex()).isZero();
        Assertions.assertThat((long)stats.getAckTimestamp()).isEqualTo(0x80000000L);
        Assertions.assertThat((long)stats.getStateSize()).isEqualTo(0x80000001L);
        Assertions.assertThat((long)stats.getSyncCheckpointDuration()).isEqualTo(0x80000002L);
        Assertions.assertThat((long)stats.getAsyncCheckpointDuration()).isEqualTo(0x80000003L);
        Assertions.assertThat((long)stats.getAlignmentDuration()).isEqualTo(0x80000005L);
        Assertions.assertThat((long)stats.getCheckpointStartDelay()).isEqualTo(0x80000006L);
        long ackTimestamp = stats.getAckTimestamp();
        long triggerTimestamp = ackTimestamp - 10123L;
        Assertions.assertThat((long)stats.getEndToEndDuration(triggerTimestamp)).isEqualTo(10123L);
        Assertions.assertThat((long)stats.getEndToEndDuration(ackTimestamp + 1L)).isZero();
    }
}

