/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummarySnapshot;
import org.apache.flink.runtime.checkpoint.StatsSummarySnapshot;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismInfo;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismStore;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ArchivedExecutionGraphTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    private static ExecutionGraph runtimeGraph;

    @BeforeAll
    static void setupExecutionGraph() throws Exception {
        JobVertexID v1ID = new JobVertexID();
        JobVertexID v2ID = new JobVertexID();
        JobVertex v1 = new JobVertex("v1", v1ID);
        JobVertex v2 = new JobVertex("v2", v2ID);
        v1.setParallelism(1);
        v2.setParallelism(2);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        ExecutionConfig config = new ExecutionConfig();
        config.setRestartStrategy((RestartStrategies.RestartStrategyConfiguration)new RestartStrategies.NoRestartStrategyConfiguration());
        config.setParallelism(4);
        config.enableObjectReuse();
        config.setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)new TestJobParameters());
        CheckpointCoordinatorConfiguration chkConfig = new CheckpointCoordinatorConfiguration(100L, 100L, 100L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, 0, 0L);
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(chkConfig, null);
        JobGraph jobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertices(Arrays.asList(v1, v2)).setJobCheckpointingSettings(checkpointingSettings).setExecutionConfig(config).build();
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(jobGraph, ComponentMainThreadExecutorServiceAdapter.forMainThread(), (ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        runtimeGraph = scheduler.getExecutionGraph();
        scheduler.startScheduling();
        scheduler.updateTaskExecutionState(new TaskExecutionState(((ExecutionVertex)runtimeGraph.getAllExecutionVertices().iterator().next()).getCurrentExecutionAttempt().getAttemptId(), ExecutionState.FAILED, (Throwable)new RuntimeException("Local failure")));
    }

    @Test
    void testArchive() throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createFrom((ExecutionGraph)runtimeGraph);
        ArchivedExecutionGraphTest.compareExecutionGraph((AccessExecutionGraph)runtimeGraph, (AccessExecutionGraph)archivedGraph);
    }

    @Test
    void testSerialization() throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createFrom((ExecutionGraph)runtimeGraph);
        ArchivedExecutionGraphTest.verifySerializability(archivedGraph);
    }

    @Test
    void testCreateFromInitializingJobForSuspendedJob() {
        ArchivedExecutionGraph suspendedExecutionGraph = ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)new JobID(), (String)"TestJob", (JobStatus)JobStatus.SUSPENDED, (Throwable)new Exception("Test suspension exception"), null, (long)System.currentTimeMillis());
        Assertions.assertThat((Comparable)suspendedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED);
        Assertions.assertThat((Object)suspendedExecutionGraph.getFailureInfo()).isNotNull();
    }

    @Test
    void testCheckpointSettingsArchiving() {
        CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration = CheckpointCoordinatorConfiguration.builder().build();
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)new JobID(), (String)"TestJob", (JobStatus)JobStatus.INITIALIZING, null, (JobCheckpointingSettings)new JobCheckpointingSettings(checkpointCoordinatorConfiguration, null), (long)System.currentTimeMillis());
        ArchivedExecutionGraphTest.assertContainsCheckpointSettings(archivedGraph);
    }

    public static void assertContainsCheckpointSettings(ArchivedExecutionGraph archivedGraph) {
        Assertions.assertThat((Object)archivedGraph.getCheckpointCoordinatorConfiguration()).isNotNull();
        Assertions.assertThat((Object)archivedGraph.getCheckpointStatsSnapshot()).isNotNull();
        Assertions.assertThat((String)((String)archivedGraph.getCheckpointStorageName().get())).isEqualTo("Unknown");
        Assertions.assertThat((String)((String)archivedGraph.getStateBackendName().get())).isEqualTo("Unknown");
    }

    @Test
    void testArchiveSparseWithVertices() {
        JobVertex jobVertex = new JobVertex("op");
        jobVertex.setParallelism(1);
        int storedParallelism = 4;
        int storedMaxParallelism = 8;
        DefaultVertexParallelismStore initialParallelismStore = new DefaultVertexParallelismStore();
        initialParallelismStore.setParallelismInfo(jobVertex.getID(), (VertexParallelismInformation)new DefaultVertexParallelismInfo(4, 8, ignored -> Optional.empty()));
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createSparseArchivedExecutionGraphWithJobVertices((JobID)new JobID(), (String)"TestJob", (JobStatus)JobStatus.INITIALIZING, null, null, (long)System.currentTimeMillis(), Arrays.asList(jobVertex), (VertexParallelismStore)initialParallelismStore);
        ArchivedExecutionJobVertex archivedVertex = archivedGraph.getJobVertex(jobVertex.getID());
        Assertions.assertThat((Object)archivedVertex).isNotNull();
        Assertions.assertThat((Iterable)archivedGraph.getVerticesTopologically()).containsExactly((Object[])new ArchivedExecutionJobVertex[]{archivedVertex});
        Assertions.assertThat((int)archivedVertex.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)archivedVertex.getMaxParallelism()).isEqualTo(8);
        Assertions.assertThat((String)archivedVertex.getName()).isEqualTo(jobVertex.getName());
        Assertions.assertThat((Object[])archivedVertex.getAggregatedUserAccumulatorsStringified()).hasSize(0);
        Assertions.assertThat((Object[])archivedVertex.getTaskVertices()).hasSize(0);
        Assertions.assertThat((Comparable)archivedVertex.getAggregateState()).isSameAs((Object)ExecutionState.CREATED);
    }

    @Test
    void testArchiveWithStatusOverride() throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createFrom((ExecutionGraph)runtimeGraph, (JobStatus)JobStatus.RESTARTING);
        Assertions.assertThat((Comparable)archivedGraph.getState()).isEqualTo((Object)JobStatus.RESTARTING);
        Assertions.assertThat((long)archivedGraph.getStatusTimestamp(JobStatus.FAILED)).isEqualTo(0L);
    }

    private static void compareExecutionGraph(AccessExecutionGraph runtimeGraph, AccessExecutionGraph archivedGraph) throws IOException, ClassNotFoundException {
        Assertions.assertThat((String)runtimeGraph.getJsonPlan()).isEqualTo(archivedGraph.getJsonPlan());
        Assertions.assertThat((Comparable)runtimeGraph.getJobID()).isEqualTo((Object)archivedGraph.getJobID());
        Assertions.assertThat((String)runtimeGraph.getJobName()).isEqualTo(archivedGraph.getJobName());
        Assertions.assertThat((Comparable)runtimeGraph.getState()).isEqualTo((Object)archivedGraph.getState());
        Assertions.assertThat((String)runtimeGraph.getFailureInfo().getExceptionAsString()).isEqualTo(archivedGraph.getFailureInfo().getExceptionAsString());
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.CREATED)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.CREATED));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.RUNNING)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.RUNNING));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.FAILING)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.FAILING));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.FAILED)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.FAILED));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.CANCELLING)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.CANCELLING));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.CANCELED)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.CANCELED));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.FINISHED)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.FINISHED));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.RESTARTING)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.RESTARTING));
        Assertions.assertThat((long)runtimeGraph.getStatusTimestamp(JobStatus.SUSPENDED)).isEqualTo(archivedGraph.getStatusTimestamp(JobStatus.SUSPENDED));
        Assertions.assertThat((boolean)runtimeGraph.isStoppable()).isEqualTo(archivedGraph.isStoppable());
        CheckpointStatsSnapshot runtimeSnapshot = runtimeGraph.getCheckpointStatsSnapshot();
        CheckpointStatsSnapshot archivedSnapshot = archivedGraph.getCheckpointStatsSnapshot();
        List<Function> meters = Arrays.asList(CompletedCheckpointStatsSummarySnapshot::getEndToEndDurationStats, CompletedCheckpointStatsSummarySnapshot::getPersistedDataStats, CompletedCheckpointStatsSummarySnapshot::getProcessedDataStats, CompletedCheckpointStatsSummarySnapshot::getStateSizeStats);
        List<Function> aggs = Arrays.asList(StatsSummarySnapshot::getAverage, StatsSummarySnapshot::getMinimum, StatsSummarySnapshot::getMaximum, StatsSummarySnapshot::getSum, StatsSummarySnapshot::getCount, s -> s.getQuantile(0.5), s -> s.getQuantile(0.9), s -> s.getQuantile(0.95), s -> s.getQuantile(0.99), s -> s.getQuantile(0.999));
        for (Function meter : meters) {
            StatsSummarySnapshot runtime = (StatsSummarySnapshot)meter.apply(runtimeSnapshot.getSummaryStats());
            StatsSummarySnapshot archived = (StatsSummarySnapshot)meter.apply(runtimeSnapshot.getSummaryStats());
            for (Function function : aggs) {
                Assertions.assertThat(function.apply(runtime)).isEqualTo(function.apply(archived));
            }
        }
        Assertions.assertThat((long)runtimeSnapshot.getCounts().getTotalNumberOfCheckpoints()).isEqualTo(archivedSnapshot.getCounts().getTotalNumberOfCheckpoints());
        Assertions.assertThat((long)runtimeSnapshot.getCounts().getNumberOfCompletedCheckpoints()).isEqualTo(archivedSnapshot.getCounts().getNumberOfCompletedCheckpoints());
        Assertions.assertThat((int)runtimeSnapshot.getCounts().getNumberOfInProgressCheckpoints()).isEqualTo(archivedSnapshot.getCounts().getNumberOfInProgressCheckpoints());
        ArchivedExecutionConfig runtimeConfig = runtimeGraph.getArchivedExecutionConfig();
        ArchivedExecutionConfig archivedConfig = archivedGraph.getArchivedExecutionConfig();
        Assertions.assertThat((String)runtimeConfig.getExecutionMode()).isEqualTo(archivedConfig.getExecutionMode());
        Assertions.assertThat((int)runtimeConfig.getParallelism()).isEqualTo(archivedConfig.getParallelism());
        Assertions.assertThat((boolean)runtimeConfig.getObjectReuseEnabled()).isEqualTo(archivedConfig.getObjectReuseEnabled());
        Assertions.assertThat((String)runtimeConfig.getRestartStrategyDescription()).isEqualTo(archivedConfig.getRestartStrategyDescription());
        Assertions.assertThat((String)((String)archivedConfig.getGlobalJobParameters().get("hello"))).isNotNull();
        Assertions.assertThat((String)((String)runtimeConfig.getGlobalJobParameters().get("hello"))).isEqualTo((String)archivedConfig.getGlobalJobParameters().get("hello"));
        ArchivedExecutionGraphTestUtils.compareStringifiedAccumulators(runtimeGraph.getAccumulatorResultsStringified(), archivedGraph.getAccumulatorResultsStringified());
        ArchivedExecutionGraphTestUtils.compareSerializedAccumulators(runtimeGraph.getAccumulatorsSerialized(), archivedGraph.getAccumulatorsSerialized());
        Map runtimeVertices = runtimeGraph.getAllVertices();
        Map archivedVertices = archivedGraph.getAllVertices();
        for (Map.Entry entry : runtimeVertices.entrySet()) {
            ArchivedExecutionGraphTest.compareExecutionJobVertex((AccessExecutionJobVertex)entry.getValue(), (AccessExecutionJobVertex)archivedVertices.get(entry.getKey()));
        }
        Iterator runtimeTopologicalVertices = runtimeGraph.getVerticesTopologically().iterator();
        Iterator iterator = archivedGraph.getVerticesTopologically().iterator();
        while (runtimeTopologicalVertices.hasNext()) {
            Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
            ArchivedExecutionGraphTest.compareExecutionJobVertex((AccessExecutionJobVertex)runtimeTopologicalVertices.next(), (AccessExecutionJobVertex)iterator.next());
        }
        Iterator runtimeExecutionVertices = runtimeGraph.getAllExecutionVertices().iterator();
        Iterator archivedExecutionVertices = archivedGraph.getAllExecutionVertices().iterator();
        while (runtimeExecutionVertices.hasNext()) {
            Assertions.assertThat((boolean)archivedExecutionVertices.hasNext()).isTrue();
            ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)runtimeExecutionVertices.next(), (AccessExecutionVertex)archivedExecutionVertices.next());
        }
    }

    private static void compareExecutionJobVertex(AccessExecutionJobVertex runtimeJobVertex, AccessExecutionJobVertex archivedJobVertex) {
        Assertions.assertThat((String)runtimeJobVertex.getName()).isEqualTo(archivedJobVertex.getName());
        Assertions.assertThat((int)runtimeJobVertex.getParallelism()).isEqualTo(archivedJobVertex.getParallelism());
        Assertions.assertThat((int)runtimeJobVertex.getMaxParallelism()).isEqualTo(archivedJobVertex.getMaxParallelism());
        Assertions.assertThat((Comparable)runtimeJobVertex.getJobVertexId()).isEqualTo((Object)archivedJobVertex.getJobVertexId());
        Assertions.assertThat((Comparable)runtimeJobVertex.getAggregateState()).isEqualTo((Object)archivedJobVertex.getAggregateState());
        ArchivedExecutionGraphTestUtils.compareStringifiedAccumulators(runtimeJobVertex.getAggregatedUserAccumulatorsStringified(), archivedJobVertex.getAggregatedUserAccumulatorsStringified());
        AccessExecutionVertex[] runtimeExecutionVertices = runtimeJobVertex.getTaskVertices();
        AccessExecutionVertex[] archivedExecutionVertices = archivedJobVertex.getTaskVertices();
        Assertions.assertThat((int)runtimeExecutionVertices.length).isEqualTo(archivedExecutionVertices.length);
        for (int x = 0; x < runtimeExecutionVertices.length; ++x) {
            ArchivedExecutionGraphTestUtils.compareExecutionVertex(runtimeExecutionVertices[x], archivedExecutionVertices[x]);
        }
    }

    private static void verifySerializability(ArchivedExecutionGraph graph) throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph copy = (ArchivedExecutionGraph)CommonTestUtils.createCopySerializable((Serializable)graph);
        ArchivedExecutionGraphTest.compareExecutionGraph((AccessExecutionGraph)graph, (AccessExecutionGraph)copy);
    }

    private static class TestJobParameters
    extends ExecutionConfig.GlobalJobParameters {
        private static final long serialVersionUID = -8118611781035212808L;
        private Map<String, String> parameters = new HashMap<String, String>();

        private TestJobParameters() {
            this.parameters.put("hello", "world");
        }

        public Map<String, String> toMap() {
            return this.parameters;
        }
    }
}

