/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;

public class TestingTierFactory
implements TierFactory {
    private final Supplier<TierMasterAgent> tierMasterAgentSupplier;
    private final Supplier<TierProducerAgent> tierProducerAgentSupplier;
    private final BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier;

    private TestingTierFactory(Supplier<TierMasterAgent> tierMasterAgentSupplier, Supplier<TierProducerAgent> tierProducerAgentSupplier, BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier) {
        this.tierMasterAgentSupplier = tierMasterAgentSupplier;
        this.tierProducerAgentSupplier = tierProducerAgentSupplier;
        this.tierConsumerAgentSupplier = tierConsumerAgentSupplier;
    }

    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry tieredStorageResourceRegistry) {
        return this.tierMasterAgentSupplier.get();
    }

    public TierProducerAgent createProducerAgent(int numSubpartitions, TieredStoragePartitionId partitionID, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, int maxRequestedBuffers, Duration bufferRequestTimeout) {
        return this.tierProducerAgentSupplier.get();
    }

    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, TieredStorageNettyService nettyService) {
        return this.tierConsumerAgentSupplier.apply(tieredStorageConsumerSpecs, nettyService);
    }

    public static class Builder {
        private Supplier<TierMasterAgent> tierMasterAgentSupplier = () -> null;
        private Supplier<TierProducerAgent> tierProducerAgentSupplier = () -> null;
        private BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier = (partitionIdAndSubpartitionId, nettyService) -> null;

        public Builder setTierMasterAgentSupplier(Supplier<TierMasterAgent> tierMasterAgentSupplier) {
            this.tierMasterAgentSupplier = tierMasterAgentSupplier;
            return this;
        }

        public Builder setTierProducerAgentSupplier(Supplier<TierProducerAgent> tierProducerAgentSupplier) {
            this.tierProducerAgentSupplier = tierProducerAgentSupplier;
            return this;
        }

        public Builder setTierConsumerAgentSupplier(BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier) {
            this.tierConsumerAgentSupplier = tierConsumerAgentSupplier;
            return this;
        }

        public TestingTierFactory build() {
            return new TestingTierFactory(this.tierMasterAgentSupplier, this.tierProducerAgentSupplier, this.tierConsumerAgentSupplier);
        }
    }
}

