/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DeclarativeSlotPoolBridgePreferredAllocationsTest {
    DeclarativeSlotPoolBridgePreferredAllocationsTest() {
    }

    @Test
    void testDeclarativeSlotPoolTakesPreferredAllocationsIntoAccount() throws Exception {
        DeclarativeSlotPoolBridge declarativeSlotPoolBridge = new DeclarativeSlotPoolBridge(new JobID(), (DeclarativeSlotPoolFactory)new DefaultDeclarativeSlotPoolFactory(), (Clock)SystemClock.getInstance(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), (RequestSlotMatchingStrategy)PreferredAllocationRequestSlotMatchingStrategy.INSTANCE);
        declarativeSlotPoolBridge.start(JobMasterId.generate(), "localhost", ComponentMainThreadExecutorServiceAdapter.forMainThread());
        LocalTaskManagerLocation localTaskManagerLocation = new LocalTaskManagerLocation();
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        CompletableFuture<PhysicalSlot> slotRequestWithPreferredAllocation1 = this.requestSlot(declarativeSlotPoolBridge, Collections.singleton(allocationId1));
        CompletableFuture<PhysicalSlot> slotRequestWithEmptyPreferredAllocations = this.requestSlot(declarativeSlotPoolBridge, Collections.emptySet());
        CompletableFuture<PhysicalSlot> slotRequestWithPreferredAllocation2 = this.requestSlot(declarativeSlotPoolBridge, Collections.singleton(allocationId2));
        ArrayList<SlotOffer> slotOffers = new ArrayList<SlotOffer>();
        slotOffers.add(new SlotOffer(allocationId2, 0, ResourceProfile.ANY));
        AllocationID otherAllocationId = new AllocationID();
        slotOffers.add(new SlotOffer(otherAllocationId, 1, ResourceProfile.ANY));
        slotOffers.add(new SlotOffer(allocationId1, 2, ResourceProfile.ANY));
        declarativeSlotPoolBridge.registerTaskManager(localTaskManagerLocation.getResourceID());
        declarativeSlotPoolBridge.offerSlots((TaskManagerLocation)localTaskManagerLocation, (TaskManagerGateway)new SimpleAckingTaskManagerGateway(), slotOffers);
        Assertions.assertThat((Comparable)slotRequestWithPreferredAllocation1.join().getAllocationId()).isEqualTo((Object)allocationId1);
        Assertions.assertThat((Comparable)slotRequestWithPreferredAllocation2.join().getAllocationId()).isEqualTo((Object)allocationId2);
        Assertions.assertThat((Comparable)slotRequestWithEmptyPreferredAllocations.join().getAllocationId()).isEqualTo((Object)otherAllocationId);
    }

    @Nonnull
    private CompletableFuture<PhysicalSlot> requestSlot(DeclarativeSlotPoolBridge declarativeSlotPoolBridge, Set<AllocationID> preferredAllocations) {
        return declarativeSlotPoolBridge.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, preferredAllocations, null);
    }
}

