/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricDumpTest {
    MetricDumpTest() {
    }

    @Test
    void testDumpedCounter() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.CounterDump cd = new MetricDump.CounterDump((QueryScopeInfo)info, "counter", 4L);
        Assertions.assertThat((String)cd.name).isEqualTo("counter");
        Assertions.assertThat((long)cd.count).isEqualTo(4L);
        Assertions.assertThat((Object)cd.scopeInfo).isEqualTo((Object)info);
        Assertions.assertThat((byte)cd.getCategory()).isEqualTo((byte)0);
    }

    @Test
    void testDumpedGauge() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.GaugeDump gd = new MetricDump.GaugeDump((QueryScopeInfo)info, "gauge", "hello");
        Assertions.assertThat((String)gd.name).isEqualTo("gauge");
        Assertions.assertThat((String)gd.value).isEqualTo("hello");
        Assertions.assertThat((Object)gd.scopeInfo).isEqualTo((Object)info);
        Assertions.assertThat((byte)gd.getCategory()).isEqualTo((byte)1);
    }

    @Test
    void testDumpedHistogram() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.HistogramDump hd = new MetricDump.HistogramDump((QueryScopeInfo)info, "hist", 1L, 2L, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0);
        Assertions.assertThat((String)hd.name).isEqualTo("hist");
        Assertions.assertThat((long)hd.min).isOne();
        Assertions.assertThat((long)hd.max).isEqualTo(2L);
        Assertions.assertThat((double)hd.mean).isCloseTo(3.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.median).isCloseTo(4.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.stddev).isCloseTo(5.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p75).isCloseTo(6.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p90).isCloseTo(7.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p95).isCloseTo(8.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p98).isCloseTo(9.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p99).isCloseTo(10.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)hd.p999).isCloseTo(11.0, Assertions.within((Double)0.1));
        Assertions.assertThat((Object)hd.scopeInfo).isEqualTo((Object)info);
        Assertions.assertThat((byte)hd.getCategory()).isEqualTo((byte)2);
    }

    @Test
    void testDumpedMeter() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.MeterDump md = new MetricDump.MeterDump((QueryScopeInfo)info, "meter", 5.0);
        Assertions.assertThat((String)md.name).isEqualTo("meter");
        Assertions.assertThat((double)md.rate).isCloseTo(5.0, Assertions.within((Double)0.1));
        Assertions.assertThat((Object)md.scopeInfo).isEqualTo((Object)info);
        Assertions.assertThat((byte)md.getCategory()).isEqualTo((byte)3);
    }
}

