/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotManagerUtilsTest {
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    SlotManagerUtilsTest() {
    }

    @Test
    void testGenerateDefaultSlotProfileFromWorkerResourceSpec() {
        int numSlots = 5;
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec workerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(5.0).setTaskHeapMemoryMB(5).setTaskOffHeapMemoryMB(10).setNetworkMemoryMB(15).setManagedMemoryMB(20).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 5.0)).build();
        Assertions.assertThat((Object)SlotManagerUtils.generateDefaultSlotResourceProfile((WorkerResourceSpec)workerResourceSpec, (int)5)).isEqualTo((Object)resourceProfile);
    }

    @Test
    void testGenerateDefaultSlotProfileFromTotalResourceProfile() {
        int numSlots = 5;
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        ResourceProfile totalResourceProfile = ResourceProfile.newBuilder().setCpuCores(5.0).setTaskHeapMemoryMB(5).setTaskOffHeapMemoryMB(10).setNetworkMemoryMB(15).setManagedMemoryMB(20).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 5.0)).build();
        Assertions.assertThat((Object)SlotManagerUtils.generateDefaultSlotResourceProfile((ResourceProfile)totalResourceProfile, (int)5)).isEqualTo((Object)resourceProfile);
    }

    @Test
    void testGenerateDefaultSlotConsistentWithTaskExecutorResourceUtils() {
        int numSlots = 5;
        TaskExecutorResourceSpec taskExecutorResourceSpec = new TaskExecutorResourceSpec(new CPUResource(1.0), MemorySize.parse((String)"1m"), MemorySize.parse((String)"2m"), MemorySize.parse((String)"3m"), MemorySize.parse((String)"4m"), Collections.singleton(new ExternalResource(EXTERNAL_RESOURCE_NAME, 5.0)));
        ResourceProfile resourceProfileFromTaskExecutorResourceUtils = TaskExecutorResourceUtils.generateDefaultSlotResourceProfile((TaskExecutorResourceSpec)taskExecutorResourceSpec, (int)5);
        ResourceProfile totalResourceProfile = TaskExecutorResourceUtils.generateTotalAvailableResourceProfile((TaskExecutorResourceSpec)taskExecutorResourceSpec);
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTotalResourceProfile((ResourceProfile)totalResourceProfile, (int)5);
        Assertions.assertThat((Object)SlotManagerUtils.generateDefaultSlotResourceProfile((ResourceProfile)totalResourceProfile, (int)5)).isEqualTo((Object)resourceProfileFromTaskExecutorResourceUtils);
        Assertions.assertThat((Object)SlotManagerUtils.generateDefaultSlotResourceProfile((WorkerResourceSpec)workerResourceSpec, (int)5)).isEqualTo((Object)resourceProfileFromTaskExecutorResourceUtils);
    }

    @Test
    void testCalculateDefaultNumSlots() {
        ResourceProfile defaultSlotResource = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).build();
        ResourceProfile totalResource1 = defaultSlotResource.multiply(5);
        ResourceProfile totalResource2 = totalResource1.merge(ResourceProfile.newBuilder().setCpuCores(0.1).build());
        Assertions.assertThat((int)SlotManagerUtils.calculateDefaultNumSlots((ResourceProfile)totalResource1, (ResourceProfile)defaultSlotResource)).isEqualTo(5);
        Assertions.assertThat((int)SlotManagerUtils.calculateDefaultNumSlots((ResourceProfile)totalResource2, (ResourceProfile)defaultSlotResource)).isEqualTo(5);
        Assertions.assertThat((int)SlotManagerUtils.calculateDefaultNumSlots((ResourceProfile)ResourceProfile.ANY, (ResourceProfile)defaultSlotResource)).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    void testCalculateDefaultNumSlotsFailZeroDefaultSlotProfile() {
        Assertions.assertThatThrownBy(() -> SlotManagerUtils.calculateDefaultNumSlots((ResourceProfile)ResourceProfile.fromResources((double)1.0, (int)1), (ResourceProfile)ResourceProfile.ZERO)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGetEffectiveResourceProfile() {
        ResourceProfile defaultProfile = ResourceProfile.fromResources((double)5.0, (int)10);
        ResourceProfile concreteRequirement = ResourceProfile.fromResources((double)1.0, (int)20);
        Assertions.assertThat((Object)SlotManagerUtils.getEffectiveResourceProfile((ResourceProfile)ResourceProfile.UNKNOWN, (ResourceProfile)defaultProfile)).isEqualTo((Object)defaultProfile);
        Assertions.assertThat((Object)SlotManagerUtils.getEffectiveResourceProfile((ResourceProfile)concreteRequirement, (ResourceProfile)defaultProfile)).isEqualTo((Object)concreteRequirement);
    }

    @Test
    void testGenerateTaskManagerTotalResourceProfile() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec workerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((Object)SlotManagerUtils.generateTaskManagerTotalResourceProfile((WorkerResourceSpec)workerResourceSpec)).isEqualTo((Object)resourceProfile);
    }
}

