/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.taskmanager.TestUntypedMessageHeaders;
import org.apache.flink.runtime.rest.handler.taskmanager.TestingChannelHandlerContext;
import org.apache.flink.runtime.rest.handler.taskmanager.TestingTaskManagerFileHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerFileMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class AbstractTaskManagerFileHandlerTest {
    private static final ResourceID EXPECTED_TASK_MANAGER_ID = ResourceID.generate();
    private static final DefaultFullHttpRequest HTTP_REQUEST = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/foobar");
    @TempDir
    private static File temporaryFolder;
    private static BlobServer blobServer;
    private static HandlerRequest<EmptyRequestBody> handlerRequest;
    private String fileContent1;
    private TransientBlobKey transientBlobKey1;
    private String fileContent2;
    private TransientBlobKey transientBlobKey2;

    AbstractTaskManagerFileHandlerTest() {
    }

    @BeforeAll
    static void setup() throws IOException, HandlerRequestException {
        Configuration configuration = new Configuration();
        blobServer = new BlobServer(configuration, temporaryFolder, (BlobStore)new VoidBlobStore());
        handlerRequest = HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerFileMessageParameters(), Collections.singletonMap("taskmanagerid", EXPECTED_TASK_MANAGER_ID.getResourceIdString()), Collections.emptyMap(), Collections.emptyList());
    }

    @BeforeEach
    void setupTest() throws IOException {
        this.fileContent1 = UUID.randomUUID().toString();
        File file1 = AbstractTaskManagerFileHandlerTest.createFileWithContent(this.fileContent1);
        this.transientBlobKey1 = AbstractTaskManagerFileHandlerTest.storeFileInBlobServer(file1);
        this.fileContent2 = UUID.randomUUID().toString();
        File file2 = AbstractTaskManagerFileHandlerTest.createFileWithContent(this.fileContent2);
        this.transientBlobKey2 = AbstractTaskManagerFileHandlerTest.storeFileInBlobServer(file2);
    }

    @AfterAll
    static void teardown() throws IOException {
        if (blobServer != null) {
            blobServer.close();
            blobServer = null;
        }
    }

    @Test
    void testFileServing() throws Exception {
        Time cacheEntryDuration = Time.milliseconds((long)1000L);
        ArrayDeque<CompletableFuture<TransientBlobKey>> requestFileUploads = new ArrayDeque<CompletableFuture<TransientBlobKey>>(1);
        requestFileUploads.add(CompletableFuture.completedFuture(this.transientBlobKey1));
        TestingTaskManagerFileHandler testingTaskManagerFileHandler = this.createTestTaskManagerFileHandler(cacheEntryDuration, requestFileUploads, EXPECTED_TASK_MANAGER_ID);
        File outputFile = TempDirUtils.newFile((Path)temporaryFolder.toPath());
        TestingChannelHandlerContext testingContext = new TestingChannelHandlerContext(outputFile);
        testingTaskManagerFileHandler.respondToRequest(testingContext, (HttpRequest)HTTP_REQUEST, handlerRequest, null);
        Assertions.assertThat((File)outputFile).isNotEmpty();
        Assertions.assertThat((String)FileUtils.readFileUtf8((File)outputFile)).isEqualTo(this.fileContent1);
    }

    @Test
    void testFileCaching() throws Exception {
        File outputFile = this.runFileCachingTest(Time.milliseconds((long)5000L), Time.milliseconds((long)0L));
        Assertions.assertThat((File)outputFile).isNotEmpty();
        Assertions.assertThat((String)FileUtils.readFileUtf8((File)outputFile)).isEqualTo(this.fileContent1);
    }

    @Test
    void testFileCacheExpiration() throws Exception {
        Time cacheEntryDuration = Time.milliseconds((long)5L);
        File outputFile = this.runFileCachingTest(cacheEntryDuration, cacheEntryDuration);
        Assertions.assertThat((File)outputFile).isNotEmpty();
        Assertions.assertThat((String)FileUtils.readFileUtf8((File)outputFile)).isEqualTo(this.fileContent2);
    }

    private File runFileCachingTest(Time cacheEntryDuration, Time delayBetweenRequests) throws Exception {
        ArrayDeque<CompletableFuture<TransientBlobKey>> requestFileUploads = new ArrayDeque<CompletableFuture<TransientBlobKey>>(2);
        requestFileUploads.add(CompletableFuture.completedFuture(this.transientBlobKey1));
        requestFileUploads.add(CompletableFuture.completedFuture(this.transientBlobKey2));
        TestingTaskManagerFileHandler testingTaskManagerFileHandler = this.createTestTaskManagerFileHandler(cacheEntryDuration, requestFileUploads, EXPECTED_TASK_MANAGER_ID);
        File outputFile = TempDirUtils.newFile((Path)temporaryFolder.toPath());
        TestingChannelHandlerContext testingContext = new TestingChannelHandlerContext(outputFile);
        testingTaskManagerFileHandler.respondToRequest(testingContext, (HttpRequest)HTTP_REQUEST, handlerRequest, null);
        Thread.sleep(delayBetweenRequests.toMilliseconds());
        testingTaskManagerFileHandler.respondToRequest(testingContext, (HttpRequest)HTTP_REQUEST, handlerRequest, null);
        return outputFile;
    }

    private TestingTaskManagerFileHandler createTestTaskManagerFileHandler(Time cacheEntryDuration, Queue<CompletableFuture<TransientBlobKey>> requestFileUploads, ResourceID expectedTaskManagerId) {
        TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
        return new TestingTaskManagerFileHandler((GatewayRetriever<? extends RestfulGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(null)), TestingUtils.infiniteTime(), Collections.emptyMap(), new TestUntypedMessageHeaders(), (GatewayRetriever<ResourceManagerGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(resourceManagerGateway)), (TransientBlobService)blobServer, cacheEntryDuration, requestFileUploads, expectedTaskManagerId);
    }

    private static File createFileWithContent(String fileContent) throws IOException {
        File file = TempDirUtils.newFile((Path)temporaryFolder.toPath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(fileContent.getBytes("UTF-8"));
        }
        return file;
    }

    private static TransientBlobKey storeFileInBlobServer(File fileToStore) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(fileToStore);){
            TransientBlobKey transientBlobKey = blobServer.getTransientBlobService().putTransient((InputStream)fileInputStream);
            return transientBlobKey;
        }
    }
}

