/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.exceptions.RpcConnectionException;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RpcSSLAuthITCase {
    private static final String KEY_STORE_FILE = RpcSSLAuthITCase.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_FILE = RpcSSLAuthITCase.class.getResource("/local127.truststore").getFile();
    private static final String UNTRUSTED_KEY_STORE_FILE = RpcSSLAuthITCase.class.getResource("/untrusted.keystore").getFile();

    RpcSSLAuthITCase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConnectFailure() throws Exception {
        CompletableFuture<Object> completableFuture;
        Configuration baseConfig = new Configuration();
        baseConfig.set(RpcOptions.TCP_TIMEOUT, (Object)"1 s");
        baseConfig.set(RpcOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofSeconds(10000000L));
        Configuration sslConfig1 = new Configuration(baseConfig);
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_KEYSTORE, (Object)KEY_STORE_FILE);
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_TRUSTSTORE, (Object)TRUST_STORE_FILE);
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, (Object)"password");
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, (Object)"password");
        sslConfig1.set(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, (Object)"password");
        sslConfig1.set(SecurityOptions.SSL_ALGORITHMS, (Object)"TLS_RSA_WITH_AES_128_CBC_SHA");
        Configuration sslConfig2 = new Configuration(baseConfig);
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_KEYSTORE, (Object)UNTRUSTED_KEY_STORE_FILE);
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_TRUSTSTORE, (Object)TRUST_STORE_FILE);
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, (Object)"password");
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, (Object)"password");
        sslConfig2.set(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, (Object)"password");
        sslConfig2.set(SecurityOptions.SSL_ALGORITHMS, (Object)"TLS_RSA_WITH_AES_128_CBC_SHA");
        RpcService rpcService1 = null;
        RpcService rpcService2 = null;
        try {
            rpcService1 = RpcSystem.load().localServiceBuilder(sslConfig1).withBindAddress("localhost").withBindPort(0).createAndStart();
            rpcService2 = RpcSystem.load().localServiceBuilder(sslConfig2).withBindAddress("localhost").withBindPort(0).createAndStart();
            TestEndpoint endpoint = new TestEndpoint(rpcService1);
            endpoint.start();
            CompletableFuture future = rpcService2.connect(endpoint.getAddress(), TestGateway.class);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                TestGateway gateway = (TestGateway)future.get(10000000L, TimeUnit.SECONDS);
                CompletableFuture<String> fooFuture = gateway.foo();
                fooFuture.get();
            }).withFailMessage("should never complete normally", new Object[0])).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RpcConnectionException.class);
            completableFuture = rpcService1 != null ? rpcService1.closeAsync() : CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            CompletableFuture<Object> rpcTerminationFuture1 = rpcService1 != null ? rpcService1.closeAsync() : CompletableFuture.completedFuture(null);
            CompletableFuture<Object> rpcTerminationFuture2 = rpcService2 != null ? rpcService2.closeAsync() : CompletableFuture.completedFuture(null);
            FutureUtils.waitForAll(Arrays.asList(rpcTerminationFuture1, rpcTerminationFuture2)).get();
            throw throwable;
        }
        CompletableFuture<Object> rpcTerminationFuture1 = completableFuture;
        CompletableFuture<Object> rpcTerminationFuture2 = rpcService2 != null ? rpcService2.closeAsync() : CompletableFuture.completedFuture(null);
        FutureUtils.waitForAll(Arrays.asList(rpcTerminationFuture1, rpcTerminationFuture2)).get();
    }

    public static class TestEndpoint
    extends RpcEndpoint
    implements TestGateway {
        public TestEndpoint(RpcService rpcService) {
            super(rpcService);
        }

        @Override
        public CompletableFuture<String> foo() {
            return CompletableFuture.completedFuture("bar");
        }
    }

    public static interface TestGateway
    extends RpcGateway {
        public CompletableFuture<String> foo();
    }
}

