/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;

class TestJobInformation
implements JobInformation {
    private final Map<JobVertexID, JobInformation.VertexInformation> vertexIdToInformation;
    private final Collection<SlotSharingGroup> slotSharingGroups;

    TestJobInformation(Collection<? extends JobInformation.VertexInformation> vertexIdToInformation) {
        this.vertexIdToInformation = vertexIdToInformation.stream().collect(Collectors.toMap(JobInformation.VertexInformation::getJobVertexID, Function.identity()));
        this.slotSharingGroups = vertexIdToInformation.stream().map(JobInformation.VertexInformation::getSlotSharingGroup).collect(Collectors.toSet());
    }

    public Collection<SlotSharingGroup> getSlotSharingGroups() {
        return this.slotSharingGroups;
    }

    public JobInformation.VertexInformation getVertexInformation(JobVertexID jobVertexId) {
        return this.vertexIdToInformation.get(jobVertexId);
    }

    public Iterable<JobInformation.VertexInformation> getVertices() {
        return this.vertexIdToInformation.values();
    }
}

