/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobAllocationsInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.ReservedSlots;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.util.ResourceCounter;

public class TestingSlotAllocator
implements SlotAllocator {
    private final Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction;
    private final Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction;

    private TestingSlotAllocator(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction, Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction) {
        this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
        this.tryReserveResourcesFunction = tryReserveResourcesFunction;
    }

    public ResourceCounter calculateRequiredSlots(Iterable<JobInformation.VertexInformation> vertices) {
        return this.calculateRequiredSlotsFunction.apply(vertices);
    }

    public Optional<VertexParallelism> determineParallelism(JobInformation jobInformation, Collection<? extends SlotInfo> slots) {
        return Optional.empty();
    }

    public Optional<JobSchedulingPlan> determineParallelismAndCalculateAssignment(JobInformation jobInformation, Collection<? extends SlotInfo> slots, JobAllocationsInformation jobAllocationsInformation) {
        return Optional.empty();
    }

    public Optional<ReservedSlots> tryReserveResources(JobSchedulingPlan jobSchedulingPlan) {
        return this.tryReserveResourcesFunction.apply(jobSchedulingPlan.getVertexParallelism());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction = ignored -> ResourceCounter.empty();
        private Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction = ignored -> Optional.empty();

        public Builder setCalculateRequiredSlotsFunction(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction) {
            this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
            return this;
        }

        public Builder setTryReserveResourcesFunction(Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction) {
            this.tryReserveResourcesFunction = tryReserveResourcesFunction;
            return this;
        }

        public TestingSlotAllocator build() {
            return new TestingSlotAllocator(this.calculateRequiredSlotsFunction, this.tryReserveResourcesFunction);
        }
    }
}

