/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.throughput.BufferDebloatConfiguration;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BufferDebloatConfigurationTest
extends TestLogger {
    BufferDebloatConfigurationTest() {
    }

    @Test
    public void testMinGreaterThanMaxBufferSize() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MIN_MEMORY_SEGMENT_SIZE, (Object)new MemorySize(50L));
        config.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)new MemorySize(49L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BufferDebloatConfiguration.fromConfiguration((ReadableConfig)config));
    }

    @Test
    public void testNegativeConsumptionTime() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.BUFFER_DEBLOAT_TARGET, (Object)Duration.ofMillis(-1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BufferDebloatConfiguration.fromConfiguration((ReadableConfig)config));
    }
}

