/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.persistence.TestingLongStateHandleHelper;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.util.StateHandleStoreUtils;
import org.apache.flink.util.function.RunnableWithException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class StateHandleStoreUtilsTest {
    StateHandleStoreUtilsTest() {
    }

    @Test
    void testSerializationAndDeserialization() throws Exception {
        TestingLongStateHandleHelper.LongStateHandle original = new TestingLongStateHandleHelper.LongStateHandle(42L);
        byte[] serializedData = StateHandleStoreUtils.serializeOrDiscard((StateObject)original);
        TestingLongStateHandleHelper.LongStateHandle deserializedInstance = (TestingLongStateHandleHelper.LongStateHandle)((Object)StateHandleStoreUtils.deserialize((byte[])serializedData));
        Assertions.assertThat((long)deserializedInstance.getStateSize()).isEqualTo(original.getStateSize());
        Assertions.assertThat((long)deserializedInstance.getValue()).isEqualTo(original.getValue());
    }

    @Test
    void testSerializeOrDiscardFailureHandling() throws Exception {
        AtomicBoolean discardCalled = new AtomicBoolean(false);
        FailingSerializationStateObject original = new FailingSerializationStateObject(() -> discardCalled.set(true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StateHandleStoreUtils.serializeOrDiscard((StateObject)original)).withFailMessage("An IOException is expected to be thrown.", new Object[0])).isInstanceOf(IOException.class);
        Assertions.assertThat((AtomicBoolean)discardCalled).isTrue();
    }

    @Test
    void testSerializationOrDiscardWithDiscardFailure() throws Exception {
        IllegalStateException discardException = new IllegalStateException("Expected IllegalStateException that should be suppressed.");
        FailingSerializationStateObject original = new FailingSerializationStateObject(() -> {
            throw discardException;
        });
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StateHandleStoreUtils.serializeOrDiscard((StateObject)original)).withFailMessage("An IOException is expected to be thrown.", new Object[0])).isInstanceOf(IOException.class)).satisfies(new ThrowingConsumer[]{e -> {
            Assertions.assertThat((Object[])e.getSuppressed()).hasSize(1);
            Assertions.assertThat((Throwable)e.getSuppressed()[0]).isEqualTo((Object)discardException);
        }});
    }

    private static class FailingSerializationStateObject
    implements StateObject {
        private static final long serialVersionUID = 6382458109061973983L;
        private final RunnableWithException discardStateRunnable;

        public FailingSerializationStateObject(RunnableWithException discardStateRunnable) {
            this.discardStateRunnable = discardStateRunnable;
        }

        private void writeObject(ObjectOutputStream outputStream) throws IOException {
            throw new IOException("Expected IOException to test serialization error.");
        }

        public void discardState() throws Exception {
            this.discardStateRunnable.run();
        }

        public long getStateSize() {
            return 0L;
        }
    }
}

