/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.MockResultPartitionWriter;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public abstract class AbstractCollectingResultPartitionWriter
extends MockResultPartitionWriter {
    @Override
    public void emitRecord(ByteBuffer record, int targetSubpartition) throws IOException {
        Preconditions.checkArgument((targetSubpartition < this.getNumberOfSubpartitions() ? 1 : 0) != 0);
        this.deserializeRecord(record);
    }

    @Override
    public void broadcastRecord(ByteBuffer record) throws IOException {
        this.deserializeRecord(record);
    }

    private void deserializeRecord(ByteBuffer serializedRecord) throws IOException {
        Preconditions.checkArgument((boolean)serializedRecord.hasArray());
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])serializedRecord.array());
        NetworkBuffer buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE);
        buffer.setSize(serializedRecord.remaining());
        this.deserializeBuffer((Buffer)buffer);
    }

    protected abstract void deserializeBuffer(Buffer var1) throws IOException;
}

