/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsConsumerId;
import org.apache.flink.runtime.io.network.partition.hybrid.HsMemoryDataManagerOperation;
import org.apache.flink.util.function.SupplierWithException;

public class TestingMemoryDataManagerOperation
implements HsMemoryDataManagerOperation {
    private final SupplierWithException<BufferBuilder, InterruptedException> requestBufferFromPoolSupplier;
    private final BiConsumer<Integer, Integer> markBufferReadableConsumer;
    private final Consumer<BufferIndexAndChannel> onBufferConsumedConsumer;
    private final Runnable onBufferFinishedRunnable;
    private final Runnable onDataAvailableRunnable;
    private final BiConsumer<Integer, HsConsumerId> onConsumerReleasedBiConsumer;

    private TestingMemoryDataManagerOperation(SupplierWithException<BufferBuilder, InterruptedException> requestBufferFromPoolSupplier, BiConsumer<Integer, Integer> markBufferReadableConsumer, Consumer<BufferIndexAndChannel> onBufferConsumedConsumer, Runnable onBufferFinishedRunnable, Runnable onDataAvailableRunnable, BiConsumer<Integer, HsConsumerId> onConsumerReleasedBiConsumer) {
        this.requestBufferFromPoolSupplier = requestBufferFromPoolSupplier;
        this.markBufferReadableConsumer = markBufferReadableConsumer;
        this.onBufferConsumedConsumer = onBufferConsumedConsumer;
        this.onBufferFinishedRunnable = onBufferFinishedRunnable;
        this.onDataAvailableRunnable = onDataAvailableRunnable;
        this.onConsumerReleasedBiConsumer = onConsumerReleasedBiConsumer;
    }

    public BufferBuilder requestBufferFromPool() throws InterruptedException {
        return (BufferBuilder)this.requestBufferFromPoolSupplier.get();
    }

    public void markBufferReleasedFromFile(int subpartitionId, int bufferIndex) {
        this.markBufferReadableConsumer.accept(subpartitionId, bufferIndex);
    }

    public void onBufferConsumed(BufferIndexAndChannel consumedBuffer) {
        this.onBufferConsumedConsumer.accept(consumedBuffer);
    }

    public void onBufferFinished() {
        this.onBufferFinishedRunnable.run();
    }

    public void onDataAvailable(int subpartitionId, Collection<HsConsumerId> consumerIds) {
        this.onDataAvailableRunnable.run();
    }

    public void onConsumerReleased(int subpartitionId, HsConsumerId consumerId) {
        this.onConsumerReleasedBiConsumer.accept(subpartitionId, consumerId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SupplierWithException<BufferBuilder, InterruptedException> requestBufferFromPoolSupplier = () -> null;
        private BiConsumer<Integer, Integer> markBufferReadableConsumer = (ignore1, ignore2) -> {};
        private Consumer<BufferIndexAndChannel> onBufferConsumedConsumer = ignore1 -> {};
        private Runnable onBufferFinishedRunnable = () -> {};
        private Runnable onDataAvailableRunnable = () -> {};
        private BiConsumer<Integer, HsConsumerId> onConsumerReleasedBiConsumer = (ignore1, ignore2) -> {};

        public Builder setRequestBufferFromPoolSupplier(SupplierWithException<BufferBuilder, InterruptedException> requestBufferFromPoolSupplier) {
            this.requestBufferFromPoolSupplier = requestBufferFromPoolSupplier;
            return this;
        }

        public Builder setMarkBufferReadableConsumer(BiConsumer<Integer, Integer> markBufferReadableConsumer) {
            this.markBufferReadableConsumer = markBufferReadableConsumer;
            return this;
        }

        public Builder setOnBufferConsumedConsumer(Consumer<BufferIndexAndChannel> onBufferConsumedConsumer) {
            this.onBufferConsumedConsumer = onBufferConsumedConsumer;
            return this;
        }

        public Builder setOnBufferFinishedRunnable(Runnable onBufferFinishedRunnable) {
            this.onBufferFinishedRunnable = onBufferFinishedRunnable;
            return this;
        }

        public Builder setOnDataAvailableRunnable(Runnable onDataAvailableRunnable) {
            this.onDataAvailableRunnable = onDataAvailableRunnable;
            return this;
        }

        public Builder setOnConsumerReleasedBiConsumer(BiConsumer<Integer, HsConsumerId> onConsumerReleasedBiConsumer) {
            this.onConsumerReleasedBiConsumer = onConsumerReleasedBiConsumer;
            return this;
        }

        private Builder() {
        }

        public TestingMemoryDataManagerOperation build() {
            return new TestingMemoryDataManagerOperation(this.requestBufferFromPoolSupplier, this.markBufferReadableConsumer, this.onBufferConsumedConsumer, this.onBufferFinishedRunnable, this.onDataAvailableRunnable, this.onConsumerReleasedBiConsumer);
        }
    }
}

