/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DirectScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor();

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        command.run();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledService.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledService.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.scheduledService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.scheduledService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduledService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.scheduledService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledService.awaitTermination(timeout, unit);
    }
}

