/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.util.OptionalInt;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.throughput.BufferDebloater;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalIntAssert;
import org.junit.jupiter.api.Test;

class BufferDebloaterTest {
    BufferDebloaterTest() {
    }

    @Test
    void testZeroBuffersInUse() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 2400).withNumberOfBuffersInUse(0).withThroughput(1200L).expectBufferSize(1200);
    }

    @Test
    void testCorrectBufferSizeCalculation() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(249);
    }

    @Test
    void testCalculatedBufferSizeLessThanMin() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(250, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(250);
    }

    @Test
    void testCalculatedBufferSizeForThroughputZero() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(0L).expectBufferSize(50);
    }

    @Test
    void testConfiguredConsumptionTimeIsTooLow() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(7).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(50);
    }

    @Test
    void testCalculatedBufferSizeGreaterThanMax() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 248).withNumberOfBuffersInUse(16).withThroughput(3333L).expectNoChangeInBufferSize();
    }

    @Test
    void testCalculatedBufferSlightlyDifferentFromCurrentOne() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 250).withNumberOfBuffersInUse(16).withThroughput(3333L).expectNoChangeInBufferSize();
    }

    @Test
    void testAnnouncedMaxBufferSizeDespiteLastDiffLessThanThreshold() {
        boolean numberOfBuffersInUse = true;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 1100).withNumberOfBuffersInUse(1).withThroughput(500L).expectBufferSize(500);
        bufferDebloater.recalculateBufferSize(1000L, 1);
        Assertions.assertThat((int)bufferDebloater.getLastBufferSize()).isEqualTo(1000);
        bufferDebloater.recalculateBufferSize(2000L, 1);
        Assertions.assertThat((int)bufferDebloater.getLastBufferSize()).isEqualTo(1100);
        bufferDebloater.recalculateBufferSize(2000L, 1);
    }

    @Test
    void testAnnouncedMinBufferSizeEvenDespiteLastDiffLessThanThreshold() {
        boolean numberOfBuffersInUse = true;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 1100).withNumberOfBuffersInUse(1).withThroughput(60L).expectBufferSize(60);
        bufferDebloater.recalculateBufferSize(60L, 1);
        Assertions.assertThat((int)bufferDebloater.getLastBufferSize()).isEqualTo(60);
        bufferDebloater.recalculateBufferSize(40L, 1);
        Assertions.assertThat((int)bufferDebloater.getLastBufferSize()).isEqualTo(50);
        bufferDebloater.recalculateBufferSize(40L, 1);
    }

    @Test
    void testSkipUpdate() {
        int maxBufferSize = 32768;
        int minBufferSize = 256;
        double threshold = 0.3;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(minBufferSize, maxBufferSize).withThresholdPercentages((int)(threshold * 100.0)).getBufferDebloater();
        int currentBufferSize = maxBufferSize / 2;
        OptionalInt optionalInt = bufferDebloater.recalculateBufferSize((long)currentBufferSize, 1);
        ((OptionalIntAssert)Assertions.assertThat((OptionalInt)optionalInt).isPresent()).hasValue(currentBufferSize);
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize)).isTrue();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize - 1)).isTrue();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize + 1)).isTrue();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold) + 1)).isTrue();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold) - 1)).isTrue();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold))).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold))).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(minBufferSize + 1)).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(minBufferSize)).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(maxBufferSize - 1)).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(maxBufferSize)).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(maxBufferSize + 1)).isFalse();
        Assertions.assertThat((boolean)bufferDebloater.skipUpdate(minBufferSize - 1)).isFalse();
    }

    public static BufferDebloaterTestBuilder testBufferDebloater() {
        return new BufferDebloaterTestBuilder();
    }

    private static class BufferDebloaterTestBuilder {
        private int numberOfBuffersInUse;
        private long throughput;
        private int minBufferSize;
        private int maxBufferSize;
        private int debloatTarget;
        private int thresholdPercentages = (Integer)TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES.defaultValue();

        private BufferDebloaterTestBuilder() {
        }

        public BufferDebloaterTestBuilder withNumberOfBuffersInUse(Integer numberOfBuffersInUse) {
            this.numberOfBuffersInUse = numberOfBuffersInUse;
            return this;
        }

        public BufferDebloaterTestBuilder withThroughput(long throughput) {
            this.throughput = throughput;
            return this;
        }

        public BufferDebloaterTestBuilder withBufferSize(int minBufferSize, int maxBufferSize) {
            this.minBufferSize = minBufferSize;
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public BufferDebloaterTestBuilder withDebloatTarget(int debloatTarget) {
            this.debloatTarget = debloatTarget;
            return this;
        }

        public BufferDebloaterTestBuilder withThresholdPercentages(int thresholdPercentages) {
            this.thresholdPercentages = thresholdPercentages;
            return this;
        }

        public void expectNoChangeInBufferSize() {
            BufferDebloater bufferDebloater = this.getBufferDebloater();
            OptionalInt newBufferSize = bufferDebloater.recalculateBufferSize(this.throughput, this.numberOfBuffersInUse);
            Assertions.assertThat((OptionalInt)newBufferSize).isNotPresent();
        }

        public BufferDebloater expectBufferSize(int expectedBufferSize) {
            BufferDebloater bufferDebloater = this.getBufferDebloater();
            OptionalInt newBufferSize = bufferDebloater.recalculateBufferSize(this.throughput, this.numberOfBuffersInUse);
            ((OptionalIntAssert)Assertions.assertThat((OptionalInt)newBufferSize).isPresent()).hasValue(expectedBufferSize);
            return bufferDebloater;
        }

        private BufferDebloater getBufferDebloater() {
            return new BufferDebloater("Unknown task name in test", 0, (long)this.debloatTarget, this.maxBufferSize, this.minBufferSize, this.thresholdPercentages, 1L);
        }
    }
}

