/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DummyPayload;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SingleLogicalSlotTest {
    SingleLogicalSlotTest() {
    }

    @Test
    void testPayloadAssignment() {
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot();
        DummyPayload dummyPayload1 = new DummyPayload();
        DummyPayload dummyPayload2 = new DummyPayload();
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload1)).isTrue();
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload2)).isFalse();
        Assertions.assertThat((Object)singleLogicalSlot.getPayload()).isSameAs((Object)dummyPayload1);
    }

    private SingleLogicalSlot createSingleLogicalSlot() {
        return this.createSingleLogicalSlot(new DummySlotOwner());
    }

    private SingleLogicalSlot createSingleLogicalSlot(SlotOwner slotOwner) {
        return new SingleLogicalSlot(new SlotRequestId(), SingleLogicalSlotTest.createSlotContext(), Locality.LOCAL, slotOwner);
    }

    private static SlotContext createSlotContext() {
        return new SimpleSlotContext(new AllocationID(), new LocalTaskManagerLocation(), 0, new SimpleAckingTaskManagerGateway(), ResourceProfile.ANY);
    }

    @Test
    void testAlive() throws Exception {
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot();
        DummyPayload dummyPayload = new DummyPayload();
        Assertions.assertThat((boolean)singleLogicalSlot.isAlive()).isTrue();
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload)).isTrue();
        Assertions.assertThat((boolean)singleLogicalSlot.isAlive()).isTrue();
        CompletableFuture releaseFuture = singleLogicalSlot.releaseSlot((Throwable)new FlinkException("Test exception"));
        Assertions.assertThat((boolean)singleLogicalSlot.isAlive()).isFalse();
        releaseFuture.get();
        Assertions.assertThat((boolean)singleLogicalSlot.isAlive()).isFalse();
    }

    @Test
    void testPayloadAssignmentAfterRelease() {
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot();
        DummyPayload dummyPayload = new DummyPayload();
        singleLogicalSlot.releaseSlot((Throwable)new FlinkException("Test exception"));
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload)).isFalse();
    }

    @Test
    void testAllocatedSlotRelease() {
        CompletableFuture returnSlotFuture = new CompletableFuture();
        WaitingSlotOwner waitingSlotOwner = new WaitingSlotOwner(returnSlotFuture, new CompletableFuture());
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot(waitingSlotOwner);
        CompletableFuture terminalStateFuture = new CompletableFuture();
        CompletableFuture failFuture = new CompletableFuture();
        ManualTestingPayload dummyPayload = new ManualTestingPayload(failFuture, terminalStateFuture);
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload)).isTrue();
        singleLogicalSlot.release((Throwable)new FlinkException("Test exception"));
        FlinkAssertions.assertThatFuture(failFuture).isDone();
        FlinkAssertions.assertThatFuture(returnSlotFuture).isNotDone();
    }

    @Test
    void testSlotRelease() {
        CompletableFuture returnedSlotFuture = new CompletableFuture();
        CompletableFuture<Boolean> returnSlotResponseFuture = new CompletableFuture<Boolean>();
        WaitingSlotOwner waitingSlotOwner = new WaitingSlotOwner(returnedSlotFuture, returnSlotResponseFuture);
        CompletableFuture<Object> terminalStateFuture = new CompletableFuture<Object>();
        CompletableFuture failFuture = new CompletableFuture();
        ManualTestingPayload dummyPayload = new ManualTestingPayload(failFuture, terminalStateFuture);
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot(waitingSlotOwner);
        Assertions.assertThat((boolean)singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)dummyPayload)).isTrue();
        CompletableFuture releaseFuture = singleLogicalSlot.releaseSlot((Throwable)new FlinkException("Test exception"));
        FlinkAssertions.assertThatFuture((CompletableFuture)releaseFuture).isNotDone();
        FlinkAssertions.assertThatFuture(returnedSlotFuture).isNotDone();
        FlinkAssertions.assertThatFuture(failFuture).isDone();
        terminalStateFuture.complete(null);
        FlinkAssertions.assertThatFuture(returnedSlotFuture).isDone();
        returnSlotResponseFuture.complete(true);
        FlinkAssertions.assertThatFuture((CompletableFuture)releaseFuture).isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentReleaseOperations() throws Exception {
        CountingSlotOwner countingSlotOwner = new CountingSlotOwner();
        CountingFailPayload countingFailPayload = new CountingFailPayload();
        SingleLogicalSlot singleLogicalSlot = this.createSingleLogicalSlot(countingSlotOwner);
        singleLogicalSlot.tryAssignPayload((LogicalSlot.Payload)countingFailPayload);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        try {
            int numberConcurrentOperations = 10;
            ArrayList<CompletableFuture<Void>> releaseOperationFutures = new ArrayList<CompletableFuture<Void>>(10);
            for (int i = 0; i < 10; ++i) {
                CompletableFuture<Void> releaseOperationFuture = CompletableFuture.runAsync(() -> {
                    try {
                        singleLogicalSlot.releaseSlot((Throwable)new FlinkException("Test exception")).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        ExceptionUtils.checkInterrupted((Throwable)e);
                        throw new CompletionException(e);
                    }
                });
                releaseOperationFutures.add(releaseOperationFuture);
            }
            FutureUtils.ConjunctFuture releaseOperationsFuture = FutureUtils.waitForAll(releaseOperationFutures);
            releaseOperationsFuture.get();
            Assertions.assertThat((int)countingSlotOwner.getReleaseCount()).isOne();
            Assertions.assertThat((int)countingFailPayload.getFailCount()).isOne();
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static final class WaitingSlotOwner
    implements SlotOwner {
        private final CompletableFuture<LogicalSlot> returnAllocatedSlotFuture;
        private final CompletableFuture<Boolean> returnAllocatedSlotResponse;

        private WaitingSlotOwner(CompletableFuture<LogicalSlot> returnAllocatedSlotFuture, CompletableFuture<Boolean> returnAllocatedSlotResponse) {
            this.returnAllocatedSlotFuture = (CompletableFuture)Preconditions.checkNotNull(returnAllocatedSlotFuture);
            this.returnAllocatedSlotResponse = (CompletableFuture)Preconditions.checkNotNull(returnAllocatedSlotResponse);
        }

        public void returnLogicalSlot(LogicalSlot logicalSlot) {
            this.returnAllocatedSlotFuture.complete(logicalSlot);
        }
    }

    private static final class ManualTestingPayload
    implements LogicalSlot.Payload {
        private final CompletableFuture<?> failFuture;
        private final CompletableFuture<?> terminalStateFuture;

        private ManualTestingPayload(CompletableFuture<?> failFuture, CompletableFuture<?> terminalStateFuture) {
            this.failFuture = failFuture;
            this.terminalStateFuture = terminalStateFuture;
        }

        public void fail(Throwable cause) {
            this.failFuture.completeExceptionally(cause);
        }

        public CompletableFuture<?> getTerminalStateFuture() {
            return this.terminalStateFuture;
        }
    }

    private static final class CountingSlotOwner
    implements SlotOwner {
        private final AtomicInteger counter = new AtomicInteger(0);

        private CountingSlotOwner() {
        }

        public int getReleaseCount() {
            return this.counter.get();
        }

        public void returnLogicalSlot(LogicalSlot logicalSlot) {
            this.counter.incrementAndGet();
        }
    }

    private static final class CountingFailPayload
    implements LogicalSlot.Payload {
        private final AtomicInteger failCounter = new AtomicInteger(0);

        private CountingFailPayload() {
        }

        int getFailCount() {
            return this.failCounter.get();
        }

        public void fail(Throwable cause) {
            this.failCounter.incrementAndGet();
        }

        public CompletableFuture<?> getTerminalStateFuture() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

