/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SameTypePairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.hash.AbstractMutableHashTable;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.hash.MutableHashTableTestBase;
import org.apache.flink.runtime.operators.testutils.types.IntList;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class CompactingHashTableTest
extends MutableHashTableTestBase {
    private final TypeComparator<Long> probeComparator = new LongComparator(true);
    private final TypePairComparator<Long, Tuple2<Long, String>> pairComparator = new TypePairComparator<Long, Tuple2<Long, String>>(){
        private long ref;

        public void setReference(Long reference) {
            this.ref = reference;
        }

        public boolean equalToReference(Tuple2<Long, String> candidate) {
            return (Long)candidate.f0 == this.ref;
        }

        public int compareToReference(Tuple2<Long, String> candidate) {
            long x = this.ref;
            long y = (Long)candidate.f0;
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    };

    @Override
    protected <T> AbstractMutableHashTable<T> getHashTable(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory) {
        return new CompactingHashTable(serializer, comparator, memory);
    }

    @Test
    void testHashTableGrowthWithInsert() {
        try {
            Tuple2 next;
            int numElements = 1000000;
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(10000, 32768);
            CompactingHashTable table = new CompactingHashTable((TypeSerializer)this.tuple2LongStringSerializer, (TypeComparator)this.tuple2LongStringComparator, memory, 10000);
            table.open();
            for (long i = 0L; i < 1000000L; ++i) {
                table.insert((Object)new Tuple2((Object)i, (Object)String.valueOf(i)));
            }
            BitSet bitSet = new BitSet(1000000);
            MutableObjectIterator iter = table.getEntryIterator();
            while ((next = (Tuple2)iter.next()) != null) {
                Assertions.assertThat((String)((String)next.f1)).isNotNull();
                ((AbstractLongAssert)Assertions.assertThat((Long)((Long)next.f0)).isNotNull()).isEqualTo(Long.parseLong((String)next.f1));
                bitSet.set(((Long)next.f0).intValue());
            }
            Assertions.assertThat((int)bitSet.cardinality()).isEqualTo(1000000);
            CompactingHashTable.HashTableProber proper = table.getProber(this.probeComparator, this.pairComparator);
            for (long i = 0L; i < 1000000L; ++i) {
                Assertions.assertThat((Object)proper.getMatchFor((Object)i)).isNotNull();
                Assertions.assertThat((Object)proper.getMatchFor((Object)(i + 1000000L))).isNull();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testHashTableGrowthWithInsertOrReplace() {
        try {
            Tuple2 next;
            int numElements = 1000000;
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(10000, 32768);
            CompactingHashTable table = new CompactingHashTable((TypeSerializer)this.tuple2LongStringSerializer, (TypeComparator)this.tuple2LongStringComparator, memory, 10000);
            table.open();
            for (long i = 0L; i < 1000000L; ++i) {
                table.insertOrReplaceRecord((Object)new Tuple2((Object)i, (Object)String.valueOf(i)));
            }
            BitSet bitSet = new BitSet(1000000);
            MutableObjectIterator iter = table.getEntryIterator();
            while ((next = (Tuple2)iter.next()) != null) {
                Assertions.assertThat((String)((String)next.f1)).isNotNull();
                ((AbstractLongAssert)Assertions.assertThat((Long)((Long)next.f0)).isNotNull()).isEqualTo(Long.parseLong((String)next.f1));
                bitSet.set(((Long)next.f0).intValue());
            }
            Assertions.assertThat((int)bitSet.cardinality()).isEqualTo(1000000);
            CompactingHashTable.HashTableProber proper = table.getProber(this.probeComparator, this.pairComparator);
            for (long i = 0L; i < 1000000L; ++i) {
                Assertions.assertThat((Object)proper.getMatchFor((Object)i)).isNotNull();
                Assertions.assertThat((Object)proper.getMatchFor((Object)(i + 1000000L))).isNull();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testInsertsWithInsertOrReplace() {
        try {
            long i;
            int numElements = 1000;
            String longString = CompactingHashTableTest.getLongString(10000);
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(1000, 32768);
            CompactingHashTable table = new CompactingHashTable((TypeSerializer)this.tuple2LongStringSerializer, (TypeComparator)this.tuple2LongStringComparator, memory, 100);
            table.open();
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)Tuple2.of((Object)i, (Object)longString));
            }
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)Tuple2.of((Object)i, (Object)longString));
            }
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)Tuple2.of((Object)(i + 1000L), (Object)longString));
            }
            CompactingHashTable.HashTableProber prober = table.getProber((TypeComparator)this.tuple2LongStringComparator, (TypePairComparator)new SameTypePairComparator((TypeComparator)this.tuple2LongStringComparator));
            Tuple2 reuse = new Tuple2();
            for (long i2 = 0L; i2 < 1000L; ++i2) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)Tuple2.of((Object)i2, (Object)longString), (Object)reuse)).isNotNull();
                Assertions.assertThat((Object)prober.getMatchFor((Object)Tuple2.of((Object)(i2 + 1000L), (Object)longString), (Object)reuse)).isNotNull();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testResize() {
        try {
            int NUM_MEM_PAGES = 183;
            Random rnd = new Random(76518743207143L);
            IntPair[] pairs = CompactingHashTableTest.getRandomizedIntPairs(100000, rnd);
            List<MemorySegment> memory = this.getMemory(183);
            CompactingHashTable table = new CompactingHashTable(this.intPairSerializer, this.intPairComparator, memory);
            table.open();
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)pairs[i]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.intPairComparator, (TypePairComparator)new SameTypePairComparator(this.intPairComparator));
            IntPair target = new IntPair();
            for (int i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(100));
            Boolean b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (int i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            table.close();
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(283);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    void testDoubleResize() {
        try {
            int i;
            int NUM_MEM_PAGES = 183;
            Random rnd = new Random(76518743207143L);
            IntPair[] pairs = CompactingHashTableTest.getRandomizedIntPairs(100000, rnd);
            List<MemorySegment> memory = this.getMemory(183);
            CompactingHashTable table = new CompactingHashTable(this.intPairSerializer, this.intPairComparator, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)pairs[i2]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.intPairComparator, (TypePairComparator)new SameTypePairComparator(this.intPairComparator));
            IntPair target = new IntPair();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i3], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i3].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(100));
            Boolean b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(100));
            b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            table.close();
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(383);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    void testTripleResize() {
        try {
            int i;
            int NUM_MEM_PAGES = 183;
            Random rnd = new Random(76518743207143L);
            IntPair[] pairs = CompactingHashTableTest.getRandomizedIntPairs(100000, rnd);
            List<MemorySegment> memory = this.getMemory(183);
            CompactingHashTable table = new CompactingHashTable(this.intPairSerializer, this.intPairComparator, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)pairs[i2]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.intPairComparator, (TypePairComparator)new SameTypePairComparator(this.intPairComparator));
            IntPair target = new IntPair();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i3], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i3].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(100));
            Boolean b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(100));
            b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            memory.addAll(this.getMemory(200));
            b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)pairs[i], (Object)target)).isNotNull();
                Assertions.assertThat((int)pairs[i].getValue()).isEqualTo(target.getValue());
            }
            table.close();
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(583);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    void testResizeWithCompaction() {
        try {
            int i;
            int NUM_MEM_PAGES = 457;
            Random rnd = new Random(76518743207143L);
            IntList[] lists = CompactingHashTableTest.getRandomizedIntLists(100000, rnd);
            List<MemorySegment> memory = this.getMemory(457);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)lists[i2]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)lists[i3], (Object)target)).isNotNull();
                Assertions.assertThat((int[])lists[i3].getValue()).isEqualTo((Object)target.getValue());
            }
            memory.addAll(this.getMemory(100));
            Boolean b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (int i4 = 0; i4 < 100000; ++i4) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)lists[i4], (Object)target)).isNotNull();
                Assertions.assertThat((int[])lists[i4].getValue()).isEqualTo((Object)target.getValue());
            }
            IntList[] overwriteLists = CompactingHashTableTest.getRandomizedIntLists(100000, rnd);
            for (i = 0; i < 100000; ++i) {
                table.insertOrReplaceRecord((Object)overwriteLists[i]);
            }
            table.compactPartitions();
            memory.addAll(this.getMemory(200));
            b = table.resizeHashTable();
            Assertions.assertThat((Boolean)b).isTrue();
            for (i = 0; i < 100000; ++i) {
                Assertions.assertThat((Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target)).isNotNull();
                Assertions.assertThat((int[])overwriteLists[i].getValue()).isEqualTo((Object)target.getValue());
            }
            table.close();
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(757);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    private static List<MemorySegment> getMemory(int numSegments, int segmentSize) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            list.add(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize));
        }
        return list;
    }

    private static String getLongString(int length) {
        StringBuilder bld = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            bld.append('a');
        }
        return bld.toString();
    }
}

