/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingMetricGroup;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileMergingMetricsTest {
    FileMergingMetricsTest() {
    }

    @Test
    void testMetricsRegistration() {
        final ArrayList registeredGaugeNames = new ArrayList();
        UnregisteredMetricsGroup metricGroup = new UnregisteredMetricsGroup(){

            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                if (gauge != null) {
                    registeredGaugeNames.add(name);
                }
                return gauge;
            }
        };
        FileMergingSnapshotManager.SpaceStat spaceStat = new FileMergingSnapshotManager.SpaceStat();
        FileMergingMetricGroup fileMergingMetricGroup = new FileMergingMetricGroup((MetricGroup)metricGroup, spaceStat);
        Assertions.assertThat(registeredGaugeNames).containsAll(Arrays.asList("fileMerging.logicalFileCount", "fileMerging.logicalFileSize", "fileMerging.physicalFileCount", "fileMerging.physicalFileSize"));
        Assertions.assertThat((int)registeredGaugeNames.size()).isEqualTo(4);
    }

    @Test
    void testMetricsAreUpdated() {
        final HashMap registeredGauges = new HashMap();
        UnregisteredMetricsGroup metricGroup = new UnregisteredMetricsGroup(){

            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                registeredGauges.put(name, gauge);
                return gauge;
            }
        };
        FileMergingSnapshotManager.SpaceStat spaceStat = new FileMergingSnapshotManager.SpaceStat();
        FileMergingMetricGroup fileMergingMetricGroup = new FileMergingMetricGroup((MetricGroup)metricGroup, spaceStat);
        Gauge logicalFileCountGauge = (Gauge)registeredGauges.get("fileMerging.logicalFileCount");
        Gauge logicalFileSizeGauge = (Gauge)registeredGauges.get("fileMerging.logicalFileSize");
        Gauge physicalFileCountGauge = (Gauge)registeredGauges.get("fileMerging.physicalFileCount");
        Gauge physicalFileSizeGauge = (Gauge)registeredGauges.get("fileMerging.physicalFileSize");
        Assertions.assertThat((Long)((Long)logicalFileCountGauge.getValue())).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)logicalFileSizeGauge.getValue())).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)physicalFileCountGauge.getValue())).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)physicalFileSizeGauge.getValue())).isEqualTo(0L);
        spaceStat.onLogicalFileCreate(100L);
        spaceStat.onPhysicalFileCreate();
        spaceStat.onPhysicalFileUpdate(100L);
        Assertions.assertThat((Long)((Long)logicalFileCountGauge.getValue())).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)logicalFileSizeGauge.getValue())).isEqualTo(100L);
        Assertions.assertThat((Long)((Long)physicalFileCountGauge.getValue())).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)physicalFileSizeGauge.getValue())).isEqualTo(100L);
    }
}

