/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;

public class TestingJobMasterPartitionTracker
implements JobMasterPartitionTracker {
    private Function<ResourceID, Boolean> isTrackingPartitionsForFunction = ignored -> false;
    private Function<ResultPartitionID, Boolean> isPartitionTrackedFunction = ignored -> false;
    private Consumer<ResourceID> stopTrackingAllPartitionsConsumer = ignored -> {};
    private BiConsumer<ResourceID, ResultPartitionDeploymentDescriptor> startTrackingPartitionsConsumer = (ignoredA, ignoredB) -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer = ignored -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingAndPromotePartitionsConsumer = ignored -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingPartitionsConsumer = ignored -> {};
    private Supplier<Collection<ResultPartitionDeploymentDescriptor>> getAllTrackedPartitionsSupplier = () -> Collections.emptyList();

    public void setStartTrackingPartitionsConsumer(BiConsumer<ResourceID, ResultPartitionDeploymentDescriptor> startTrackingPartitionsConsumer) {
        this.startTrackingPartitionsConsumer = startTrackingPartitionsConsumer;
    }

    public void setIsTrackingPartitionsForFunction(Function<ResourceID, Boolean> isTrackingPartitionsForFunction) {
        this.isTrackingPartitionsForFunction = isTrackingPartitionsForFunction;
    }

    public void setIsPartitionTrackedFunction(Function<ResultPartitionID, Boolean> isPartitionTrackedFunction) {
        this.isPartitionTrackedFunction = isPartitionTrackedFunction;
    }

    public void setStopTrackingAllPartitionsConsumer(Consumer<ResourceID> stopTrackingAllPartitionsConsumer) {
        this.stopTrackingAllPartitionsConsumer = stopTrackingAllPartitionsConsumer;
    }

    public void setStopTrackingAndReleasePartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer) {
        this.stopTrackingAndReleasePartitionsConsumer = stopTrackingAndReleasePartitionsConsumer;
    }

    public void setStopTrackingPartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingPartitionsConsumer) {
        this.stopTrackingPartitionsConsumer = stopTrackingPartitionsConsumer;
    }

    public void setGetAllTrackedPartitionsSupplier(Supplier<Collection<ResultPartitionDeploymentDescriptor>> getAllTrackedPartitionsSupplier) {
        this.getAllTrackedPartitionsSupplier = getAllTrackedPartitionsSupplier;
    }

    public void setStopTrackingAndPromotePartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingAndPromotePartitionsConsumer) {
        this.stopTrackingAndPromotePartitionsConsumer = stopTrackingAndPromotePartitionsConsumer;
    }

    public void startTrackingPartition(ResourceID producingTaskExecutorId, ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        this.startTrackingPartitionsConsumer.accept(producingTaskExecutorId, resultPartitionDeploymentDescriptor);
    }

    public Collection<PartitionTrackerEntry<ResourceID, ResultPartitionDeploymentDescriptor>> stopTrackingPartitionsFor(ResourceID producingTaskExecutorId) {
        this.stopTrackingAllPartitionsConsumer.accept(producingTaskExecutorId);
        return Collections.emptyList();
    }

    public void stopTrackingAndReleasePartitions(Collection<ResultPartitionID> resultPartitionIds, boolean releaseOnShuffleMaster) {
        this.stopTrackingAndReleasePartitionsConsumer.accept(resultPartitionIds);
    }

    public CompletableFuture<Void> stopTrackingAndPromotePartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingAndPromotePartitionsConsumer.accept(resultPartitionIds);
        return CompletableFuture.completedFuture(null);
    }

    public Collection<PartitionTrackerEntry<ResourceID, ResultPartitionDeploymentDescriptor>> stopTrackingPartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingPartitionsConsumer.accept(resultPartitionIds);
        return Collections.emptyList();
    }

    public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedPartitions() {
        return this.getAllTrackedPartitionsSupplier.get();
    }

    public void connectToResourceManager(ResourceManagerGateway resourceManagerGateway) {
    }

    public List<ShuffleDescriptor> getClusterPartitionShuffleDescriptors(IntermediateDataSetID intermediateDataSetID) {
        return Collections.emptyList();
    }

    public boolean isTrackingPartitionsFor(ResourceID producingTaskExecutorId) {
        return this.isTrackingPartitionsForFunction.apply(producingTaskExecutorId);
    }

    public boolean isPartitionTracked(ResultPartitionID resultPartitionID) {
        return this.isPartitionTrackedFunction.apply(resultPartitionID);
    }
}

