/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.scheduler.JobStatusStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

class JobStatusStoreTest {
    JobStatusStoreTest() {
    }

    @Test
    void initialState() {
        JobStatusStore store = new JobStatusStore(0L);
        MatcherAssert.assertThat((Object)store.getState(), (Matcher)Is.is((Object)JobStatus.INITIALIZING));
    }

    @Test
    void initialTimestamps() {
        JobStatusStore store = new JobStatusStore(967823L);
        block3: for (JobStatus jobStatus : JobStatus.values()) {
            switch (jobStatus) {
                case INITIALIZING: {
                    MatcherAssert.assertThat((Object)store.getStatusTimestamp(JobStatus.INITIALIZING), (Matcher)Is.is((Object)967823L));
                    continue block3;
                }
                default: {
                    MatcherAssert.assertThat((Object)store.getStatusTimestamp(jobStatus), (Matcher)Is.is((Object)0L));
                }
            }
        }
    }

    @Test
    void getState() {
        JobStatusStore store = new JobStatusStore(0L);
        store.jobStatusChanges(new JobID(), JobStatus.RUNNING, 1L);
        MatcherAssert.assertThat((Object)store.getState(), (Matcher)Is.is((Object)JobStatus.RUNNING));
    }

    @Test
    void getStatusTimestamp() {
        JobStatusStore store = new JobStatusStore(0L);
        store.jobStatusChanges(new JobID(), JobStatus.RUNNING, 1L);
        MatcherAssert.assertThat((Object)store.getStatusTimestamp(JobStatus.RUNNING), (Matcher)Is.is((Object)1L));
    }
}

