/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.state.StateFutureImpl;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.mailbox.SyncMailboxExecutor;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.AsyncKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackendParametersImpl;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.v2.StateDescriptor;
import org.apache.flink.runtime.state.v2.ValueStateDescriptor;
import org.apache.flink.util.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public abstract class StateBackendTestV2Base<B extends AbstractStateBackend> {
    protected MockEnvironment env;
    private CheckpointStreamFactory checkpointStreamFactory;

    @BeforeEach
    void before() throws Exception {
        this.env = this.buildMockEnv();
    }

    private MockEnvironment buildMockEnv() throws Exception {
        MockEnvironment mockEnvironment = MockEnvironment.builder().setTaskStateManager(this.getTestTaskStateManager()).build();
        mockEnvironment.setCheckpointStorageAccess(this.getCheckpointStorageAccess());
        return mockEnvironment;
    }

    protected TestTaskStateManager getTestTaskStateManager() throws IOException {
        return TestTaskStateManager.builder().build();
    }

    @AfterEach
    void after() {
        IOUtils.closeQuietly((AutoCloseable)this.env);
    }

    protected abstract ConfigurableStateBackend getStateBackend() throws Exception;

    protected CheckpointStorage getCheckpointStorage() throws Exception {
        ConfigurableStateBackend stateBackend = this.getStateBackend();
        if (stateBackend instanceof CheckpointStorage) {
            return (CheckpointStorage)stateBackend;
        }
        throw new IllegalStateException("The state backend under test does not implement CheckpointStorage.Please override 'createCheckpointStorage' and provide an appropriatecheckpoint storage instance");
    }

    protected CheckpointStorageAccess getCheckpointStorageAccess() throws Exception {
        return this.getCheckpointStorage().createCheckpointStorage(new JobID());
    }

    protected CheckpointStreamFactory createStreamFactory() throws Exception {
        if (this.checkpointStreamFactory == null) {
            this.checkpointStreamFactory = this.getCheckpointStorage().createCheckpointStorage(new JobID()).resolveCheckpointStorageLocation(1L, CheckpointStorageLocationReference.getDefault());
        }
        return this.checkpointStreamFactory;
    }

    protected <K> AsyncKeyedStateBackend<K> createAsyncKeyedBackend(TypeSerializer<K> keySerializer, int numberOfKeyGroups, Environment env) throws Exception {
        env.setCheckpointStorageAccess(this.getCheckpointStorageAccess());
        return this.getStateBackend().createAsyncKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl(env, new JobID(), "test_op", keySerializer, numberOfKeyGroups, new KeyGroupRange(0, numberOfKeyGroups - 1), env.getTaskKvStateRegistry(), TtlTimeProvider.DEFAULT, this.getMetricGroup(), this.getCustomInitializationMetrics(), Collections.emptyList(), new CloseableRegistry(), 1.0));
    }

    protected StateBackend.CustomInitializationMetrics getCustomInitializationMetrics() {
        return (name, value) -> {};
    }

    protected <K> AsyncKeyedStateBackend<K> restoreAsyncKeyedBackend(TypeSerializer<K> keySerializer, int numberOfKeyGroups, List<KeyedStateHandle> state, Environment env) throws Exception {
        return this.getStateBackend().createAsyncKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl(env, new JobID(), "test_op", keySerializer, numberOfKeyGroups, new KeyGroupRange(0, numberOfKeyGroups - 1), env.getTaskKvStateRegistry(), TtlTimeProvider.DEFAULT, this.getMetricGroup(), this.getCustomInitializationMetrics(), state, new CloseableRegistry(), 1.0));
    }

    protected MetricGroup getMetricGroup() {
        return new UnregisteredMetricsGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    void testAsyncKeyedStateBackendSnapshot() throws Exception {
        KeyedStateHandle stateHandle;
        ValueState valueState;
        ValueStateDescriptor stateDescriptor;
        AsyncExecutionController aec;
        int mockRecordCount = 20;
        int jobMaxParallelism = 128;
        int aecBatchSize = 1;
        long aecBufferTimeout = 1L;
        int aecMaxInFlightRecords = 1000;
        ArrayList<RecordContext> recordContexts = new ArrayList<RecordContext>(mockRecordCount);
        AsyncKeyedStateBackend backend = null;
        TestAsyncFrameworkExceptionHandler testExceptionHandler = new TestAsyncFrameworkExceptionHandler();
        try {
            int i;
            int i2;
            backend = this.createAsyncKeyedBackend((TypeSerializer)IntSerializer.INSTANCE, jobMaxParallelism, this.env);
            aec = new AsyncExecutionController((MailboxExecutor)new SyncMailboxExecutor(), (StateFutureImpl.AsyncFrameworkExceptionHandler)testExceptionHandler, backend.createStateExecutor(), jobMaxParallelism, aecBatchSize, aecBufferTimeout, aecMaxInFlightRecords, null);
            backend.setup((StateRequestHandler)aec);
            stateDescriptor = new ValueStateDescriptor("test", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
            valueState = (ValueState)backend.createState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)stateDescriptor);
            for (i2 = 0; i2 < mockRecordCount; ++i2) {
                recordContexts.add(aec.buildContext((Object)i2, (Object)i2));
                ((RecordContext)recordContexts.get(i2)).retain();
            }
            for (i2 = 0; i2 < mockRecordCount; ++i2) {
                aec.setCurrentContext((RecordContext)recordContexts.get(i2));
                valueState.update((Object)i2);
            }
            for (i2 = 0; i2 < mockRecordCount; ++i2) {
                aec.setCurrentContext((RecordContext)recordContexts.get(i2));
                Assertions.assertThat((Integer)((Integer)valueState.value())).isEqualTo(i2);
                ((RecordContext)recordContexts.get(i2)).release();
            }
            aec.drainInflightRecords(0);
            RunnableFuture snapshot = backend.snapshot(1L, System.currentTimeMillis(), this.createStreamFactory(), CheckpointOptions.forCheckpointWithDefaultLocation());
            if (!snapshot.isDone()) {
                snapshot.run();
            }
            SnapshotResult snapshotResult = (SnapshotResult)snapshot.get();
            stateHandle = (KeyedStateHandle)snapshotResult.getJobManagerOwnedSnapshot();
            recordContexts.clear();
            for (i = 0; i < mockRecordCount; ++i) {
                recordContexts.add(aec.buildContext((Object)i, (Object)i));
                ((RecordContext)recordContexts.get(i)).retain();
            }
            for (i = 0; i < mockRecordCount; ++i) {
                aec.setCurrentContext((RecordContext)recordContexts.get(i));
                valueState.update((Object)(i + 1));
            }
            for (i = 0; i < mockRecordCount; ++i) {
                aec.setCurrentContext((RecordContext)recordContexts.get(i));
                Assertions.assertThat((Integer)((Integer)valueState.value())).isEqualTo(i + 1);
                ((RecordContext)recordContexts.get(i)).release();
            }
        }
        finally {
            if (null != backend) {
                IOUtils.closeQuietly(backend);
                backend.dispose();
            }
        }
        Assertions.assertThat((Object)stateHandle).isNotNull();
        backend = null;
        try {
            int i;
            backend = this.restoreAsyncKeyedBackend((TypeSerializer)IntSerializer.INSTANCE, jobMaxParallelism, Collections.singletonList(stateHandle), this.env);
            aec = new AsyncExecutionController((MailboxExecutor)new SyncMailboxExecutor(), (StateFutureImpl.AsyncFrameworkExceptionHandler)testExceptionHandler, backend.createStateExecutor(), jobMaxParallelism, aecBatchSize, aecBufferTimeout, aecMaxInFlightRecords, null);
            backend.setup((StateRequestHandler)aec);
            stateDescriptor = new ValueStateDescriptor("test", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
            valueState = (ValueState)backend.createState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)stateDescriptor);
            recordContexts.clear();
            for (i = 0; i < mockRecordCount; ++i) {
                recordContexts.add(aec.buildContext((Object)i, (Object)i));
                ((RecordContext)recordContexts.get(i)).retain();
            }
            for (i = 0; i < mockRecordCount; ++i) {
                aec.setCurrentContext((RecordContext)recordContexts.get(i));
                Assertions.assertThat((Integer)((Integer)valueState.value())).isEqualTo(i);
                ((RecordContext)recordContexts.get(i)).release();
            }
        }
        finally {
            if (null != backend) {
                IOUtils.closeQuietly(backend);
                backend.dispose();
            }
        }
        Assertions.assertThat((Throwable)testExceptionHandler.exception).isNull();
    }

    static class TestAsyncFrameworkExceptionHandler
    implements StateFutureImpl.AsyncFrameworkExceptionHandler {
        String message = null;
        Throwable exception = null;

        TestAsyncFrameworkExceptionHandler() {
        }

        public void handleException(String message, Throwable exception) {
            this.message = message;
            this.exception = exception;
        }
    }
}

