/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableList;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.operators.StreamGroupedReduceOperator;
import org.apache.flink.streaming.util.MockContext;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregationFunctionTest {
    AggregationFunctionTest() {
    }

    @Test
    void groupSumIntegerTest() throws Exception {
        ArrayList<Tuple2> expectedGroupSumList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedGroupMinList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedGroupMaxList = new ArrayList<Tuple2>();
        int groupedSum0 = 0;
        int groupedSum1 = 0;
        int groupedSum2 = 0;
        for (int i = 0; i < 9; ++i) {
            int groupedSum;
            switch (i % 3) {
                case 0: {
                    groupedSum = groupedSum0 += i;
                    break;
                }
                case 1: {
                    groupedSum = groupedSum1 += i;
                    break;
                }
                default: {
                    groupedSum = groupedSum2 += i;
                }
            }
            expectedGroupSumList.add(new Tuple2((Object)(i % 3), (Object)groupedSum));
            expectedGroupMinList.add(new Tuple2((Object)(i % 3), (Object)(i % 3)));
            expectedGroupMaxList.add(new Tuple2((Object)(i % 3), (Object)i));
        }
        TypeInformation typeInfo = TypeExtractor.getForObject((Object)new Tuple2((Object)0, (Object)0));
        ExecutionConfig config = new ExecutionConfig();
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys((Keys)new Keys.ExpressionKeys(new int[]{0}, typeInfo), (TypeInformation)typeInfo, (ExecutionConfig)config);
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)typeInfo);
        SumAggregator sumFunction = new SumAggregator(1, typeInfo, config);
        ComparableAggregator minFunction = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MIN, config);
        ComparableAggregator maxFunction = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MAX, config);
        List groupedSumList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)sumFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputList(), keySelector, keyType);
        List groupedMinList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputList(), keySelector, keyType);
        List groupedMaxList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputList(), keySelector, keyType);
        Assertions.assertThat(groupedSumList).isEqualTo(expectedGroupSumList);
        Assertions.assertThat(groupedMinList).isEqualTo(expectedGroupMinList);
        Assertions.assertThat(groupedMaxList).isEqualTo(expectedGroupMaxList);
    }

    @Test
    void pojoGroupSumIntegerTest() throws Exception {
        ArrayList<MyPojo> expectedGroupSumList = new ArrayList<MyPojo>();
        ArrayList<MyPojo> expectedGroupMinList = new ArrayList<MyPojo>();
        ArrayList<MyPojo> expectedGroupMaxList = new ArrayList<MyPojo>();
        int groupedSum0 = 0;
        int groupedSum1 = 0;
        int groupedSum2 = 0;
        for (int i = 0; i < 9; ++i) {
            int groupedSum;
            switch (i % 3) {
                case 0: {
                    groupedSum = groupedSum0 += i;
                    break;
                }
                case 1: {
                    groupedSum = groupedSum1 += i;
                    break;
                }
                default: {
                    groupedSum = groupedSum2 += i;
                }
            }
            expectedGroupSumList.add(new MyPojo(i % 3, groupedSum));
            expectedGroupMinList.add(new MyPojo(i % 3, i % 3));
            expectedGroupMaxList.add(new MyPojo(i % 3, i));
        }
        TypeInformation typeInfo = TypeExtractor.getForObject((Object)new MyPojo(0, 0));
        ExecutionConfig config = new ExecutionConfig();
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys((Keys)new Keys.ExpressionKeys(new String[]{"f0"}, typeInfo), (TypeInformation)typeInfo, (ExecutionConfig)config);
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)typeInfo);
        SumAggregator sumFunction = new SumAggregator("f1", typeInfo, config);
        ComparableAggregator minFunction = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MIN, false, config);
        ComparableAggregator maxFunction = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MAX, false, config);
        List groupedSumList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)sumFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputPojoList(), keySelector, keyType);
        List groupedMinList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputPojoList(), keySelector, keyType);
        List groupedMaxList = MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxFunction, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputPojoList(), keySelector, keyType);
        Assertions.assertThat(groupedSumList).isEqualTo(expectedGroupSumList);
        Assertions.assertThat(groupedMinList).isEqualTo(expectedGroupMinList);
        Assertions.assertThat(groupedMaxList).isEqualTo(expectedGroupMaxList);
    }

    @Test
    void minMaxByTest() throws Exception {
        ImmutableList maxByFirstExpected = ImmutableList.of((Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)1, (Object)1), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2));
        ImmutableList maxByLastExpected = ImmutableList.of((Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)1, (Object)1), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)2), (Object)Tuple3.of((Object)0, (Object)2, (Object)5), (Object)Tuple3.of((Object)0, (Object)2, (Object)5), (Object)Tuple3.of((Object)0, (Object)2, (Object)5), (Object)Tuple3.of((Object)0, (Object)2, (Object)8));
        ImmutableList minByFirstExpected = ImmutableList.of((Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0));
        ImmutableList minByLastExpected = ImmutableList.of((Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)0), (Object)Tuple3.of((Object)0, (Object)0, (Object)3), (Object)Tuple3.of((Object)0, (Object)0, (Object)3), (Object)Tuple3.of((Object)0, (Object)0, (Object)3), (Object)Tuple3.of((Object)0, (Object)0, (Object)6), (Object)Tuple3.of((Object)0, (Object)0, (Object)6), (Object)Tuple3.of((Object)0, (Object)0, (Object)6));
        TypeInformation typeInfo = TypeExtractor.getForObject((Object)Tuple3.of((Object)0, (Object)0, (Object)0));
        ExecutionConfig config = new ExecutionConfig();
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys((Keys)new Keys.ExpressionKeys(new int[]{0}, typeInfo), (TypeInformation)typeInfo, (ExecutionConfig)config);
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)typeInfo);
        ComparableAggregator maxByFunctionFirst = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MAXBY, true, config);
        ComparableAggregator maxByFunctionLast = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MAXBY, false, config);
        ComparableAggregator minByFunctionFirst = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MINBY, true, config);
        ComparableAggregator minByFunctionLast = new ComparableAggregator(1, typeInfo, AggregationFunction.AggregationType.MINBY, false, config);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxByFunctionFirst, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByList(), keySelector, keyType)).isEqualTo((Object)maxByFirstExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxByFunctionLast, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByList(), keySelector, keyType)).isEqualTo((Object)maxByLastExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minByFunctionLast, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByList(), keySelector, keyType)).isEqualTo((Object)minByLastExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minByFunctionFirst, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByList(), keySelector, keyType)).isEqualTo((Object)minByFirstExpected);
    }

    @Test
    void pojoMinMaxByTest() throws Exception {
        ImmutableList maxByFirstExpected = ImmutableList.of((Object)new MyPojo3(0, 0), (Object)new MyPojo3(1, 1), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2));
        ImmutableList maxByLastExpected = ImmutableList.of((Object)new MyPojo3(0, 0), (Object)new MyPojo3(1, 1), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 2), (Object)new MyPojo3(2, 5), (Object)new MyPojo3(2, 5), (Object)new MyPojo3(2, 5), (Object)new MyPojo3(2, 8));
        ImmutableList minByFirstExpected = ImmutableList.of((Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0));
        ImmutableList minByLastExpected = ImmutableList.of((Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 0), (Object)new MyPojo3(0, 3), (Object)new MyPojo3(0, 3), (Object)new MyPojo3(0, 3), (Object)new MyPojo3(0, 6), (Object)new MyPojo3(0, 6), (Object)new MyPojo3(0, 6));
        TypeInformation typeInfo = TypeExtractor.getForObject((Object)new MyPojo3(0, 0));
        ExecutionConfig config = new ExecutionConfig();
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys((Keys)new Keys.ExpressionKeys(new String[]{"f0"}, typeInfo), (TypeInformation)typeInfo, (ExecutionConfig)config);
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)typeInfo);
        ComparableAggregator maxByFunctionFirst = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MAXBY, true, config);
        ComparableAggregator maxByFunctionLast = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MAXBY, false, config);
        ComparableAggregator minByFunctionFirst = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MINBY, true, config);
        ComparableAggregator minByFunctionLast = new ComparableAggregator("f1", typeInfo, AggregationFunction.AggregationType.MINBY, false, config);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxByFunctionFirst, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByPojoList(), keySelector, keyType)).isEqualTo((Object)maxByFirstExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)maxByFunctionLast, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByPojoList(), keySelector, keyType)).isEqualTo((Object)maxByLastExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minByFunctionLast, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByPojoList(), keySelector, keyType)).isEqualTo((Object)minByLastExpected);
        Assertions.assertThat(MockContext.createAndExecuteForKeyedStream(new StreamGroupedReduceOperator((ReduceFunction)minByFunctionFirst, typeInfo.createSerializer(config.getSerializerConfig())), this.getInputByPojoList(), keySelector, keyType)).isEqualTo((Object)minByFirstExpected);
    }

    private List<Tuple2<Integer, Integer>> getInputList() {
        ArrayList<Tuple2<Integer, Integer>> inputList = new ArrayList<Tuple2<Integer, Integer>>();
        for (int i = 0; i < 9; ++i) {
            inputList.add((Tuple2<Integer, Integer>)Tuple2.of((Object)(i % 3), (Object)i));
        }
        return inputList;
    }

    private List<MyPojo> getInputPojoList() {
        ArrayList<MyPojo> inputList = new ArrayList<MyPojo>();
        for (int i = 0; i < 9; ++i) {
            inputList.add(new MyPojo(i % 3, i));
        }
        return inputList;
    }

    private List<Tuple3<Integer, Integer, Integer>> getInputByList() {
        ArrayList<Tuple3<Integer, Integer, Integer>> inputList = new ArrayList<Tuple3<Integer, Integer, Integer>>();
        for (int i = 0; i < 9; ++i) {
            inputList.add((Tuple3<Integer, Integer, Integer>)Tuple3.of((Object)0, (Object)(i % 3), (Object)i));
        }
        return inputList;
    }

    private List<MyPojo3> getInputByPojoList() {
        ArrayList<MyPojo3> inputList = new ArrayList<MyPojo3>();
        for (int i = 0; i < 9; ++i) {
            inputList.add(new MyPojo3(i % 3, i));
        }
        return inputList;
    }

    public static class MyPojo3
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int f0;
        public int f1;
        public int f2;

        public MyPojo3(int f1, int f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public MyPojo3() {
        }

        public String toString() {
            return "POJO3(" + this.f0 + "," + this.f1 + "," + this.f2 + ")";
        }

        public boolean equals(Object other) {
            if (other instanceof MyPojo3) {
                return this.f0 == ((MyPojo3)other).f0 && this.f1 == ((MyPojo3)other).f1 && this.f2 == ((MyPojo3)other).f2;
            }
            return false;
        }
    }

    public static class MyPojo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int f0;
        public int f1;

        public MyPojo(int f0, int f1) {
            this.f0 = f0;
            this.f1 = f1;
        }

        public MyPojo() {
        }

        public String toString() {
            return "POJO(" + this.f0 + "," + this.f1 + ")";
        }

        public boolean equals(Object other) {
            if (other instanceof MyPojo) {
                return this.f0 == ((MyPojo)other).f0 && this.f1 == ((MyPojo)other).f1;
            }
            return false;
        }
    }
}

