/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.StreamRecordMatchers;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.ThrowingConsumer;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

abstract class WindowOperatorContractTest {
    private static ValueStateDescriptor<String> valueStateDescriptor = new ValueStateDescriptor("string-state", (TypeSerializer)StringSerializer.INSTANCE, null);

    WindowOperatorContractTest() {
    }

    static <IN, OUT, KEY, W extends Window> InternalWindowFunction<IN, OUT, KEY, W> mockWindowFunction() throws Exception {
        InternalWindowFunction mockWindowFunction = (InternalWindowFunction)Mockito.mock(InternalWindowFunction.class);
        return mockWindowFunction;
    }

    static <T, W extends Window> Trigger<T, W> mockTrigger() throws Exception {
        Trigger mockTrigger = (Trigger)Mockito.mock(Trigger.class);
        Mockito.when((Object)mockTrigger.onElement(Matchers.any(), Matchers.anyLong(), (Window)Matchers.any(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)Matchers.any(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)Matchers.any(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        return mockTrigger;
    }

    static <T> WindowAssigner<T, TimeWindow> mockTimeWindowAssigner() throws Exception {
        WindowAssigner mockAssigner = (WindowAssigner)Mockito.mock(WindowAssigner.class);
        Mockito.when((Object)mockAssigner.getWindowSerializer((ExecutionConfig)Mockito.any())).thenReturn((Object)new TimeWindow.Serializer());
        Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)true);
        return mockAssigner;
    }

    static <T> WindowAssigner<T, GlobalWindow> mockGlobalWindowAssigner() throws Exception {
        WindowAssigner mockAssigner = (WindowAssigner)Mockito.mock(WindowAssigner.class);
        Mockito.when((Object)mockAssigner.getWindowSerializer((ExecutionConfig)Mockito.any())).thenReturn((Object)new GlobalWindow.Serializer());
        Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)true);
        Mockito.when((Object)mockAssigner.assignWindows(Mockito.any(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(GlobalWindow.get()));
        return mockAssigner;
    }

    static <T> MergingWindowAssigner<T, TimeWindow> mockMergingAssigner() throws Exception {
        MergingWindowAssigner mockAssigner = (MergingWindowAssigner)Mockito.mock(MergingWindowAssigner.class);
        Mockito.when((Object)mockAssigner.getWindowSerializer((ExecutionConfig)Mockito.any())).thenReturn((Object)new TimeWindow.Serializer());
        Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)true);
        return mockAssigner;
    }

    static WindowAssigner.WindowAssignerContext anyAssignerContext() {
        return (WindowAssigner.WindowAssignerContext)Mockito.any();
    }

    static Trigger.TriggerContext anyTriggerContext() {
        return (Trigger.TriggerContext)Mockito.any();
    }

    static <T> Collector<T> anyCollector() {
        return (Collector)Mockito.any();
    }

    static Iterable<Integer> anyIntIterable() {
        return (Iterable)Mockito.any();
    }

    static Iterable<Integer> intIterable(Integer ... values) {
        return (Iterable)MockitoHamcrest.argThat((Matcher)org.hamcrest.Matchers.contains((Object[])values));
    }

    static TimeWindow anyTimeWindow() {
        return (TimeWindow)Mockito.any();
    }

    static InternalWindowFunction.InternalWindowContext anyInternalWindowContext() {
        return (InternalWindowFunction.InternalWindowContext)Mockito.any();
    }

    static Trigger.OnMergeContext anyOnMergeContext() {
        return (Trigger.OnMergeContext)Mockito.any();
    }

    static MergingWindowAssigner.MergeCallback anyMergeCallback() {
        return (MergingWindowAssigner.MergeCallback)Mockito.any();
    }

    static <T> void shouldRegisterEventTimeTimerOnElement(Trigger<T, TimeWindow> mockTrigger, final long timestamp) throws Exception {
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(timestamp);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
    }

    private static <T> void shouldDeleteEventTimeTimerOnElement(Trigger<T, TimeWindow> mockTrigger, final long timestamp) throws Exception {
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.deleteEventTimeTimer(timestamp);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
    }

    private static <T> void shouldRegisterProcessingTimeTimerOnElement(Trigger<T, TimeWindow> mockTrigger, final long timestamp) throws Exception {
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerProcessingTimeTimer(timestamp);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
    }

    private static <T> void shouldDeleteProcessingTimeTimerOnElement(Trigger<T, TimeWindow> mockTrigger, final long timestamp) throws Exception {
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.deleteProcessingTimeTimer(timestamp);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
    }

    private static <T, W extends Window> void shouldMergeWindows(MergingWindowAssigner<T, W> assigner, final Collection<? extends W> expectedWindows, final Collection<W> toMerge, final W mergeResult) {
        ((MergingWindowAssigner)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Collection windows = (Collection)invocation.getArguments()[0];
                MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)invocation.getArguments()[1];
                Assertions.assertThat((Collection)windows).containsExactlyInAnyOrderElementsOf((Iterable)expectedWindows);
                callback.merge(toMerge, (Object)mergeResult);
                return null;
            }
        }).when(assigner)).mergeWindows(Matchers.anyCollection(), (MergingWindowAssigner.MergeCallback)Matchers.anyObject());
    }

    private static <T> void shouldContinueOnElement(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
    }

    private static <T> void shouldFireOnElement(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
    }

    private static <T> void shouldPurgeOnElement(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
    }

    private static <T> void shouldFireAndPurgeOnElement(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
    }

    private static <T> void shouldContinueOnEventTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
    }

    private static <T> void shouldFireOnEventTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
    }

    private static <T> void shouldPurgeOnEventTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
    }

    private static <T> void shouldFireAndPurgeOnEventTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
    }

    private static <T> void shouldContinueOnProcessingTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
    }

    private static <T> void shouldFireOnProcessingTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
    }

    private static <T> void shouldPurgeOnProcessingTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
    }

    private static <T> void shouldFireAndPurgeOnProcessingTime(Trigger<T, TimeWindow> mockTrigger) throws Exception {
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
    }

    @Test
    void testNoLateSideOutputForSkippedWindows() throws Exception {
        OutputTag<Integer> lateOutputTag = new OutputTag<Integer>("late"){};
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction, lateOutputTag);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.emptyList());
        testHarness.processWatermark(0L);
        testHarness.processElement(new StreamRecord((Object)0, 5L));
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)1))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)5L), WindowOperatorContractTest.anyAssignerContext());
        Assertions.assertThat(testHarness.getSideOutput(lateOutputTag)).satisfiesAnyOf(new ThrowingConsumer[]{o -> Assertions.assertThat((Collection)o).isNull(), o -> Assertions.assertThat((Collection)o).isEmpty()});
    }

    @Test
    void testLateSideOutput() throws Exception {
        OutputTag<Integer> lateOutputTag = new OutputTag<Integer>("late"){};
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction, lateOutputTag);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 0L)));
        testHarness.processWatermark(20L);
        testHarness.processElement(new StreamRecord((Object)0, 5L));
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)1))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)5L), WindowOperatorContractTest.anyAssignerContext());
        Assertions.assertThat(testHarness.getSideOutput(lateOutputTag)).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains(StreamRecordMatchers.streamRecord(0, 5L))));
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.emptyList());
        testHarness.processElement(new StreamRecord((Object)0, 10L));
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)1))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)5L), WindowOperatorContractTest.anyAssignerContext());
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)1))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)10L), WindowOperatorContractTest.anyAssignerContext());
        Assertions.assertThat(testHarness.getSideOutput(lateOutputTag)).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{StreamRecordMatchers.streamRecord(0, 5L), StreamRecordMatchers.streamRecord(0, 10L)})));
    }

    @Test
    void testSideOutput() throws Exception {
        OutputTag<Integer> integerOutputTag = new OutputTag<Integer>("int-out"){};
        OutputTag<Long> longOutputTag = new OutputTag<Long>("long-out"){};
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction<Iterable<Integer>, Void, Integer, TimeWindow> windowFunction = new InternalWindowFunction<Iterable<Integer>, Void, Integer, TimeWindow>((OutputTag)integerOutputTag, (OutputTag)longOutputTag){
            final /* synthetic */ OutputTag val$integerOutputTag;
            final /* synthetic */ OutputTag val$longOutputTag;
            {
                this.val$integerOutputTag = outputTag;
                this.val$longOutputTag = outputTag2;
            }

            public void process(Integer integer, TimeWindow window, InternalWindowFunction.InternalWindowContext ctx, Iterable<Integer> input, Collector<Void> out) throws Exception {
                Integer inputValue = input.iterator().next();
                ctx.output(this.val$integerOutputTag, (Object)inputValue);
                ctx.output(this.val$longOutputTag, (Object)inputValue.longValue());
            }

            public void clear(TimeWindow window, InternalWindowFunction.InternalWindowContext context) throws Exception {
            }
        };
        KeyedOneInputStreamOperatorTestHarness<Integer, Integer, Void> testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, windowFunction);
        testHarness.open();
        long windowEnd = 42L;
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 42L)));
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)17, 5L));
        Assertions.assertThat(testHarness.getSideOutput(integerOutputTag)).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains(StreamRecordMatchers.streamRecord(17, 41L))));
        Assertions.assertThat(testHarness.getSideOutput(longOutputTag)).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains(StreamRecordMatchers.streamRecord(17L, 41L))));
    }

    @Test
    void testAssignerIsInvokedOncePerElement() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 0L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)1))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)0L), WindowOperatorContractTest.anyAssignerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((WindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)2))).assignWindows((Object)Matchers.eq((int)0), Matchers.eq((long)0L), WindowOperatorContractTest.anyAssignerContext());
    }

    @Test
    void testAssignerWithMultipleWindows() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
    }

    @Test
    void testWindowsDontInterfere() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 2L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 1L)));
        testHarness.processElement(new StreamRecord((Object)1, 0L));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(2);
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 1L)));
        testHarness.processElement(new StreamRecord((Object)1, 0L));
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 2L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0, 0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)1), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 1L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(1, 1), WindowOperatorContractTest.anyCollector());
    }

    @Test
    void testOnElementCalledPerWindow() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        testHarness.processElement(new StreamRecord((Object)42, 1L));
        ((Trigger)Mockito.verify(mockTrigger)).onElement((Object)Matchers.eq((int)42), Matchers.eq((long)1L), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.verify(mockTrigger)).onElement((Object)Matchers.eq((int)42), Matchers.eq((long)1L), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)2))).onElement((Object)Matchers.anyInt(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
    }

    @Test
    void testEmittingFromWindowFunction() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 2L)));
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                return TriggerResult.FIRE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Exception {
                Collector out = (Collector)invocation.getArgument(4);
                out.collect((Object)"Hallo");
                out.collect((Object)"Ciao");
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{StreamRecordMatchers.streamRecord("Hallo", 1L), StreamRecordMatchers.streamRecord("Ciao", 1L)})));
    }

    @Test
    void testEmittingFromWindowFunctionOnEventTime() throws Exception {
        this.testEmittingFromWindowFunction(new EventTimeAdaptor());
    }

    @Test
    void testEmittingFromWindowFunctionOnProcessingTime() throws Exception {
        this.testEmittingFromWindowFunction(new ProcessingTimeAdaptor());
    }

    private void testEmittingFromWindowFunction(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Collections.singletonList(new TimeWindow(0L, 2L)));
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Exception {
                Collector out = (Collector)invocation.getArgument(4);
                out.collect((Object)"Hallo");
                out.collect((Object)"Ciao");
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 1L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.never())).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        timeAdaptor.shouldFireOnTime(mockTrigger);
        timeAdaptor.advanceTime(testHarness, 1L);
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).is((Condition)HamcrestCondition.matching((Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{StreamRecordMatchers.streamRecord("Hallo", 1L), StreamRecordMatchers.streamRecord("Ciao", 1L)})));
    }

    @Test
    void testOnElementContinue() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                TimeWindow window = (TimeWindow)invocation.getArguments()[2];
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(window.getEnd());
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testOnElementFire() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                TimeWindow window = (TimeWindow)invocation.getArguments()[2];
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(window.getEnd());
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.FIRE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
    }

    @Test
    void testOnElementFireAndPurge() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                TimeWindow window = (TimeWindow)invocation.getArguments()[2];
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(window.getEnd());
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.FIRE_AND_PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
    }

    @Test
    void testOnElementPurge() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testOnEventTimeContinue() throws Exception {
        this.testOnTimeContinue(new EventTimeAdaptor());
    }

    @Test
    void testOnProcessingTimeContinue() throws Exception {
        this.testOnTimeContinue(new ProcessingTimeAdaptor());
    }

    private void testOnTimeContinue(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.shouldContinueOnTime(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        timeAdaptor.advanceTime(testHarness, 0L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
    }

    @Test
    void testOnEventTimeFire() throws Exception {
        this.testOnTimeFire(new EventTimeAdaptor());
    }

    @Test
    void testOnProcessingTimeFire() throws Exception {
        this.testOnTimeFire(new ProcessingTimeAdaptor());
    }

    private void testOnTimeFire(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.shouldFireOnTime(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        timeAdaptor.advanceTime(testHarness, 0L);
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
    }

    @Test
    void testOnEventTimeFireAndPurge() throws Exception {
        this.testOnTimeFireAndPurge(new EventTimeAdaptor());
    }

    @Test
    void testOnProcessingTimeFireAndPurge() throws Exception {
        this.testOnTimeFireAndPurge(new ProcessingTimeAdaptor());
    }

    private void testOnTimeFireAndPurge(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.shouldFireAndPurgeOnTime(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        timeAdaptor.advanceTime(testHarness, 0L);
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
    }

    @Test
    void testOnEventTimePurge() throws Exception {
        this.testOnTimePurge(new EventTimeAdaptor());
    }

    @Test
    void testOnProcessingTimePurge() throws Exception {
        this.testOnTimePurge(new ProcessingTimeAdaptor());
    }

    private void testOnTimePurge(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(4L, 6L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 1L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.shouldPurgeOnTime(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        timeAdaptor.advanceTime(testHarness, 1L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
    }

    @Test
    void testNoEventTimeFiringForPurgedWindow() throws Exception {
        this.testNoTimerFiringForPurgedWindow(new EventTimeAdaptor());
    }

    @Test
    void testNoProcessingTimeFiringForPurgedWindow() throws Exception {
        this.testNoTimerFiringForPurgedWindow(new ProcessingTimeAdaptor());
    }

    private void testNoTimerFiringForPurgedWindow(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = (InternalWindowFunction)Mockito.mock(InternalWindowFunction.class);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.advanceTime(testHarness, 0L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        ((InternalWindowFunction)Mockito.verify((Object)mockWindowFunction, (VerificationMode)Mockito.never())).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
    }

    @Test
    void testNoEventTimeFiringForPurgedMergingWindow() throws Exception {
        this.testNoTimerFiringForPurgedMergingWindow(new EventTimeAdaptor());
    }

    @Test
    void testNoProcessingTimeFiringForPurgedMergingWindow() throws Exception {
        this.testNoTimerFiringForPurgedMergingWindow(new ProcessingTimeAdaptor());
    }

    private void testNoTimerFiringForPurgedMergingWindow(final TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = (InternalWindowFunction)Mockito.mock(InternalWindowFunction.class);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.advanceTime(testHarness, 0L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        ((InternalWindowFunction)Mockito.verify((Object)mockWindowFunction, (VerificationMode)Mockito.never())).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
    }

    @Test
    void testNoEventTimeFiringForGarbageCollectedMergingWindow() throws Exception {
        this.testNoTimerFiringForGarbageCollectedMergingWindow(new EventTimeAdaptor());
    }

    @Test
    void testNoProcessingTimeFiringForGarbageCollectedMergingWindow() throws Exception {
        this.testNoTimerFiringForGarbageCollectedMergingWindow(new ProcessingTimeAdaptor());
    }

    private void testNoTimerFiringForGarbageCollectedMergingWindow(final TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = (InternalWindowFunction)Mockito.mock(InternalWindowFunction.class);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L)));
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 10L);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.shouldContinueOnTime(mockTrigger);
        timeAdaptor.advanceTime(testHarness, 4L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        ((InternalWindowFunction)Mockito.verify((Object)mockWindowFunction, (VerificationMode)Mockito.never())).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        timeAdaptor.advanceTime(testHarness, 10L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
    }

    @Test
    void testEventTimeTimerCreationAndDeletion() throws Exception {
        this.testTimerCreationAndDeletion(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeTimerCreationAndDeletion() throws Exception {
        this.testTimerCreationAndDeletion(new ProcessingTimeAdaptor());
    }

    private void testTimerCreationAndDeletion(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 17L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 42L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(3);
        timeAdaptor.shouldDeleteTimerOnElement(mockTrigger, 42L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        timeAdaptor.shouldDeleteTimerOnElement(mockTrigger, 17L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
    }

    @Test
    void testEventTimeTimerFiring() throws Exception {
        this.testTimerFiring(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeTimerFiring() throws Exception {
        this.testTimerFiring(new ProcessingTimeAdaptor());
    }

    private void testTimerFiring(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 100L)));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 1L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 17L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 42L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        timeAdaptor.advanceTime(testHarness, 1L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.atLeastOnce(), 1L, new TimeWindow(0L, 100L));
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(3);
        timeAdaptor.advanceTime(testHarness, 15L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        timeAdaptor.advanceTime(testHarness, 42L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.atLeastOnce(), 17L, new TimeWindow(0L, 100L));
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.atLeastOnce(), 42L, new TimeWindow(0L, 100L));
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)3), null, null);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
    }

    @Test
    void testEventTimeDeletedTimerDoesNotFire() throws Exception {
        this.testDeletedTimerDoesNotFire(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeDeletedTimerDoesNotFire() throws Exception {
        this.testDeletedTimerDoesNotFire(new ProcessingTimeAdaptor());
    }

    private void testDeletedTimerDoesNotFire(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 100L)));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 1L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.shouldDeleteTimerOnElement(mockTrigger, 1L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 2L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        timeAdaptor.advanceTime(testHarness, 50L);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)0), 1L, null);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), 2L, new TimeWindow(0L, 100L));
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
    }

    @Test
    void testMergeWindowsIsCalled() throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((MergingWindowAssigner)Mockito.verify(mockAssigner)).mergeWindows((Collection)Matchers.eq(Collections.singletonList(new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyMergeCallback());
        ((MergingWindowAssigner)Mockito.verify(mockAssigner)).mergeWindows((Collection)Matchers.eq(Collections.singletonList(new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyMergeCallback());
        ((MergingWindowAssigner)Mockito.verify(mockAssigner, (VerificationMode)Mockito.times((int)2))).mergeWindows(Matchers.anyCollection(), WindowOperatorContractTest.anyMergeCallback());
    }

    @Test
    void testEventTimeWindowsAreMergedEagerly() throws Exception {
        this.testWindowsAreMergedEagerly(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeWindowsAreMergedEagerly() throws Exception {
        this.testWindowsAreMergedEagerly(new ProcessingTimeAdaptor());
    }

    private void testWindowsAreMergedEagerly(final TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.OnMergeContext context = (Trigger.OnMergeContext)invocation.getArguments()[1];
                timeAdaptor.registerTimer((Trigger.TriggerContext)context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onMerge((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyOnMergeContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                timeAdaptor.deleteTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(3);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L)));
        WindowOperatorContractTest.shouldMergeWindows(mockAssigner, new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 2L), new TimeWindow(2L, 4L))), new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 2L), new TimeWindow(2L, 4L))), new TimeWindow(0L, 4L));
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger)).onMerge((Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 4L))), WindowOperatorContractTest.anyOnMergeContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(3);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
    }

    @Test
    void testRejectShrinkingMergingEventTimeWindows() throws Exception {
        this.testRejectShrinkingMergingWindows(new EventTimeAdaptor());
    }

    @Test
    void testRejectShrinkingMergingProcessingTimeWindows() throws Exception {
        this.testRejectShrinkingMergingWindows(new ProcessingTimeAdaptor());
    }

    void testRejectShrinkingMergingWindows(TimeDomainAdaptor timeAdaptor) throws Exception {
        int allowedLateness = 10;
        if (timeAdaptor instanceof ProcessingTimeAdaptor) {
            allowedLateness = 0;
        }
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, allowedLateness, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, 0L);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 22L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 25L)));
        timeAdaptor.advanceTime(testHarness, 20L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        WindowOperatorContractTest.shouldMergeWindows(mockAssigner, new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 22L), new TimeWindow(0L, 25L))), new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 22L), new TimeWindow(0L, 25L))), new TimeWindow(0L, (long)(20 - allowedLateness + 2)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 25L)));
        WindowOperatorContractTest.shouldMergeWindows(mockAssigner, new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, (long)(20 - allowedLateness + 2)), new TimeWindow(0L, 25L))), new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, (long)(20 - allowedLateness + 2)), new TimeWindow(0L, 25L))), new TimeWindow(0L, (long)(20 - allowedLateness + 1)));
        Assertions.assertThatThrownBy(() -> testHarness.processElement(new StreamRecord((Object)0, 0L))).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testMergingOfExistingEventTimeWindows() throws Exception {
        this.testMergingOfExistingWindows(new EventTimeAdaptor());
    }

    @Test
    void testMergingOfExistingProcessingTimeWindows() throws Exception {
        this.testMergingOfExistingWindows(new ProcessingTimeAdaptor());
    }

    private void testMergingOfExistingWindows(final TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        timeAdaptor.advanceTime(testHarness, Long.MIN_VALUE);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.OnMergeContext context = (Trigger.OnMergeContext)invocation.getArguments()[1];
                timeAdaptor.registerTimer((Trigger.TriggerContext)context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onMerge((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyOnMergeContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                timeAdaptor.deleteTimer(context, 0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(3);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L)));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(5);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(4);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(1L, 3L)));
        WindowOperatorContractTest.shouldMergeWindows(mockAssigner, new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 2L), new TimeWindow(2L, 4L), new TimeWindow(1L, 3L))), new ArrayList<TimeWindow>(Arrays.asList(new TimeWindow(0L, 2L), new TimeWindow(2L, 4L), new TimeWindow(1L, 3L))), new TimeWindow(0L, 4L));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(3);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
    }

    @Test
    void testOnElementPurgeDoesNotCleanupMergingSet() throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isOne();
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testOnEventTimePurgeDoesNotCleanupMergingSet() throws Exception {
        this.testOnTimePurgeDoesNotCleanupMergingSet(new EventTimeAdaptor());
    }

    @Test
    void testOnProcessingTimePurgeDoesNotCleanupMergingSet() throws Exception {
        this.testOnTimePurgeDoesNotCleanupMergingSet(new ProcessingTimeAdaptor());
    }

    private void testOnTimePurgeDoesNotCleanupMergingSet(TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 4L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        timeAdaptor.shouldRegisterTimerOnElement(mockTrigger, 1L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        timeAdaptor.shouldPurgeOnTime(mockTrigger);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        timeAdaptor.advanceTime(testHarness, 1L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
    }

    @Test
    void testNoEventTimeGarbageCollectionTimerForGlobalWindow() throws Exception {
        this.testNoGarbageCollectionTimerForGlobalWindow(new EventTimeAdaptor());
    }

    @Test
    void testNoProcessingTimeGarbageCollectionTimerForGlobalWindow() throws Exception {
        this.testNoGarbageCollectionTimerForGlobalWindow(new ProcessingTimeAdaptor());
    }

    private void testNoGarbageCollectionTimerForGlobalWindow(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockGlobalWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        Assertions.assertThat((long)GlobalWindow.get().maxTimestamp()).isEqualTo(Long.MAX_VALUE);
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
    }

    @Test
    void testNoEventTimeGarbageCollectionTimerForLongMax() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 0x7FFFFFFFFFFFFFF5L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
    }

    @Test
    void testProcessingTimeGarbageCollectionTimerIsAlwaysWindowMaxTimestamp() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)false);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 0x7FFFFFFFFFFFFFF5L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.setProcessingTime(0x7FFFFFFFFFFFFFF5L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
    }

    @Test
    void testEventTimeGarbageCollectionTimer() throws Exception {
        this.testGarbageCollectionTimer(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeGarbageCollectionTimer() throws Exception {
        this.testGarbageCollectionTimer(new ProcessingTimeAdaptor());
    }

    private void testGarbageCollectionTimer(TimeDomainAdaptor timeAdaptor) throws Exception {
        long allowedLateness = 20L;
        if (timeAdaptor instanceof ProcessingTimeAdaptor) {
            allowedLateness = 0L;
        }
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, allowedLateness, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.shouldFireOnTime(mockTrigger);
        timeAdaptor.advanceTime(testHarness, 19L + allowedLateness);
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), 19L + allowedLateness, null);
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 20L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
    }

    @Test
    void testEventTimeTriggerTimerAndGarbageCollectionTimerCoincide() throws Exception {
        this.testTriggerTimerAndGarbageCollectionTimerCoincide(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeTriggerTimerAndGarbageCollectionTimerCoincide() throws Exception {
        this.testTriggerTimerAndGarbageCollectionTimerCoincide(new ProcessingTimeAdaptor());
    }

    private void testTriggerTimerAndGarbageCollectionTimerCoincide(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 0L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 19L);
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.advanceTime(testHarness, 19L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        timeAdaptor.verifyTriggerCallback(mockTrigger, Mockito.times((int)1), null, null);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
    }

    @Test
    void testStateAndTimerCleanupAtEventTimeGarbageCollection() throws Exception {
        this.testStateAndTimerCleanupAtEventTimeGarbageCollection(new EventTimeAdaptor());
    }

    @Test
    void testStateAndTimerCleanupAtProcessingTimeGarbageCollection() throws Exception {
        this.testStateAndTimerCleanupAtEventTimeGarbageCollection(new ProcessingTimeAdaptor());
    }

    private void testStateAndTimerCleanupAtEventTimeGarbageCollection(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                timeAdaptor.deleteTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
        timeAdaptor.advanceTime(testHarness, 39L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
    }

    @Test
    void testStateAndTimerCleanupAtEventTimeGarbageCollectionWithPurgingTrigger() throws Exception {
        this.testStateAndTimerCleanupAtEventTimeGCWithPurgingTrigger(new EventTimeAdaptor());
    }

    @Test
    void testStateAndTimerCleanupAtProcessingTimeGarbageCollectionWithPurgingTrigger() throws Exception {
        this.testStateAndTimerCleanupAtEventTimeGCWithPurgingTrigger(new ProcessingTimeAdaptor());
    }

    private void testStateAndTimerCleanupAtEventTimeGCWithPurgingTrigger(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                timeAdaptor.deleteTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
        timeAdaptor.advanceTime(testHarness, 39L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
    }

    @Test
    void testStateAndTimerCleanupAtEventTimeGarbageCollectionWithPurgingTriggerAndMergingWindows() throws Exception {
        this.testStateAndTimerCleanupAtGarbageCollectionWithPurgingTriggerAndMergingWindows(new EventTimeAdaptor());
    }

    @Test
    void testStateAndTimerCleanupAtProcessingTimeGarbageCollectionWithPurgingTriggerAndMergingWindows() throws Exception {
        this.testStateAndTimerCleanupAtGarbageCollectionWithPurgingTriggerAndMergingWindows(new ProcessingTimeAdaptor());
    }

    private void testStateAndTimerCleanupAtGarbageCollectionWithPurgingTriggerAndMergingWindows(final TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 20L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                timeAdaptor.registerTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.PURGE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                timeAdaptor.deleteTimer(context, 1000L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
        timeAdaptor.advanceTime(testHarness, 39L);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimersOtherDomain(testHarness)).isZero();
    }

    @Test
    void testMergingWindowSetClearedAtEventTimeGarbageCollection() throws Exception {
        this.testMergingWindowSetClearedAtGarbageCollection(new EventTimeAdaptor());
    }

    @Test
    void testMergingWindowSetClearedAtProcessingTimeGarbageCollection() throws Exception {
        this.testMergingWindowSetClearedAtGarbageCollection(new ProcessingTimeAdaptor());
    }

    private void testMergingWindowSetClearedAtGarbageCollection(TimeDomainAdaptor timeAdaptor) throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        timeAdaptor.setIsEventTime((WindowAssigner<?, ?>)mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 20L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        timeAdaptor.advanceTime(testHarness, 39L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
    }

    @Test
    void testProcessingElementsWithinAllowedLateness() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        testHarness.processWatermark(new Watermark(20L));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isOne();
    }

    @Test
    void testLateWindowDropping() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        testHarness.processWatermark(new Watermark(21L));
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
    }

    @Test
    void testStateSnapshotAndRestore() throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(2L, 4L), new TimeWindow(0L, 2L)));
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).update((Object)"hello");
                return TriggerResult.CONTINUE;
            }
        }).when(mockTrigger)).onElement((Object)((Integer)Matchers.anyObject()), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        WindowOperatorContractTest.shouldFireAndPurgeOnEventTime(mockTrigger);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(5);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        mockTrigger = WindowOperatorContractTest.mockTrigger();
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[1];
                context.deleteEventTimeTimer(0L);
                ((ValueState)context.getPartitionedState(valueStateDescriptor)).clear();
                return null;
            }
        }).when(mockTrigger)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.eq((long)0L), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 0L, (InternalWindowFunction)mockWindowFunction);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        Assertions.assertThat(testHarness.extractOutputStreamRecords()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(5);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.never())).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processWatermark(new Watermark(20L));
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)2))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)2))).process((Object)Matchers.eq((int)0), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.eq((int)0), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.intIterable(0), WindowOperatorContractTest.anyCollector());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)4))).onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).onEventTime(Matchers.eq((long)0L), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(0L, 2L))), WindowOperatorContractTest.anyTriggerContext());
        ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)Mockito.times((int)1))).onEventTime(Matchers.eq((long)0L), (Window)((TimeWindow)Matchers.eq((Object)new TimeWindow(2L, 4L))), WindowOperatorContractTest.anyTriggerContext());
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testPerWindowStateSetAndClearedOnEventTimePurge() throws Exception {
        this.testPerWindowStateSetAndClearedOnPurge(new EventTimeAdaptor());
    }

    @Test
    void testPerWindowStateSetAndClearedOnProcessingTimePurge() throws Exception {
        this.testPerWindowStateSetAndClearedOnPurge(new ProcessingTimeAdaptor());
    }

    public void testPerWindowStateSetAndClearedOnPurge(TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockTrigger.onElement((Object)Matchers.anyInt(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[2];
                context.windowState().getState(valueStateDescriptor).update((Object)"hello");
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[1];
                context.windowState().getState(valueStateDescriptor).clear();
                return null;
            }
        }).when(mockWindowFunction)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext());
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isOne();
        timeAdaptor.advanceTime(testHarness, 39L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isZero();
        Assertions.assertThat((int)timeAdaptor.numTimers(testHarness)).isZero();
    }

    @Test
    void testWindowStateNotAvailableToMergingWindows() throws Exception {
        MergingWindowAssigner mockAssigner = WindowOperatorContractTest.mockMergingAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator((WindowAssigner)mockAssigner, (Trigger)mockTrigger, 20L, (InternalWindowFunction)mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockTrigger.onElement((Object)Matchers.anyInt(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[2];
                context.windowState().getState(valueStateDescriptor).update((Object)"hello");
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testHarness.processElement(new StreamRecord((Object)0, 0L))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Per-window state is not allowed when using merging windows.");
    }

    @Test
    void testEventTimeQuerying() throws Exception {
        this.testCurrentTimeQuerying(new EventTimeAdaptor());
    }

    @Test
    void testProcessingTimeQuerying() throws Exception {
        this.testCurrentTimeQuerying(new ProcessingTimeAdaptor());
    }

    @Test
    void testStateTypeIsConsistentFromWindowStateAndGlobalState() throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        Mockito.when((Object)mockTrigger.onElement((Object)Matchers.anyInt(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        final AtomicBoolean processWasInvoked = new AtomicBoolean(false);
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[2];
                KeyedStateStore windowKeyedStateStore = context.windowState();
                KeyedStateStore globalKeyedStateStore = context.globalState();
                ListStateDescriptor windowListStateDescriptor = new ListStateDescriptor("windowListState", String.class);
                ListStateDescriptor globalListStateDescriptor = new ListStateDescriptor("globalListState", String.class);
                Assertions.assertThat((Object)windowKeyedStateStore.getListState(windowListStateDescriptor)).hasSameClassAs((Object)globalKeyedStateStore.getListState(globalListStateDescriptor));
                ValueStateDescriptor windowValueStateDescriptor = new ValueStateDescriptor("windowValueState", String.class);
                ValueStateDescriptor globalValueStateDescriptor = new ValueStateDescriptor("globalValueState", String.class);
                Assertions.assertThat((Object)windowKeyedStateStore.getState(windowValueStateDescriptor)).hasSameClassAs((Object)globalKeyedStateStore.getState(globalValueStateDescriptor));
                class NoOpAggregateFunction
                implements AggregateFunction<String, String, String> {
                    NoOpAggregateFunction() {
                    }

                    public String createAccumulator() {
                        return null;
                    }

                    public String add(String value, String accumulator) {
                        return null;
                    }

                    public String getResult(String accumulator) {
                        return null;
                    }

                    public String merge(String a, String b) {
                        return null;
                    }
                }
                AggregatingStateDescriptor windowAggStateDesc = new AggregatingStateDescriptor("windowAgg", (AggregateFunction)new NoOpAggregateFunction(), String.class);
                AggregatingStateDescriptor globalAggStateDesc = new AggregatingStateDescriptor("globalAgg", (AggregateFunction)new NoOpAggregateFunction(), String.class);
                Assertions.assertThat((Object)windowKeyedStateStore.getAggregatingState(windowAggStateDesc)).hasSameClassAs((Object)globalKeyedStateStore.getAggregatingState(globalAggStateDesc));
                ReducingStateDescriptor windowReducingStateDesc = new ReducingStateDescriptor("windowReducing", (ReduceFunction & Serializable)(a, b) -> a, String.class);
                ReducingStateDescriptor globalReducingStateDesc = new ReducingStateDescriptor("globalReducing", (ReduceFunction & Serializable)(a, b) -> a, String.class);
                Assertions.assertThat((Object)windowKeyedStateStore.getReducingState(windowReducingStateDesc)).hasSameClassAs((Object)globalKeyedStateStore.getReducingState(globalReducingStateDesc));
                MapStateDescriptor windowMapStateDescriptor = new MapStateDescriptor("windowMapState", String.class, String.class);
                MapStateDescriptor globalMapStateDescriptor = new MapStateDescriptor("globalMapState", String.class, String.class);
                Assertions.assertThat((Object)windowKeyedStateStore.getMapState(windowMapStateDescriptor)).hasSameClassAs((Object)globalKeyedStateStore.getMapState(globalMapStateDescriptor));
                processWasInvoked.set(true);
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        Assertions.assertThat((AtomicBoolean)processWasInvoked).isTrue();
    }

    public void testCurrentTimeQuerying(final TimeDomainAdaptor timeAdaptor) throws Exception {
        WindowAssigner mockAssigner = WindowOperatorContractTest.mockTimeWindowAssigner();
        timeAdaptor.setIsEventTime(mockAssigner);
        Trigger mockTrigger = WindowOperatorContractTest.mockTrigger();
        InternalWindowFunction mockWindowFunction = WindowOperatorContractTest.mockWindowFunction();
        final KeyedOneInputStreamOperatorTestHarness testHarness = this.createWindowOperator(mockAssigner, mockTrigger, 20L, mockWindowFunction);
        testHarness.open();
        WindowOperatorContractTest.shouldFireOnElement(mockTrigger);
        Mockito.when((Object)mockAssigner.assignWindows((Object)Matchers.anyInt(), Matchers.anyLong(), WindowOperatorContractTest.anyAssignerContext())).thenReturn(Arrays.asList(new TimeWindow(0L, 20L)));
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[2];
                timeAdaptor.verifyCorrectTime(testHarness, context);
                return null;
            }
        }).when(mockWindowFunction)).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        ((InternalWindowFunction)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InternalWindowFunction.InternalWindowContext context = (InternalWindowFunction.InternalWindowContext)invocationOnMock.getArguments()[1];
                timeAdaptor.verifyCorrectTime(testHarness, context);
                return null;
            }
        }).when(mockWindowFunction)).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext());
        timeAdaptor.advanceTime(testHarness, 10L);
        testHarness.processElement(new StreamRecord((Object)0, 0L));
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).process((Object)Matchers.anyInt(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext(), WindowOperatorContractTest.anyIntIterable(), WindowOperatorContractTest.anyCollector());
        timeAdaptor.advanceTime(testHarness, 100L);
        ((InternalWindowFunction)Mockito.verify(mockWindowFunction, (VerificationMode)Mockito.times((int)1))).clear((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyInternalWindowContext());
    }

    protected abstract <W extends Window, OUT> KeyedOneInputStreamOperatorTestHarness<Integer, Integer, OUT> createWindowOperator(WindowAssigner<Integer, W> var1, Trigger<Integer, W> var2, long var3, InternalWindowFunction<Iterable<Integer>, OUT, Integer, W> var5, OutputTag<Integer> var6) throws Exception;

    protected abstract <W extends Window, OUT> KeyedOneInputStreamOperatorTestHarness<Integer, Integer, OUT> createWindowOperator(WindowAssigner<Integer, W> var1, Trigger<Integer, W> var2, long var3, InternalWindowFunction<Iterable<Integer>, OUT, Integer, W> var5) throws Exception;

    private static class ProcessingTimeAdaptor
    implements TimeDomainAdaptor {
        private ProcessingTimeAdaptor() {
        }

        @Override
        public void setIsEventTime(WindowAssigner<?, ?> mockAssigner) {
            Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)false);
        }

        @Override
        public void advanceTime(OneInputStreamOperatorTestHarness testHarness, long timestamp) throws Exception {
            testHarness.setProcessingTime(timestamp);
        }

        @Override
        public void registerTimer(Trigger.TriggerContext ctx, long timestamp) {
            ctx.registerProcessingTimeTimer(timestamp);
        }

        @Override
        public void deleteTimer(Trigger.TriggerContext ctx, long timestamp) {
            ctx.deleteProcessingTimeTimer(timestamp);
        }

        @Override
        public int numTimers(AbstractStreamOperatorTestHarness testHarness) {
            return testHarness.numProcessingTimeTimers();
        }

        @Override
        public int numTimersOtherDomain(AbstractStreamOperatorTestHarness testHarness) {
            return testHarness.numEventTimeTimers();
        }

        @Override
        public void shouldRegisterTimerOnElement(Trigger<?, TimeWindow> mockTrigger, long timestamp) throws Exception {
            WindowOperatorContractTest.shouldRegisterProcessingTimeTimerOnElement(mockTrigger, timestamp);
        }

        @Override
        public void shouldDeleteTimerOnElement(Trigger<?, TimeWindow> mockTrigger, long timestamp) throws Exception {
            WindowOperatorContractTest.shouldDeleteProcessingTimeTimerOnElement(mockTrigger, timestamp);
        }

        @Override
        public void shouldContinueOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldContinueOnProcessingTime(mockTrigger);
        }

        @Override
        public void shouldFireOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldFireOnProcessingTime(mockTrigger);
        }

        @Override
        public void shouldFireAndPurgeOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldFireAndPurgeOnProcessingTime(mockTrigger);
        }

        @Override
        public void shouldPurgeOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldPurgeOnProcessingTime(mockTrigger);
        }

        @Override
        public void verifyTriggerCallback(Trigger<?, TimeWindow> mockTrigger, VerificationMode verificationMode, Long time, TimeWindow window) throws Exception {
            if (time == null && window == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
            } else if (time == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onProcessingTime(Matchers.anyLong(), (Window)((TimeWindow)Matchers.eq((Object)window)), WindowOperatorContractTest.anyTriggerContext());
            } else if (window == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onProcessingTime(((Long)Matchers.eq((Object)time)).longValue(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
            } else {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onProcessingTime(((Long)Matchers.eq((Object)time)).longValue(), (Window)((TimeWindow)Matchers.eq((Object)window)), WindowOperatorContractTest.anyTriggerContext());
            }
        }

        @Override
        public void verifyCorrectTime(OneInputStreamOperatorTestHarness testHarness, InternalWindowFunction.InternalWindowContext context) {
            Assertions.assertThat((long)context.currentProcessingTime()).isEqualTo(testHarness.getProcessingTime());
        }
    }

    private static class EventTimeAdaptor
    implements TimeDomainAdaptor {
        private EventTimeAdaptor() {
        }

        @Override
        public void setIsEventTime(WindowAssigner<?, ?> mockAssigner) {
            Mockito.when((Object)mockAssigner.isEventTime()).thenReturn((Object)true);
        }

        @Override
        public void advanceTime(OneInputStreamOperatorTestHarness testHarness, long timestamp) throws Exception {
            testHarness.processWatermark(new Watermark(timestamp));
        }

        @Override
        public void registerTimer(Trigger.TriggerContext ctx, long timestamp) {
            ctx.registerEventTimeTimer(timestamp);
        }

        @Override
        public void deleteTimer(Trigger.TriggerContext ctx, long timestamp) {
            ctx.deleteEventTimeTimer(timestamp);
        }

        @Override
        public int numTimers(AbstractStreamOperatorTestHarness testHarness) {
            return testHarness.numEventTimeTimers();
        }

        @Override
        public int numTimersOtherDomain(AbstractStreamOperatorTestHarness testHarness) {
            return testHarness.numProcessingTimeTimers();
        }

        @Override
        public void shouldRegisterTimerOnElement(Trigger<?, TimeWindow> mockTrigger, long timestamp) throws Exception {
            WindowOperatorContractTest.shouldRegisterEventTimeTimerOnElement(mockTrigger, timestamp);
        }

        @Override
        public void shouldDeleteTimerOnElement(Trigger<?, TimeWindow> mockTrigger, long timestamp) throws Exception {
            WindowOperatorContractTest.shouldDeleteEventTimeTimerOnElement(mockTrigger, timestamp);
        }

        @Override
        public void shouldContinueOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldContinueOnEventTime(mockTrigger);
        }

        @Override
        public void shouldFireOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldFireOnEventTime(mockTrigger);
        }

        @Override
        public void shouldFireAndPurgeOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldFireAndPurgeOnEventTime(mockTrigger);
        }

        @Override
        public void shouldPurgeOnTime(Trigger<?, TimeWindow> mockTrigger) throws Exception {
            WindowOperatorContractTest.shouldPurgeOnEventTime(mockTrigger);
        }

        @Override
        public void verifyTriggerCallback(Trigger<?, TimeWindow> mockTrigger, VerificationMode verificationMode, Long time, TimeWindow window) throws Exception {
            if (time == null && window == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
            } else if (time == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onEventTime(Matchers.anyLong(), (Window)((TimeWindow)Matchers.eq((Object)window)), WindowOperatorContractTest.anyTriggerContext());
            } else if (window == null) {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onEventTime(((Long)Matchers.eq((Object)time)).longValue(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
            } else {
                ((Trigger)Mockito.verify(mockTrigger, (VerificationMode)verificationMode)).onEventTime(((Long)Matchers.eq((Object)time)).longValue(), (Window)((TimeWindow)Matchers.eq((Object)window)), WindowOperatorContractTest.anyTriggerContext());
            }
        }

        @Override
        public void verifyCorrectTime(OneInputStreamOperatorTestHarness testHarness, InternalWindowFunction.InternalWindowContext context) {
            Assertions.assertThat((long)context.currentWatermark()).isEqualTo(testHarness.getCurrentWatermark());
        }
    }

    private static interface TimeDomainAdaptor {
        public void setIsEventTime(WindowAssigner<?, ?> var1);

        public void advanceTime(OneInputStreamOperatorTestHarness var1, long var2) throws Exception;

        public void registerTimer(Trigger.TriggerContext var1, long var2);

        public void deleteTimer(Trigger.TriggerContext var1, long var2);

        public int numTimers(AbstractStreamOperatorTestHarness var1);

        public int numTimersOtherDomain(AbstractStreamOperatorTestHarness var1);

        public void shouldRegisterTimerOnElement(Trigger<?, TimeWindow> var1, long var2) throws Exception;

        public void shouldDeleteTimerOnElement(Trigger<?, TimeWindow> var1, long var2) throws Exception;

        public void shouldContinueOnTime(Trigger<?, TimeWindow> var1) throws Exception;

        public void shouldFireOnTime(Trigger<?, TimeWindow> var1) throws Exception;

        public void shouldFireAndPurgeOnTime(Trigger<?, TimeWindow> var1) throws Exception;

        public void shouldPurgeOnTime(Trigger<?, TimeWindow> var1) throws Exception;

        public void verifyTriggerCallback(Trigger<?, TimeWindow> var1, VerificationMode var2, Long var3, TimeWindow var4) throws Exception;

        public void verifyCorrectTime(OneInputStreamOperatorTestHarness var1, InternalWindowFunction.InternalWindowContext var2);
    }
}

