/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;

public class MockStreamingRuntimeContext
extends StreamingRuntimeContext {
    private final boolean isCheckpointingEnabled;
    private final int numParallelSubtasks;
    private final int subtaskIndex;
    private final MockEnvironment environment;

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex) {
        this(isCheckpointingEnabled, numParallelSubtasks, subtaskIndex, new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).setParallelism(numParallelSubtasks).setMaxParallelism(numParallelSubtasks).setSubtaskIndex(subtaskIndex).build());
    }

    public MockStreamingRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex, MockEnvironment environment) {
        super((AbstractStreamOperator)new MockStreamOperator(), (Environment)environment, new HashMap());
        this.isCheckpointingEnabled = isCheckpointingEnabled;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
        this.environment = environment;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.environment.getExecutionConfig();
    }

    public OperatorMetricGroup getMetricGroup() {
        return UnregisteredMetricsGroup.createOperatorMetricGroup();
    }

    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    private static class MockStreamOperator
    extends AbstractStreamOperator<Integer> {
        private static final long serialVersionUID = -1153976702711944427L;
        private transient TestProcessingTimeService testProcessingTimeService;

        private MockStreamOperator() {
        }

        public ExecutionConfig getExecutionConfig() {
            return new ExecutionConfig();
        }

        public OperatorID getOperatorID() {
            return new OperatorID();
        }

        public ProcessingTimeService getProcessingTimeService() {
            if (this.testProcessingTimeService == null) {
                this.testProcessingTimeService = new TestProcessingTimeService();
            }
            return this.testProcessingTimeService;
        }
    }
}

