/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorThreadFactory.class);
    private static final String THREAD_NAME_PREFIX = "Flink Executor Thread - ";
    private static final AtomicInteger COUNTER = new AtomicInteger(1);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("Flink Executor Threads");
    private static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = new LoggingExceptionHander();
    public static final ExecutorThreadFactory INSTANCE = new ExecutorThreadFactory();

    private ExecutorThreadFactory() {
    }

    @Override
    public Thread newThread(Runnable target) {
        Thread t = new Thread(THREAD_GROUP, target, THREAD_NAME_PREFIX + COUNTER.getAndIncrement());
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
        return t;
    }

    private static final class LoggingExceptionHander
    implements Thread.UncaughtExceptionHandler {
        private LoggingExceptionHander() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Thread '" + t.getName() + "' produced an uncaught exception.", e);
            }
        }
    }
}

