/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.zookeeper.StateStorageHelper;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.flink.shaded.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.flink.shaded.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.flink.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.org.apache.curator.utils.ZKPaths;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStateHandleStore<T extends Serializable> {
    public static Logger LOG = LoggerFactory.getLogger(ZooKeeperStateHandleStore.class);
    private final CuratorFramework client;
    private final StateStorageHelper<T> storage;

    public ZooKeeperStateHandleStore(CuratorFramework client, StateStorageHelper storage) throws IOException {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"Curator client");
        this.storage = (StateStorageHelper)Preconditions.checkNotNull((Object)storage, (String)"State storage");
    }

    public StateHandle<T> add(String pathInZooKeeper, T state) throws Exception {
        return this.add(pathInZooKeeper, state, CreateMode.PERSISTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateHandle<T> add(String pathInZooKeeper, T state, CreateMode createMode) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull(state, (String)"State");
        StateHandle<T> stateHandle = this.storage.store(state);
        boolean success = false;
        try {
            byte[] serializedStateHandle = InstantiationUtil.serializeObject(stateHandle);
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(createMode)).forPath(pathInZooKeeper, serializedStateHandle);
            success = true;
            StateHandle<T> stateHandle2 = stateHandle;
            return stateHandle2;
        }
        finally {
            if (!success && stateHandle != null) {
                stateHandle.discardState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String pathInZooKeeper, int expectedVersion, T state) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull(state, (String)"State");
        StateHandle<T> oldStateHandle = this.get(pathInZooKeeper);
        StateHandle<T> stateHandle = this.storage.store(state);
        boolean success = false;
        try {
            byte[] serializedStateHandle = InstantiationUtil.serializeObject(stateHandle);
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(expectedVersion)).forPath(pathInZooKeeper, serializedStateHandle);
            success = true;
        }
        finally {
            if (success) {
                oldStateHandle.discardState();
            } else {
                stateHandle.discardState();
            }
        }
    }

    public int exists(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Stat stat = (Stat)this.client.checkExists().forPath(pathInZooKeeper);
        if (stat != null) {
            return stat.getVersion();
        }
        return -1;
    }

    public StateHandle<T> get(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        byte[] data = (byte[])this.client.getData().forPath(pathInZooKeeper);
        return (StateHandle)InstantiationUtil.deserializeObject((byte[])data, (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    public List<Tuple2<StateHandle<T>, String>> getAll() throws Exception {
        ArrayList<Tuple2<StateHandle<T>, String>> stateHandles = new ArrayList<Tuple2<StateHandle<T>, String>>();
        boolean success = false;
        block2: while (!success) {
            int initialCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            List children = (List)this.client.getChildren().forPath("/");
            for (String path : children) {
                path = "/" + path;
                try {
                    StateHandle<T> stateHandle = this.get(path);
                    stateHandles.add(new Tuple2(stateHandle, (Object)path));
                }
                catch (KeeperException.NoNodeException ignored) {
                    continue block2;
                }
            }
            int finalCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            success = initialCVersion == finalCVersion;
        }
        return stateHandles;
    }

    public List<Tuple2<StateHandle<T>, String>> getAllSortedByName() throws Exception {
        ArrayList<Tuple2<StateHandle<T>, String>> stateHandles = new ArrayList<Tuple2<StateHandle<T>, String>>();
        boolean success = false;
        block2: while (!success) {
            int initialCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            List<String> children = ZKPaths.getSortedChildren(this.client.getZookeeperClient().getZooKeeper(), ZKPaths.fixForNamespace(this.client.getNamespace(), "/"));
            for (String path : children) {
                path = "/" + path;
                try {
                    StateHandle<T> stateHandle = this.get(path);
                    stateHandles.add(new Tuple2(stateHandle, (Object)path));
                }
                catch (KeeperException.NoNodeException ignored) {
                    continue block2;
                }
            }
            int finalCVersion = ((Stat)this.client.checkExists().forPath("/")).getCversion();
            success = initialCVersion == finalCVersion;
        }
        return stateHandles;
    }

    public void remove(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        this.client.delete().deletingChildrenIfNeeded().forPath(pathInZooKeeper);
    }

    public void remove(String pathInZooKeeper, BackgroundCallback callback) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        Preconditions.checkNotNull((Object)callback, (String)"Background callback");
        ((Pathable)this.client.delete().deletingChildrenIfNeeded().inBackground(callback)).forPath(pathInZooKeeper);
    }

    public void removeAndDiscardState(String pathInZooKeeper) throws Exception {
        Preconditions.checkNotNull((Object)pathInZooKeeper, (String)"Path in ZooKeeper");
        StateHandle<T> stateHandle = this.get(pathInZooKeeper);
        this.client.delete().deletingChildrenIfNeeded().forPath(pathInZooKeeper);
        stateHandle.discardState();
    }

    public void removeAndDiscardAllState() throws Exception {
        List<Tuple2<StateHandle<T>, String>> allStateHandles = this.getAll();
        ZKPaths.deleteChildren(this.client.getZookeeperClient().getZooKeeper(), ZKPaths.fixForNamespace(this.client.getNamespace(), "/"), false);
        for (Tuple2<StateHandle<T>, String> stateHandleAndPath : allStateHandles) {
            ((StateHandle)stateHandleAndPath.f0).discardState();
        }
    }
}

