/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.standalone;

import akka.actor.ActorSelection;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;

public class StandaloneResourceManager
extends FlinkResourceManager<ResourceID> {
    public StandaloneResourceManager(Configuration flinkConfig, LeaderRetrievalService leaderRetriever) {
        super(0, flinkConfig, leaderRetriever);
    }

    @Override
    protected void triggerConnectingToJobManager(String leaderAddress) {
        ActorSelection jobManagerSel = this.context().actorSelection(leaderAddress);
        if (jobManagerSel.anchorPath().root().equals((Object)this.self().path().root())) {
            super.triggerConnectingToJobManager(leaderAddress);
        } else {
            this.LOG.info("Received leader address but not running in leader ActorSystem. Cancelling registration.");
        }
    }

    @Override
    protected void initialize() throws Exception {
    }

    @Override
    protected void shutdownApplication(ApplicationStatus finalStatus, String optionalDiagnostics) {
    }

    @Override
    protected void fatalError(String message, Throwable error) {
        this.LOG.error("FATAL ERROR IN RESOURCE MANAGER: " + message, error);
        System.exit(-13);
    }

    @Override
    protected Collection<ResourceID> reacceptRegisteredWorkers(Collection<ResourceID> toConsolidate) {
        return toConsolidate;
    }

    @Override
    protected void requestNewWorkers(int numWorkers) {
    }

    @Override
    protected ResourceID workerRegistered(ResourceID resourceID) {
        return resourceID;
    }

    @Override
    protected void releaseRegisteredWorker(ResourceID resourceID) {
    }

    @Override
    protected void releasePendingWorker(ResourceID resourceID) {
    }

    @Override
    protected int getNumWorkerRequestsPending() {
        return 0;
    }

    @Override
    protected int getNumWorkersPendingRegistration() {
        return 0;
    }

    @Override
    protected void handleMessage(Object message) {
        super.handleMessage(message);
    }
}

