/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;

class AggregatingStateChangeApplier<K, N, IN, SV, OUT>
extends KvStateChangeApplier<K, N> {
    private final InternalAggregatingState<K, N, IN, SV, OUT> state;

    protected AggregatingStateChangeApplier(InternalKeyContext<K> keyContext, InternalAggregatingState<K, N, IN, SV, OUT> state) {
        super(keyContext);
        this.state = state;
    }

    @Override
    protected InternalKvState<K, N, ?> getState() {
        return this.state;
    }

    @Override
    protected void applyInternal(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case SET: 
            case SET_INTERNAL: {
                this.state.updateInternal(this.state.getValueSerializer().deserialize(in));
                break;
            }
            case MERGE_NS: {
                AggregatingStateChangeApplier.applyMergeNamespaces(this.state, in);
                break;
            }
            case CLEAR: {
                this.state.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state change operation: " + operation);
            }
        }
    }
}

