/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.Executors;

public final class RocksDBStateDataTransferHelper
implements Closeable {
    private final ExecutorService executorService;
    private final Closeable closeable;

    public static RocksDBStateDataTransferHelper forThreadNum(int threadNum) {
        ExecutorService executorService = RocksDBStateDataTransferHelper.getExecutorService(threadNum);
        return new RocksDBStateDataTransferHelper(executorService, executorService::shutdownNow);
    }

    public static RocksDBStateDataTransferHelper forExecutor(ExecutorService executorService) {
        return new RocksDBStateDataTransferHelper(executorService, () -> {});
    }

    public static RocksDBStateDataTransferHelper forThreadNumIfSpecified(int threadNum, ExecutorService executorService) {
        if (threadNum >= 0) {
            return RocksDBStateDataTransferHelper.forThreadNum(threadNum);
        }
        return RocksDBStateDataTransferHelper.forExecutor(executorService);
    }

    private static ExecutorService getExecutorService(int threadNum) {
        if (threadNum > 1) {
            return java.util.concurrent.Executors.newFixedThreadPool(threadNum, (ThreadFactory)new ExecutorThreadFactory("Flink-RocksDBStateDataTransferHelper"));
        }
        return Executors.newDirectExecutorService();
    }

    RocksDBStateDataTransferHelper(ExecutorService executorService, Closeable closeable) {
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.closeable = (Closeable)Preconditions.checkNotNull((Object)closeable);
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

