/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.api.functions.sink.PrintSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkContextUtil;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrintSinkFunctionTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    @Before
    public void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @After
    public void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    public void testPrintSinkStdOut() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintSinkStdErr() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction(true);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayErrorStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintSinkWithPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 2, 1));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("2> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintSinkWithIdentifierAndPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction("mySink", false);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 2, 1));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("mySink:2> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintSinkWithIdentifierButNoPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction("mySink", false);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("mySink> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }
}

