/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.SinkTransformationTranslatorITCaseBase;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SinkV1TransformationTranslatorITCase
extends SinkTransformationTranslatorITCaseBase<Sink<Integer, ?, ?, ?>> {
    @Override
    Sink<Integer, ?, ?, ?> simpleSink() {
        return TestSink.newBuilder().build();
    }

    @Override
    Sink<Integer, ?, ?, ?> sinkWithCommitter() {
        return TestSink.newBuilder().setDefaultCommitter().build();
    }

    @Override
    DataStreamSink<Integer> sinkTo(DataStream<Integer> stream, Sink<Integer, ?, ?, ?> sink) {
        return stream.sinkTo(sink);
    }

    @Test
    public void generateWriterCommitterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        StreamNode committerNode = this.findCommitter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        if (this.runtimeExecutionMode == RuntimeExecutionMode.STREAMING) {
            MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)4));
        } else {
            MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)4));
            this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        }
        StreamNode lastNode = committerNode;
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(lastNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    @Test
    public void generateWriterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setGlobalCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        StreamNode committerNode = this.findCommitter(streamGraph);
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        this.validateTopology(committerNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    @Test
    public void testSettingOperatorUidHash() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromData((Object[])new Integer[]{1, 2});
        String writerHash = "f6b178ce445dc3ffaa06bad27a51fead";
        String committerHash = "68ac8ae79eae4e3135a54f9689c4aa10";
        String globalCommitterHash = "77e6aa6eeb1643b3765e1e4a7a672f37";
        CustomSinkOperatorUidHashes operatorsUidHashes = CustomSinkOperatorUidHashes.builder().setWriterUidHash("f6b178ce445dc3ffaa06bad27a51fead").setCommitterUidHash("68ac8ae79eae4e3135a54f9689c4aa10").setGlobalCommitterUidHash("77e6aa6eeb1643b3765e1e4a7a672f37").build();
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), operatorsUidHashes).name("FileSink");
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getUserHash(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getUserHash(), (Object)"68ac8ae79eae4e3135a54f9689c4aa10");
        Assert.assertEquals((Object)this.findGlobalCommitter(streamGraph).getUserHash(), (Object)"77e6aa6eeb1643b3765e1e4a7a672f37");
    }

    @Test
    public void testSettingOperatorUids() {
        String sinkUid = "f6b178ce445dc3ffaa06bad27a51fead";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromData((Object[])new Integer[]{1, 2});
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build()).name("FileSink").uid("f6b178ce445dc3ffaa06bad27a51fead");
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getTransformationUID(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getTransformationUID(), (Object)String.format("Sink Committer: %s", "f6b178ce445dc3ffaa06bad27a51fead"));
        Assert.assertEquals((Object)this.findGlobalCommitter(streamGraph).getTransformationUID(), (Object)String.format("Sink %s Global Committer", "f6b178ce445dc3ffaa06bad27a51fead"));
    }
}

