/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.timestamps.BoundedOutOfOrdernessTimestampExtractor;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BoundedOutOfOrdernessTimestampExtractorTest {
    BoundedOutOfOrdernessTimestampExtractorTest() {
    }

    @Test
    void testInitializationAndRuntime() {
        Time maxAllowedLateness = Time.milliseconds((long)10L);
        LongExtractor extractor = new LongExtractor(maxAllowedLateness);
        Assertions.assertThat((long)extractor.getMaxOutOfOrdernessInMillis()).isEqualTo(maxAllowedLateness.toMilliseconds());
        this.runValidTests(extractor);
    }

    @Test
    void testInitialFinalAndWatermarkUnderflow() {
        LongExtractor extractor = new LongExtractor(Time.milliseconds((long)10L));
        Assertions.assertThat((long)extractor.getCurrentWatermark().getTimestamp()).isEqualTo(Long.MIN_VALUE);
        extractor.extractTimestamp(Long.MIN_VALUE, -1L);
        extractor.extractTimestamp(-9223372036854775806L, -1L);
        Assertions.assertThat((long)extractor.getCurrentWatermark().getTimestamp()).isEqualTo(Long.MIN_VALUE);
        extractor.extractTimestamp(Long.MAX_VALUE, -1L);
        Assertions.assertThat((long)extractor.getCurrentWatermark().getTimestamp()).isEqualTo(0x7FFFFFFFFFFFFFF5L);
    }

    private void runValidTests(BoundedOutOfOrdernessTimestampExtractor<Long> extractor) {
        Assertions.assertThat((Object)extractor.getCurrentWatermark()).isEqualTo((Object)Watermark.UNINITIALIZED);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)13L, 0L)).isEqualTo(13L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)13L, 0L)).isEqualTo(13L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)14L, 0L)).isEqualTo(14L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((Object)extractor.getCurrentWatermark()).isEqualTo((Object)new Watermark(10L));
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)500L, 0L)).isEqualTo(500L);
        Assertions.assertThat((Object)extractor.getCurrentWatermark()).isEqualTo((Object)new Watermark(490L));
        Assertions.assertThat((long)extractor.extractTimestamp((Object)0x7FFFFFFFFFFFFFFEL, 0L)).isEqualTo(0x7FFFFFFFFFFFFFFEL);
        Assertions.assertThat((Object)extractor.getCurrentWatermark()).isEqualTo((Object)new Watermark(0x7FFFFFFFFFFFFFF4L));
    }

    private static class LongExtractor
    extends BoundedOutOfOrdernessTimestampExtractor<Long> {
        private static final long serialVersionUID = 1L;

        public LongExtractor(Time maxAllowedLateness) {
            super(maxAllowedLateness);
        }

        public long extractTimestamp(Long element) {
            return element;
        }
    }
}

