/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.MockResultPartitionWriter;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class RecordWriterOutputTest {
    RecordWriterOutputTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testDisableUnalignedCheckpoint(boolean supportsUnalignedCheckpoints) throws IOException {
        final LinkedList queue = new LinkedList();
        RecordWriter task1 = new RecordWriterBuilder().build((ResultPartitionWriter)new MockResultPartitionWriter(){

            public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) {
                queue.add(Tuple2.of((Object)event, (Object)isPriorityEvent));
            }
        });
        RecordWriterOutput writerOutput = new RecordWriterOutput(task1, (TypeSerializer)LongSerializer.INSTANCE, null, supportsUnalignedCheckpoints);
        CheckpointBarrier unalignedBarrier = new CheckpointBarrier(0L, 1L, CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault()));
        writerOutput.broadcastEvent((AbstractEvent)unalignedBarrier, true);
        this.assertAlignmentTypeAndIsPriorityEvent((Tuple2<AbstractEvent, Boolean>)((Tuple2)queue.poll()), supportsUnalignedCheckpoints ? CheckpointOptions.AlignmentType.UNALIGNED : CheckpointOptions.AlignmentType.FORCED_ALIGNED, supportsUnalignedCheckpoints);
        CheckpointBarrier alignedTimeoutBarrier = new CheckpointBarrier(0L, 1L, CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (long)1000L));
        writerOutput.broadcastEvent((AbstractEvent)alignedTimeoutBarrier, false);
        this.assertAlignmentTypeAndIsPriorityEvent((Tuple2<AbstractEvent, Boolean>)((Tuple2)queue.poll()), supportsUnalignedCheckpoints ? CheckpointOptions.AlignmentType.ALIGNED : CheckpointOptions.AlignmentType.FORCED_ALIGNED, false);
    }

    private void assertAlignmentTypeAndIsPriorityEvent(Tuple2<AbstractEvent, Boolean> unalignedResult, CheckpointOptions.AlignmentType expectedAlignmentType, boolean isPriorityEvent) {
        Assertions.assertThat(unalignedResult).isNotNull();
        Assertions.assertThat((Object)unalignedResult.f0).isInstanceOf(CheckpointBarrier.class);
        Assertions.assertThat((Comparable)((CheckpointBarrier)unalignedResult.f0).getCheckpointOptions().getAlignment()).isSameAs((Object)expectedAlignmentType);
        Assertions.assertThat((Boolean)((Boolean)unalignedResult.f1)).isEqualTo(isPriorityEvent);
    }
}

