/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowStagger;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TumblingEventTimeWindowsTest {
    TumblingEventTimeWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4999L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testWindowAssignmentWithStagger() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)0L), (WindowStagger)WindowStagger.NATURAL);
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)150L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 150L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(150L, 5150L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5099L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(150L, 5150L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5300L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5150L, 10150L)});
    }

    @Test
    void testWindowAssignmentWithGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)100L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 100L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5099L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5100L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5100L, 10100L)});
    }

    @Test
    void testWindowAssignmentWithNegativeGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)-100L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(-100L, 4900L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4899L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(-100L, 4900L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4900L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(4900L, 9900L)});
    }

    @Test
    void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.seconds((long)1L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 1000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5999L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 6000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(6000L, 11000L)});
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingEventTimeWindows.of((Time)Time.seconds((long)-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingEventTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)20L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingEventTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)-11L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
    }

    @Test
    void testProperties() {
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.milliseconds((long)100L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(EventTimeTrigger.class);
    }
}

