/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.Collection;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorTestBase;
import org.apache.flink.streaming.runtime.operators.sink.TestSinkV2;

class WithAdapterCommitterOperatorTest
extends CommitterOperatorTestBase {
    WithAdapterCommitterOperatorTest() {
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithPostCommit() {
        ForwardingCommitter committer = new ForwardingCommitter();
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSinkV2.newBuilder().setCommitter(committer).setWithPostCommitTopology(true).build()), () -> committer.successfulCommits);
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithPostCommitWithRetry() {
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSinkV2.newBuilder().setCommitter(new TestSinkV2.RetryOnceCommitter()).setWithPostCommitTopology(true).build()), () -> 0);
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithoutPostCommit() {
        ForwardingCommitter committer = new ForwardingCommitter();
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSinkV2.newBuilder().setCommitter(committer).build()), () -> committer.successfulCommits);
    }

    private static class ForwardingCommitter
    extends TestSinkV2.DefaultCommitter {
        private int successfulCommits = 0;

        private ForwardingCommitter() {
        }

        @Override
        public void commit(Collection<Committer.CommitRequest<String>> committables) {
            this.successfulCommits += committables.size();
        }

        @Override
        public void close() throws Exception {
        }
    }
}

