/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.timestamps;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.util.WatermarkStrategyWithPeriodicWatermarks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@PublicEvolving
public abstract class AscendingTimestampExtractor<T>
implements WatermarkStrategyWithPeriodicWatermarks<T> {
    private static final long serialVersionUID = 1L;
    private long currentTimestamp = Long.MIN_VALUE;
    private MonotonyViolationHandler violationHandler = new LoggingHandler();

    public abstract long extractAscendingTimestamp(T var1);

    public AscendingTimestampExtractor<T> withViolationHandler(MonotonyViolationHandler handler) {
        this.violationHandler = Objects.requireNonNull(handler);
        return this;
    }

    public final long extractTimestamp(T element, long elementPrevTimestamp) {
        long newTimestamp = this.extractAscendingTimestamp(element);
        if (newTimestamp >= this.currentTimestamp) {
            this.currentTimestamp = newTimestamp;
            return newTimestamp;
        }
        this.violationHandler.handleViolation(newTimestamp, this.currentTimestamp);
        return newTimestamp;
    }

    public final Watermark getCurrentWatermark() {
        return new Watermark(this.currentTimestamp == Long.MIN_VALUE ? Long.MIN_VALUE : this.currentTimestamp - 1L);
    }

    public static final class LoggingHandler
    implements MonotonyViolationHandler {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(AscendingTimestampExtractor.class);

        @Override
        public void handleViolation(long elementTimestamp, long lastTimestamp) {
            LOG.warn("Timestamp monotony violated: {} < {}", (Object)elementTimestamp, (Object)lastTimestamp);
        }
    }

    public static final class FailingHandler
    implements MonotonyViolationHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public void handleViolation(long elementTimestamp, long lastTimestamp) {
            throw new RuntimeException("Ascending timestamps condition violated. Element timestamp " + elementTimestamp + " is smaller than last timestamp " + lastTimestamp);
        }
    }

    public static final class IgnoringHandler
    implements MonotonyViolationHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public void handleViolation(long elementTimestamp, long lastTimestamp) {
        }
    }

    public static interface MonotonyViolationHandler
    extends Serializable {
        public void handleViolation(long var1, long var3);
    }
}

