/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
class StreamRecordQueueEntry<OUT>
implements StreamElementQueueEntry<OUT> {
    @Nonnull
    private final StreamRecord<?> inputRecord;
    private Collection<OUT> completedElements;

    StreamRecordQueueEntry(StreamRecord<?> inputRecord) {
        this.inputRecord = (StreamRecord)Preconditions.checkNotNull(inputRecord);
    }

    @Override
    public boolean isDone() {
        return this.completedElements != null;
    }

    @Nonnull
    public StreamRecord<?> getInputElement() {
        return this.inputRecord;
    }

    @Override
    public void emitResult(TimestampedCollector<OUT> output) {
        output.setTimestamp(this.inputRecord);
        for (OUT r : this.completedElements) {
            output.collect(r);
        }
    }

    @Override
    public void complete(Collection<OUT> result) {
        this.completedElements = (Collection)Preconditions.checkNotNull(result);
    }
}

